/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Iterator;
import java.util.LinkedList;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.Factor;
import org.AIspace.ve.Query;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.ItrIterator;

public abstract class Inference {
    static final boolean PRUNE_IRRELEVANT_VARIABLES_DEFAULT = true;
    static final Heuristics ELIMINATION_HEURISTIC_DEFAULT = Heuristics.MIN_FILL;
    final Configuration configuration;

    public final Configuration getConfiguration() {
        return this.configuration.clone();
    }

    public abstract Result getResult();

    Inference(Configuration configuration) {
        this.configuration = configuration.clone();
    }

    Inference(Inference inference) {
        this.configuration = inference.configuration.clone();
    }

    public static enum Heuristics {
        GIVEN,
        RANDOM,
        SEQUENTIAL,
        MIN_FACTOR,
        MIN_WEIGHT,
        MIN_DEGREE,
        MIN_SIZE,
        MIN_FILL,
        MIN_DEFICIENCY,
        MIN_DISCREPANCY,
        DEFAULT,
        MAX_CARDINALITY;

    }

    static abstract class Result {
        protected Configuration configuration;
        Factor factor;
        Factor normFactor;
        final LinkedList<Variable> prunedVariables;
        final LinkedList<Variable> eliminationOrdering;
        long maxFactorSize;
        long maxStoredFactorSize;
        Query.Result evidenceQueryResult;

        public Factor getFactor() {
            return this.factor;
        }

        public Factor getNormFactor() {
            if (this.normFactor == null) {
                throw new UnsupportedOperationException("Inference result should not be normalized.");
            }
            return this.normFactor;
        }

        public final Iterator<Variable> getPrunedVariables() {
            return new ItrIterator<Variable>(this.prunedVariables.iterator());
        }

        public final int getPrunedVariablesNum() {
            return this.prunedVariables.size();
        }

        public final Iterator<Variable> getEliminationOrdering() {
            return new ItrIterator<Variable>(this.eliminationOrdering.iterator());
        }

        public final int getEliminationOrderingSize() {
            return this.eliminationOrdering.size();
        }

        public final long getMaxFactorSize() {
            return this.maxFactorSize;
        }

        public final long getMaxStoredFactorSize() {
            return this.maxStoredFactorSize;
        }

        public final Query.Result getEvidenceQueryResult() {
            if (this.evidenceQueryResult == null) {
                throw new UnsupportedOperationException("Query wasn't a conditional expected utility query or there was no relevant observations.");
            }
            return this.evidenceQueryResult;
        }

        Result(Configuration configuration) {
            this.configuration = configuration;
            this.prunedVariables = new LinkedList();
            this.eliminationOrdering = new LinkedList();
        }

        Result(Result result) {
            this.factor = result.factor;
            this.normFactor = result.normFactor;
            this.prunedVariables = new LinkedList<Variable>(result.prunedVariables);
            this.eliminationOrdering = new LinkedList<Variable>(result.eliminationOrdering);
            this.maxFactorSize = result.maxFactorSize;
            this.maxStoredFactorSize = result.maxStoredFactorSize;
            if (result.evidenceQueryResult != null) {
                this.evidenceQueryResult = result.evidenceQueryResult.clone();
            }
        }

        public abstract void save();

        public String toString(boolean withId) {
            StringBuilder output = new StringBuilder();
            output.append("Result.factor:\n").append(this.factor.toString("   ", withId)).append("\n");
            if (this.normFactor != null) {
                output.append("Result.normFactor:\n").append(this.normFactor.toString("   ", withId)).append("\n");
            }
            output.append("Result.prunedVariables (").append(this.prunedVariables.size());
            if (this.prunedVariables.size() == 1) {
                output.append(" variable) = <");
            } else {
                output.append(" variables) = <");
            }
            for (Variable variable : this.prunedVariables) {
                output.append(variable.getName(withId)).append(", ");
            }
            if (this.prunedVariables.size() > 0) {
                output.delete(output.length() - 2, output.length());
            }
            output.append(">\n");
            output.append("Result.eliminationOrdering (").append(this.eliminationOrdering.size());
            if (this.eliminationOrdering.size() == 1) {
                output.append(" variable) = <");
            } else {
                output.append(" variables) = <");
            }
            for (Variable variable : this.eliminationOrdering) {
                output.append(variable.getName(withId)).append(", ");
            }
            if (this.eliminationOrdering.size() > 0) {
                output.delete(output.length() - 2, output.length());
            }
            output.append(">\n");
            output.append("Result.maxFactorSize = ").append(this.maxFactorSize);
            output.append("\nResult.maxStoredFactorSize = ").append(this.maxStoredFactorSize);
            if (this.evidenceQueryResult != null) {
                output.append("\n---------- Evidence query ----------\n");
                output.append(this.evidenceQueryResult.toString(withId));
            }
            return output.toString();
        }

        public String toString() {
            return this.toString(true);
        }

        public abstract Result clone();
    }
}

