/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Variable;

@Immutable
final class MoralGraph {
    private final HashMap<Variable, HashSet<Variable>> neighbors = new HashMap();

    MoralGraph(DecisionNetwork.DNGraph dag) {
        Iterator variablesIterator = dag.getNodes();
        while (variablesIterator.hasNext()) {
            this.neighbors.put((Variable)variablesIterator.next(), new HashSet());
        }
        variablesIterator = dag.getNodes();
        while (variablesIterator.hasNext()) {
            Variable child = (Variable)variablesIterator.next();
            Iterator<Variable> parentsIterator = dag.getParents(child);
            HashSet<Variable> neighboursSet = this.neighbors.get(child);
            while (parentsIterator.hasNext()) {
                neighboursSet.add(parentsIterator.next());
            }
            parentsIterator = dag.getParents(child);
            while (parentsIterator.hasNext()) {
                Variable parent = parentsIterator.next();
                neighboursSet = this.neighbors.get(parent);
                neighboursSet.add(child);
                Iterator<Variable> parentsIteratorBis = dag.getParents(child);
                while (parentsIteratorBis.hasNext()) {
                    Variable parentBis = parentsIteratorBis.next();
                    if (parent.equals(parentBis)) continue;
                    neighboursSet.add(parentBis);
                }
            }
        }
    }

    int markRelevant(Set<Variable> relevantVariables, Variable relevantVariable, Set<Variable> observedVariables, DecisionNetwork decisionNetwork) {
        int result = 0;
        if (!relevantVariables.contains(relevantVariable)) {
            relevantVariables.add(relevantVariable);
            result = 1;
            if (!observedVariables.contains(relevantVariable)) {
                for (Variable neighbor : this.neighbors.get(relevantVariable)) {
                    result += this.markRelevant(relevantVariables, neighbor, observedVariables, decisionNetwork);
                }
            }
        }
        return result;
    }
}

