/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Iterator;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorStore;
import org.AIspace.ve.FactorSumOut;
import org.AIspace.ve.FactorTimes;
import org.AIspace.ve.Query;
import org.AIspace.ve.Variable;

public final class QueryCompute
extends Query {
    public QueryCompute(Variable[] queryVars, DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(queryVars, decisionNetwork, observedVars, observedVals, configuration);
        this.performInference(queryVars, decisionNetwork, observedVars, observedVals);
    }

    public QueryCompute(DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(decisionNetwork, observedVars, observedVals, configuration);
        this.performInference(decisionNetwork, observedVars, observedVals);
    }

    QueryCompute(FactorStore factors, Configuration configuration) {
        super(configuration);
        this.result.factor = this.eliminateVariables(factors);
    }

    @Override
    Factor eliminateVariables(FactorStore factors) {
        while (factors.hasNext()) {
            Variable[] sumOut;
            FactorSumOut newFac;
            Variable elimVar = factors.next();
            this.result.eliminationOrdering.add(elimVar);
            Iterator<Factor> toMultiply = factors.enumFactorsRemoved();
            Factor product = toMultiply.next();
            while (toMultiply.hasNext()) {
                Factor nextProd = toMultiply.next();
                product = new FactorTimes(product, nextProd);
            }
            if (this.result.maxFactorSize < product.getSize()) {
                this.result.maxFactorSize = product.getSize();
            }
            if (this.result.maxStoredFactorSize < (newFac = FactorSumOut.create(product, sumOut = new Variable[]{elimVar}, this.configuration.getFactorSavingForTracing())).getSize()) {
                this.result.maxStoredFactorSize = newFac.getSize();
            }
            factors.addFactorComputed(newFac);
        }
        Iterator<Factor> remainingFactors = factors.enumFactorsFinal();
        Factor product = remainingFactors.next();
        while (remainingFactors.hasNext()) {
            product = new FactorTimes(product, remainingFactors.next());
        }
        if (this.result.maxFactorSize < product.getSize()) {
            this.result.maxFactorSize = product.getSize();
        }
        return product;
    }
}

