/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.AIspace.ve.NamedAndUnique;
import org.AIspace.ve.domains.Domain;

@Immutable
public abstract class Variable
implements Comparable<Variable>,
NamedAndUnique {
    private final String name;
    private final Domain<?> domain;
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId;

    @Override
    public final String getName(boolean withId) {
        if (withId) {
            return String.valueOf(this.name) + "[" + this.uniqueId + "]";
        }
        return this.name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final Domain<?> getDomain() {
        return this.domain;
    }

    @Override
    public int getId() {
        return this.uniqueId;
    }

    protected Variable(String name, Domain<?> domain) {
        this.name = name;
        this.domain = domain;
        this.uniqueId = nextId.getAndIncrement();
    }

    public boolean equals(Object var) {
        return this.uniqueId == ((Variable)var).uniqueId;
    }

    @Override
    public int compareTo(Variable var) {
        return this.uniqueId - var.uniqueId;
    }

    public final int hashCode() {
        return this.uniqueId;
    }

    @Override
    public String toString(boolean withId) {
        StringBuilder output = new StringBuilder(this.name);
        if (withId) {
            output.append("[").append(this.uniqueId).append("]");
        }
        output.append(", domain = " + this.domain.toString(withId));
        return output.toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public final Object clone() {
        throw new UnsupportedOperationException("Variable has its own unique ID. It can't be cloned. Also it is virtually immutable so there is no point in cloning.");
    }

    static final Variable[] unionVars(Variable[] variables1, Variable[] variables2) {
        Variable[] variables = new Variable[variables1.length + variables2.length];
        int pos = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < variables1.length && i2 < variables2.length) {
            if (variables1[i1].equals(variables2[i2])) {
                variables[pos++] = variables1[i1++];
                ++i2;
                continue;
            }
            variables[pos++] = variables1[i1].compareTo(variables2[i2]) < 0 ? variables1[i1++] : variables2[i2++];
        }
        while (i1 < variables1.length) {
            variables[pos++] = variables1[i1++];
        }
        while (i2 < variables2.length) {
            variables[pos++] = variables2[i2++];
        }
        Variable[] result = new Variable[pos];
        System.arraycopy(variables, 0, result, 0, pos);
        return result;
    }

    static final Variable[] diffVars(Variable[] variables1, Variable[] variables2) {
        Variable[] variables = new Variable[variables1.length];
        int pos = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < variables1.length && i2 < variables2.length) {
            if (variables1[i1].equals(variables2[i2])) {
                ++i1;
                ++i2;
                continue;
            }
            if (variables1[i1].compareTo(variables2[i2]) < 0) {
                variables[pos++] = variables1[i1++];
                continue;
            }
            ++i2;
        }
        while (i1 < variables1.length) {
            variables[pos++] = variables1[i1++];
        }
        Variable[] result = new Variable[pos];
        System.arraycopy(variables, 0, result, 0, pos);
        return result;
    }

    static final Variable[] diffVars2(Variable[] variables1, List<Variable> variables2) {
        LinkedHashSet<Variable> tempVars1 = new LinkedHashSet<Variable>(Arrays.asList(variables1));
        for (Variable variable : variables2) {
            tempVars1.remove(variable);
        }
        return tempVars1.toArray(new Variable[tempVars1.size()]);
    }

    static final Variable[] removeVariable(Variable[] variables, Variable variable) {
        Variable[] result = new Variable[variables.length - 1];
        int pos = 0;
        while (variables[pos].compareTo(variable) < 0) {
            result[pos] = variables[pos++];
        }
        while (pos < result.length) {
            result[pos++] = variables[pos];
        }
        return result;
    }

    static final Variable[] insert(Variable variable, Variable[] variables) {
        Variable[] result = new Variable[variables.length + 1];
        int pos = 0;
        while (pos < variables.length && variables[pos].compareTo(variable) < 0) {
            result[pos] = variables[pos++];
        }
        if (pos < variables.length && variables[pos].equals(variable)) {
            throw new IllegalArgumentException("Variable " + variable + " is already among list of variables!");
        }
        result[pos] = variable;
        while (pos < variables.length) {
            result[pos + 1] = variables[pos++];
        }
        return result;
    }

    static final Variable[] attach(Variable[] variables, Variable variable) {
        Variable[] result = new Variable[variables.length + 1];
        System.arraycopy(variables, 0, result, 0, variables.length);
        result[variables.length] = variable;
        return result;
    }

    static final Variable[] sort(Variable[] array) {
        Object[] sorted = new Variable[array.length];
        System.arraycopy(array, 0, sorted, 0, array.length);
        Arrays.sort(sorted);
        return sorted;
    }

    static final void shuffle(Variable[] variables) {
        int i = variables.length - 1;
        while (i > 0) {
            int pos = (int)(Math.random() * (double)(i + 1));
            if (pos != i) {
                Variable tmp = variables[i];
                variables[i] = variables[pos];
                variables[pos] = tmp;
            }
            --i;
        }
    }
}

