/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.domains;

import java.lang.reflect.Array;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.AIspace.ve.domains.Domain;
import org.AIspace.ve.tools.ItrArray;
import org.AIspace.ve.tools.Utils;

@Immutable
public class DomainStored<T>
extends Domain<T> {
    private final T[] domain;

    @Override
    public final T getValue(int index) {
        if (index < 0 || index >= this.domain.length) {
            throw new IllegalArgumentException("");
        }
        return this.domain[index];
    }

    @Override
    public final int getValueIndex(Object value) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final boolean containsValue(Object value) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final int getSize() {
        return this.domain.length;
    }

    @Override
    public final Iterator<T> iterator() {
        return new ItrArray<T>(this.domain, this.domain.length);
    }

    public DomainStored(T[] domainArray, Class<T> type, boolean copyDomain) {
        if (domainArray.length == 0) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        if (Utils.duplicates(domainArray)) {
            throw new IllegalArgumentException("Domain contains duplicate values.");
        }
        if (copyDomain) {
            this.domain = (Object[])Array.newInstance(type, domainArray.length);
            System.arraycopy(domainArray, 0, this.domain, 0, domainArray.length);
        } else {
            this.domain = domainArray;
        }
    }
}

