/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.domains.setGenerators;

import net.jcip.annotations.Immutable;
import org.AIspace.ve.domains.setGenerators.SetGenerator;

@Immutable
public final class SetGeneratorInteger
implements SetGenerator<Integer> {
    private final int min;
    private final int max;

    @Override
    public int size() {
        return this.max - this.min + 1;
    }

    @Override
    public Integer value(int i) {
        if (i < 0 || i > this.max - this.min) {
            throw new IllegalArgumentException("Illegal index.");
        }
        return this.min + i;
    }

    @Override
    public int valueIndex(Object value) {
        if (value instanceof Integer && ((Integer)value).compareTo(this.max) <= 0 && ((Integer)value).compareTo(this.min) >= 0) {
            return (Integer)value - this.min;
        }
        return -1;
    }

    @Override
    public boolean couldBeValue(Object value) {
        return value instanceof Integer && ((Integer)value).compareTo(this.max) <= 0 && ((Integer)value).compareTo(this.min) >= 0;
    }

    public SetGeneratorInteger(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Wrong minimum and maximum values.");
        }
        this.min = min;
        this.max = max;
    }
}

