/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.domains.setGenerators;

import net.jcip.annotations.Immutable;
import org.AIspace.ve.domains.setGenerators.SetGenerator;

@Immutable
public final class SetGeneratorString
implements SetGenerator<String> {
    private final String prefix;
    private final int min;
    private final int max;

    @Override
    public int size() {
        return this.max - this.min + 1;
    }

    @Override
    public String value(int i) {
        if (i < 0 || i > this.max - this.min) {
            throw new IllegalArgumentException("Illegal index.");
        }
        return String.valueOf(this.prefix) + Integer.toString(this.min + i);
    }

    @Override
    public int valueIndex(Object value) {
        if (value instanceof String && ((String)value).startsWith(this.prefix)) {
            int intValue;
            try {
                intValue = new Integer(((String)value).substring(this.prefix.length()));
            }
            catch (NumberFormatException e) {
                return -1;
            }
            if (intValue <= this.max && intValue >= this.min) {
                return intValue - this.min;
            }
        }
        return -1;
    }

    @Override
    public boolean couldBeValue(Object value) {
        if (value instanceof String && ((String)value).startsWith(this.prefix)) {
            int intValue;
            try {
                intValue = new Integer(((String)value).substring(this.prefix.length()));
            }
            catch (NumberFormatException e) {
                return false;
            }
            return intValue <= this.max && intValue >= this.min;
        }
        return false;
    }

    public SetGeneratorString(String prefix, int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Wrong minimum and maximum values.");
        }
        this.prefix = prefix;
        this.min = min;
        this.max = max;
    }
}

