/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.examples;

import org.AIspace.ve.FactorCPT;
import org.AIspace.ve.FactorNormalise;
import org.AIspace.ve.FactorObserved;
import org.AIspace.ve.FactorSumOut;
import org.AIspace.ve.FactorTimes;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableNature;
import org.AIspace.ve.domains.predefined.DomainBoolean;

public class FactorsArithmeticInference {
    public static void main(String[] args) {
        VariableNature tampering = new VariableNature("tampering", DomainBoolean.instanceReversed);
        VariableNature fire = new VariableNature("fire", DomainBoolean.instanceReversed);
        VariableNature alarm = new VariableNature("alarm", DomainBoolean.instanceReversed);
        VariableNature smoke = new VariableNature("smoke", DomainBoolean.instanceReversed);
        VariableNature leaving = new VariableNature("leaving", DomainBoolean.instanceReversed);
        VariableNature report = new VariableNature("report", DomainBoolean.instanceReversed);
        System.out.println("VARIABLES:");
        System.out.println(tampering);
        System.out.println(fire);
        System.out.println(alarm);
        System.out.println(smoke);
        System.out.println(leaving);
        System.out.println(report + "\n");
        FactorCPT tamperingCPD = new FactorCPT(new Variable[]{tampering}, false, 0, new double[]{0.02, 0.98}, false, 0.0);
        FactorCPT fireCPD = new FactorCPT(new Variable[]{fire}, false, 0, new double[]{0.01, 0.99}, false, 0.0);
        FactorCPT alarmCPD = new FactorCPT(new Variable[]{tampering, fire, alarm}, false, 2, new double[]{0.5, 0.5, 0.85, 0.15, 0.99, 0.01, 1.0E-4, 0.9999}, false, 0.0);
        FactorCPT smokeCPD = new FactorCPT(new Variable[]{fire, smoke}, false, 1, new double[]{0.9, 0.1, 0.01, 0.99}, false, 0.0);
        FactorCPT leavingCPD = new FactorCPT(new Variable[]{alarm, leaving}, false, 1, new double[]{0.88, 0.12, 0.001, 0.999}, false, 0.0);
        FactorCPT reportCPD = new FactorCPT(new Variable[]{leaving, report}, false, 1, new double[]{0.75, 0.25, 0.01, 0.99}, false, 0.0);
        System.out.println("FACTORS:");
        System.out.println(String.valueOf(tamperingCPD.getInterpretation(false)) + ":\n" + tamperingCPD + "\n");
        System.out.println(String.valueOf(fireCPD.getInterpretation(false)) + ":\n" + fireCPD + "\n");
        System.out.println(String.valueOf(alarmCPD.getInterpretation(false)) + ":\n" + alarmCPD + "\n");
        System.out.println(String.valueOf(smokeCPD.getInterpretation(false)) + ":\n" + smokeCPD + "\n");
        System.out.println(String.valueOf(leavingCPD.getInterpretation(false)) + ":\n" + leavingCPD + "\n");
        System.out.println(String.valueOf(reportCPD.getInterpretation(false)) + ":\n" + reportCPD + "\n");
        FactorObserved f7 = FactorObserved.projectObservation(leavingCPD, new Variable[]{leaving}, new int[1], true);
        FactorObserved f8 = FactorObserved.projectObservation(reportCPD, new Variable[]{leaving}, new int[1], true);
        System.out.println(String.valueOf(f7.getInterpretation(false)) + ":\n" + f7 + "\n");
        System.out.println(String.valueOf(f8.getInterpretation(false)) + ":\n" + f8 + "\n");
        FactorSumOut f9 = FactorSumOut.create(new FactorTimes(tamperingCPD, alarmCPD), new Variable[]{tampering}, false);
        FactorSumOut f10 = FactorSumOut.create(f8, new Variable[]{report}, false);
        FactorSumOut f11 = FactorSumOut.create(new FactorTimes(f7, f9), new Variable[]{alarm}, false);
        FactorSumOut f12 = FactorSumOut.create(new FactorTimes(fireCPD, new FactorTimes(smokeCPD, f11)), new Variable[]{fire}, false);
        FactorNormalise result = new FactorNormalise(new FactorTimes(f10, f12));
        System.out.println("RESULT:");
        System.out.println("P(smoke | leaving = 'True'):\n" + result + "\n");
    }
}

