/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.parsers.XMLBIFv0_3;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorCPT;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.FactorUtility;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;
import org.AIspace.ve.VariableNature;
import org.AIspace.ve.domains.DomainStored;
import org.AIspace.ve.properties.Property;
import org.AIspace.ve.properties.PropertyGeneric;
import org.AIspace.ve.properties.PropertyPosition;
import org.AIspace.ve.tools.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DecisionNetworkFromXMLBIFv0_3
extends DecisionNetwork {
    public static Pair<List<DecisionNetwork>, List<String>> create(String string, Configuration configuration) throws Exception {
        return DecisionNetworkFromXMLBIFv0_3.parseXML(new InputSource(new StringReader(string)), configuration, true);
    }

    public static Pair<List<DecisionNetwork>, List<String>> create(BufferedReader file, Configuration configuration) throws Exception {
        return DecisionNetworkFromXMLBIFv0_3.parseXML(new InputSource(file), configuration, true);
    }

    public static Pair<List<DecisionNetwork>, List<String>> create(Document document, Configuration configuration) throws Exception {
        return DecisionNetworkFromXMLBIFv0_3.parseXML(document, configuration, true);
    }

    public static Pair<List<DecisionNetwork>, List<String>> create(String string, boolean checkNoForgetting, Configuration configuration) throws Exception {
        return DecisionNetworkFromXMLBIFv0_3.parseXML(new InputSource(new StringReader(string)), configuration, checkNoForgetting);
    }

    public static Pair<List<DecisionNetwork>, List<String>> create(BufferedReader file, boolean checkNoForgetting, Configuration configuration) throws Exception {
        return DecisionNetworkFromXMLBIFv0_3.parseXML(new InputSource(file), configuration, checkNoForgetting);
    }

    public static Pair<List<DecisionNetwork>, List<String>> create(Document document, boolean checkNoForgetting, Configuration configuration) throws Exception {
        return DecisionNetworkFromXMLBIFv0_3.parseXML(document, configuration, checkNoForgetting);
    }

    private static Pair<List<DecisionNetwork>, List<String>> parseXML(InputSource source, Configuration configuration, boolean checkNoForgetting) throws Exception {
        Pair<List<DecisionNetwork>, List<String>> result = new Pair<List<DecisionNetwork>, List<String>>(new LinkedList(), new LinkedList());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        MyErrorHandler errorHandler = new MyErrorHandler(result.getSecondElement());
        schemaFactory.setErrorHandler(errorHandler);
        Schema schema = schemaFactory.newSchema(new StreamSource(DecisionNetworkFromXMLBIFv0_3.class.getResourceAsStream("XMLBIFv0_3.xsd")));
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setCoalescing(true);
        builderFactory.setExpandEntityReferences(true);
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        builderFactory.setSchema(schema);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        builder.setErrorHandler(errorHandler);
        Document document = builder.parse(source);
        Node nodeBIF = document.getFirstChild();
        while (!(nodeBIF == null || nodeBIF.getNodeType() == 1 && nodeBIF.getNodeName().equals("BIF"))) {
            nodeBIF = nodeBIF.getNextSibling();
            nodeBIF = nodeBIF.getNextSibling();
        }
        if (!nodeBIF.getAttributes().getNamedItem("VERSION").getNodeValue().equals("0.3")) {
            ((List)result.getSecondElement()).add("BIF version is not 0.3.");
        }
        Node nodeNetwork = nodeBIF.getFirstChild();
        while (nodeNetwork != null) {
            if (nodeNetwork.getNodeType() == 1 && nodeNetwork.getNodeName().equals("NETWORK")) {
                result.getFirstElement().add(new DecisionNetworkFromXMLBIFv0_3(configuration, nodeNetwork, checkNoForgetting, result.getSecondElement()));
            }
            nodeNetwork = nodeNetwork.getNextSibling();
        }
        return result;
    }

    private static Pair<List<DecisionNetwork>, List<String>> parseXML(Document document, Configuration configuration, boolean checkNoForgetting) throws Exception {
        Pair<List<DecisionNetwork>, List<String>> result = new Pair<List<DecisionNetwork>, List<String>>(new LinkedList(), new LinkedList());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        MyErrorHandler errorHandler = new MyErrorHandler(result.getSecondElement());
        schemaFactory.setErrorHandler(errorHandler);
        Schema schema = schemaFactory.newSchema(new StreamSource(DecisionNetworkFromXMLBIFv0_3.class.getResourceAsStream("XMLBIFv0_3.xsd")));
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
        Node nodeBIF = document.getFirstChild();
        while (!(nodeBIF == null || nodeBIF.getNodeType() == 1 && nodeBIF.getNodeName().equals("BIF"))) {
            nodeBIF = nodeBIF.getNextSibling();
            nodeBIF = nodeBIF.getNextSibling();
        }
        if (!nodeBIF.getAttributes().getNamedItem("VERSION").getNodeValue().equals("0.3")) {
            ((List)result.getSecondElement()).add("BIF version is not 0.3.");
        }
        Node nodeNetwork = nodeBIF.getFirstChild();
        while (nodeNetwork != null) {
            if (nodeNetwork.getNodeType() == 1 && nodeNetwork.getNodeName().equals("NETWORK")) {
                result.getFirstElement().add(new DecisionNetworkFromXMLBIFv0_3(configuration, nodeNetwork, checkNoForgetting, result.getSecondElement()));
            }
            nodeNetwork = nodeNetwork.getNextSibling();
        }
        return result;
    }

    private DecisionNetworkFromXMLBIFv0_3(Configuration configuration, Node networkNode, boolean checkNoForgetting, List<String> warnings) throws Exception {
        super(configuration);
        LinkedList<Node> variableNodes = new LinkedList<Node>();
        LinkedList<Node> definitionNodes = new LinkedList<Node>();
        Node childNode = networkNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() == 1) {
                if (childNode.getNodeName().equals("NAME")) {
                    String networkName = DecisionNetworkFromXMLBIFv0_3.collectText(childNode);
                    if (networkName.length() == 0) {
                        warnings.add("Empty network name.");
                    }
                    this.setName(networkName);
                } else if (childNode.getNodeName().equals("PROPERTY")) {
                    String propertyString = DecisionNetworkFromXMLBIFv0_3.collectText(childNode);
                    if (Property.parseName(propertyString).equals("position")) {
                        this.addProperty(PropertyPosition.parse(propertyString));
                    } else {
                        this.addProperty(PropertyGeneric.parse(propertyString));
                    }
                } else if (childNode.getNodeName().equals("VARIABLE")) {
                    variableNodes.add(childNode);
                } else if (childNode.getNodeName().equals("DEFINITION")) {
                    definitionNodes.add(childNode);
                }
            }
            childNode = childNode.getNextSibling();
        }
        String utilityName = null;
        LinkedList<Property> utilityProperties = null;
        for (Node variableNode : variableNodes) {
            String variableName = null;
            LinkedList<String> variableDomain = new LinkedList<String>();
            LinkedList<Property> variableProperties = new LinkedList<Property>();
            Node childNode2 = variableNode.getFirstChild();
            while (childNode2 != null) {
                if (childNode2.getNodeType() == 1) {
                    if (childNode2.getNodeName().equals("NAME")) {
                        variableName = DecisionNetworkFromXMLBIFv0_3.collectText(childNode2);
                        if (variableName.length() == 0) {
                            warnings.add("Empty variable name.");
                        }
                    } else if (childNode2.getNodeName().equals("OUTCOME")) {
                        String domainElement = DecisionNetworkFromXMLBIFv0_3.collectText(childNode2);
                        if (domainElement.length() == 0) {
                            warnings.add("Empty element in the domain" + (variableName != null ? " of variable '" + variableName + "'" : "") + ".");
                        }
                        variableDomain.add(domainElement);
                    } else if (childNode2.getNodeName().equals("PROPERTY")) {
                        String propertyString = DecisionNetworkFromXMLBIFv0_3.collectText(childNode2);
                        if (Property.parseName(propertyString).equals("position")) {
                            variableProperties.add(PropertyPosition.parse(propertyString));
                        } else {
                            variableProperties.add(PropertyGeneric.parse(propertyString));
                        }
                    }
                }
                childNode2 = childNode2.getNextSibling();
            }
            String variableType = DecisionNetworkFromXMLBIFv0_3.collectText(variableNode.getAttributes().getNamedItem("TYPE"));
            if (variableType.equals("nature")) {
                this.addVariable(new VariableNature(variableName, new DomainStored<String>(variableDomain.toArray(new String[variableDomain.size()]), String.class, false)), variableProperties.iterator());
                continue;
            }
            if (variableType.equals("decision")) {
                this.addVariable(new VariableDecision(variableName, new DomainStored<String>(variableDomain.toArray(new String[variableDomain.size()]), String.class, false)), variableProperties.iterator());
                continue;
            }
            if (!variableType.equals("utility")) continue;
            if (utilityProperties != null) {
                throw new IllegalArgumentException("Duplicate utility variable definition.");
            }
            utilityName = variableName;
            if (variableDomain.size() != 0) {
                warnings.add("OUTCOME elements in the definition of the utility variable will be ignored.");
            }
            utilityProperties = variableProperties;
        }
        for (Node definitionNode : definitionNodes) {
            Variable child = null;
            LinkedList<Variable> parents = new LinkedList<Variable>();
            LinkedList<Property> definitionProperties = new LinkedList<Property>();
            String values = null;
            Node childNode3 = definitionNode.getFirstChild();
            while (childNode3 != null) {
                if (childNode3.getNodeType() == 1) {
                    if (childNode3.getNodeName().equals("FOR")) {
                        if (child != null) {
                            throw new IllegalArgumentException("Duplicate FOR element inside a DEFINITION element for variable '" + child.getName(false) + "'.");
                        }
                        String childName = DecisionNetworkFromXMLBIFv0_3.collectText(childNode3);
                        if (!childName.equals(utilityName) && (child = this.getVariable(childName)) == null) {
                            throw new IllegalArgumentException("Unknown variable name '" + childName + "'inside a DEFINITION element.");
                        }
                    } else if (childNode3.getNodeName().equals("TABLE")) {
                        if (values != null) {
                            throw new IllegalArgumentException("Duplicate TABLE element inside a DEFINITION element" + (child != null ? " for variable '" + child.getName(false) : "'."));
                        }
                        values = DecisionNetworkFromXMLBIFv0_3.collectText(childNode3);
                    } else if (childNode3.getNodeName().equals("GIVEN")) {
                        String parentName = DecisionNetworkFromXMLBIFv0_3.collectText(childNode3);
                        Variable parent = this.getVariable(parentName);
                        if (parent == null) {
                            throw new IllegalArgumentException("Unknown variable name '" + parentName + "' inside a DEFINITION element" + (child != null ? " for variable " + child.getName(false) : "."));
                        }
                        parents.add(parent);
                    } else if (childNode3.getNodeName().equals("PROPERTY")) {
                        String propertyString = DecisionNetworkFromXMLBIFv0_3.collectText(childNode3);
                        if (Property.parseName(propertyString).equals("position")) {
                            definitionProperties.add(PropertyPosition.parse(propertyString));
                        } else {
                            definitionProperties.add(PropertyGeneric.parse(propertyString));
                        }
                    }
                }
                childNode3 = childNode3.getNextSibling();
            }
            if (child == null) {
                if (utilityName == null) {
                    throw new IllegalArgumentException("Utility variable is not specified.");
                }
                if (values == null) {
                    throw new IllegalArgumentException("TABLE element missing in the DEFINITION element for utility variable '" + utilityName + "'.");
                }
                if (definitionProperties.size() != 0) {
                    warnings.add("Properties from the DEFINITION element for the utility variable '" + utilityName + "' moved to the VARIABLE element for the utility variable " + utilityName + ".");
                    utilityProperties.addAll(definitionProperties);
                }
                try {
                    this.addUtility(new FactorUtility(parents.toArray(new Variable[parents.size()]), false, values, Pattern.compile("\\s+"), utilityName), utilityProperties.iterator());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("DEFINITION element for the utility variable '" + utilityName + "'. " + e.getMessage());
                }
            }
            if (child instanceof VariableDecision) {
                try {
                    if (values == null) {
                        this.addParents((VariableDecision)child, parents.toArray(new Variable[parents.size()]), definitionProperties.iterator());
                        continue;
                    }
                    this.addFactor(new FactorDecision(parents.toArray(new Variable[parents.size()]), (VariableDecision)child, values, Pattern.compile("\\s+")), definitionProperties.iterator());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("DEFINITION element for the decision variable '" + child.getName(false) + "'. " + e.getMessage());
                }
            }
            if (values == null) {
                throw new IllegalArgumentException("TABLE element missing in the DEFINITION element for variable '" + child.getName(false) + "'.");
            }
            parents.add(child);
            try {
                this.addFactor(new FactorCPT(parents.toArray(new Variable[parents.size()]), false, parents.size() - 1, values, Pattern.compile("\\s+"), this.factorStructuredThreshold()), definitionProperties.iterator());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("DEFINITION element for the variable '" + child.getName(false) + "'. " + e.getMessage());
            }
        }
        this.finishConstruction(checkNoForgetting);
    }

    private static String collectText(Node node) {
        StringBuilder output = new StringBuilder();
        Node childNode = node.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() == 3 && childNode.getNodeValue().trim().length() != 0) {
                if (output.length() != 0) {
                    output.append(" ");
                }
                output.append(childNode.getNodeValue());
            }
            childNode = childNode.getNextSibling();
        }
        return output.toString();
    }

    public static Document saveToDOM(DecisionNetwork decisionNetwork) throws ParserConfigurationException {
        Element givenDefinitionNode;
        Iterator<Variable> definitionVariablesIterator;
        Element forDefinitionNode;
        Document result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        result.setXmlVersion("1.0");
        Element bifNode = result.createElement("BIF");
        bifNode.setAttribute("VERSION", "0.3");
        bifNode.setAttribute("xmlns", "http://www.cs.ubc.ca/labs/lci/fopi/ve/XMLBIFv0_3");
        bifNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        bifNode.setAttribute("xsi:schemaLocation", "http://www.cs.ubc.ca/labs/lci/fopi/ve/XMLBIFv0_3 http://www.cs.ubc.ca/labs/lci/fopi/ve/XMLBIFv0_3/XMLBIFv0_3.xsd");
        result.appendChild(bifNode);
        Element networkNode = result.createElement("NETWORK");
        String name = decisionNetwork.getName(false);
        if (name == null || name.trim().equals("")) {
            name = "Untitled";
        }
        Element nameNode = result.createElement("NAME");
        nameNode.setTextContent(name);
        networkNode.appendChild(nameNode);
        Iterator<Property> networkPropertiesIterator = decisionNetwork.properties().get();
        while (networkPropertiesIterator.hasNext()) {
            Element propertyNode = result.createElement("PROPERTY");
            propertyNode.setTextContent(networkPropertiesIterator.next().toString());
            networkNode.appendChild(propertyNode);
        }
        LinkedList<VariableDecision> decisionVariablesWithoutFunction = new LinkedList<VariableDecision>();
        Iterator<Variable> variablesIterator = decisionNetwork.getVariables();
        while (variablesIterator.hasNext()) {
            Element variableNode = result.createElement("VARIABLE");
            Variable currentVariable = variablesIterator.next();
            DecisionNetwork.VariableProperties currentVariableProperties = decisionNetwork.variableProperties(currentVariable);
            if (currentVariable instanceof VariableNature) {
                variableNode.setAttribute("TYPE", "nature");
            } else if (currentVariable instanceof VariableDecision) {
                variableNode.setAttribute("TYPE", "decision");
                if (currentVariableProperties.getFactorsNum() == 0) {
                    decisionVariablesWithoutFunction.add((VariableDecision)currentVariable);
                }
            } else {
                throw new UnsupportedOperationException("Unknown type for variable '" + currentVariable.getName(false) + "'.");
            }
            Element variableNameNode = result.createElement("NAME");
            variableNameNode.setTextContent(currentVariable.getName(false));
            variableNode.appendChild(variableNameNode);
            Iterator<?> domainIterator = currentVariable.getDomain().iterator();
            while (domainIterator.hasNext()) {
                Element variableOutcomeNode = result.createElement("OUTCOME");
                variableOutcomeNode.setTextContent(domainIterator.next().toString());
                variableNode.appendChild(variableOutcomeNode);
            }
            Iterator<Property> variablePropertiesIterator = currentVariableProperties.getVariableProperties().get();
            while (variablePropertiesIterator.hasNext()) {
                Element variablePropertyNode = result.createElement("PROPERTY");
                variablePropertyNode.setTextContent(variablePropertiesIterator.next().toString());
                variableNode.appendChild(variablePropertyNode);
            }
            networkNode.appendChild(variableNode);
        }
        FactorUtility utilFactor = null;
        if (decisionNetwork.isDecisionNetwork()) {
            utilFactor = decisionNetwork.getUtility();
            Element utilityVariableNode = result.createElement("VARIABLE");
            utilityVariableNode.setAttribute("TYPE", "utility");
            Element utilityVariableNameNode = result.createElement("NAME");
            utilityVariableNameNode.setTextContent(utilFactor.getUtilityName());
            utilityVariableNode.appendChild(utilityVariableNameNode);
            Iterator<Property> utilityPropertiesIterator = decisionNetwork.utilityProperties().get();
            while (utilityPropertiesIterator.hasNext()) {
                Element utilityVariablePropertyNode = result.createElement("PROPERTY");
                utilityVariablePropertyNode.setTextContent(utilityPropertiesIterator.next().toString());
                utilityVariableNode.appendChild(utilityVariablePropertyNode);
            }
            networkNode.appendChild(utilityVariableNode);
        }
        Iterator<Factor> factorsIterator = decisionNetwork.getFactors(false);
        while (factorsIterator.hasNext()) {
            Element definitionNode = result.createElement("DEFINITION");
            Factor curFactor = factorsIterator.next();
            Variable childVariable = ((FactorDirected)((Object)curFactor)).getChild();
            forDefinitionNode = result.createElement("FOR");
            forDefinitionNode.setTextContent(childVariable.getName(false));
            definitionNode.appendChild(forDefinitionNode);
            definitionVariablesIterator = decisionNetwork.getParents(childVariable);
            while (definitionVariablesIterator.hasNext()) {
                givenDefinitionNode = result.createElement("GIVEN");
                givenDefinitionNode.setTextContent(definitionVariablesIterator.next().getName(false));
                definitionNode.appendChild(givenDefinitionNode);
            }
            Element tableDefinitionNode = result.createElement("TABLE");
            if (childVariable instanceof VariableNature) {
                FactorIterator elementsIterator;
                if (((FactorDirected)((Object)curFactor)).getChildIndex() != curFactor.getVariablesNum() - 1) {
                    Variable[] variables = new Variable[curFactor.getVariablesNum()];
                    variablesIterator = curFactor.getVariables();
                    int index = ((FactorDirected)((Object)curFactor)).getChildIndex();
                    int j = 0;
                    while (j < index) {
                        variables[j++] = variablesIterator.next();
                    }
                    variables[variables.length - 1] = variablesIterator.next();
                    while (variablesIterator.hasNext()) {
                        variables[j++] = variablesIterator.next();
                    }
                    curFactor = curFactor.reorder(variables, false, false);
                }
                StringBuilder elements = new StringBuilder((elementsIterator = curFactor.iterator()).hasNext() ? String.valueOf(elementsIterator.next()) : "");
                while (elementsIterator.hasNext()) {
                    elements.append(" ").append(elementsIterator.next());
                }
                tableDefinitionNode.setTextContent(elements.toString());
            } else if (childVariable instanceof VariableDecision) {
                Iterator<Integer> actionsIterator = ((FactorDecision)curFactor).getDecisionFunctionValues();
                StringBuilder actions = new StringBuilder(actionsIterator.hasNext() ? String.valueOf(actionsIterator.next()) : "");
                while (actionsIterator.hasNext()) {
                    actions.append(" ").append(actionsIterator.next());
                }
                tableDefinitionNode.setTextContent(actions.toString());
            }
            definitionNode.appendChild(tableDefinitionNode);
            Iterator<Property> definitionPropertiesIterator = decisionNetwork.variableProperties(childVariable).getDefinitionProperties().get();
            while (definitionPropertiesIterator.hasNext()) {
                Element definitionPropertyNode = result.createElement("PROPERTY");
                definitionPropertyNode.setTextContent(definitionPropertiesIterator.next().toString());
                definitionNode.appendChild(definitionPropertyNode);
            }
            networkNode.appendChild(definitionNode);
        }
        if (decisionNetwork.isDecisionNetwork()) {
            Iterator decisionVariablesIterator = decisionVariablesWithoutFunction.iterator();
            while (decisionVariablesIterator.hasNext()) {
                Element definitionNode = result.createElement("DEFINITION");
                VariableDecision currentVariable = (VariableDecision)decisionVariablesIterator.next();
                forDefinitionNode = result.createElement("FOR");
                forDefinitionNode.setTextContent(currentVariable.getName(false));
                definitionNode.appendChild(forDefinitionNode);
                definitionVariablesIterator = decisionNetwork.getParents(currentVariable);
                while (definitionVariablesIterator.hasNext()) {
                    givenDefinitionNode = result.createElement("GIVEN");
                    givenDefinitionNode.setTextContent(definitionVariablesIterator.next().getName(false));
                    definitionNode.appendChild(givenDefinitionNode);
                }
                Iterator<Property> definitionPropertiesIterator = decisionNetwork.variableProperties(currentVariable).getDefinitionProperties().get();
                while (definitionPropertiesIterator.hasNext()) {
                    Element definitionPropertyNode = result.createElement("PROPERTY");
                    definitionPropertyNode.setTextContent(definitionPropertiesIterator.next().toString());
                    definitionNode.appendChild(definitionPropertyNode);
                }
                networkNode.appendChild(definitionNode);
            }
            Element utilityDefinitionNode = result.createElement("DEFINITION");
            Element forUtilityDefinitionNode = result.createElement("FOR");
            forUtilityDefinitionNode.setTextContent(utilFactor.getUtilityName());
            utilityDefinitionNode.appendChild(forUtilityDefinitionNode);
            Iterator<Variable> utilityDefinitionVariablesIterator = utilFactor.getVariables();
            while (utilityDefinitionVariablesIterator.hasNext()) {
                Element givenDefinitionNode2 = result.createElement("GIVEN");
                givenDefinitionNode2.setTextContent(utilityDefinitionVariablesIterator.next().getName(false));
                utilityDefinitionNode.appendChild(givenDefinitionNode2);
            }
            Element tableUtilityDefinitionNode = result.createElement("TABLE");
            FactorIterator elementsIterator = utilFactor.iterator();
            StringBuilder elements = new StringBuilder(elementsIterator.hasNext() ? String.valueOf(elementsIterator.next()) : "");
            while (elementsIterator.hasNext()) {
                elements.append(" ").append(elementsIterator.next());
            }
            tableUtilityDefinitionNode.setTextContent(elements.toString());
            utilityDefinitionNode.appendChild(tableUtilityDefinitionNode);
            networkNode.appendChild(utilityDefinitionNode);
        }
        bifNode.appendChild(networkNode);
        result.getDocumentElement().normalize();
        return result;
    }

    public static String saveToString(DecisionNetwork decisionNetwork) {
        Iterator<Property> definitionPropertiesIterator;
        Iterator<Variable> variablesIterator;
        Formatter output = new Formatter();
        output.format("%s\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        output.format("%s\n", "<BIF VERSION=\"0.3\"  xmlns=\"http://www.cs.ubc.ca/labs/lci/fopi/ve/XMLBIFv0_3\"");
        output.format("\t%s\n", "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        output.format("\t%s\n", "xsi:schemaLocation=\"http://www.cs.ubc.ca/labs/lci/fopi/ve/XMLBIFv0_3 http://www.cs.ubc.ca/labs/lci/fopi/ve/XMLBIFv0_3/XMLBIFv0_3.xsd\">");
        output.format("%s\n", "<NETWORK>");
        String name = decisionNetwork.getName(false);
        if (name == null || name.trim().equals("")) {
            name = "Untitled";
        }
        output.format("<NAME>%s</NAME>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(name));
        Iterator<Property> networkPropertiesIterator = decisionNetwork.properties().get();
        while (networkPropertiesIterator.hasNext()) {
            output.format("<PROPERTY>%s</PROPERTY>\n", networkPropertiesIterator.next().toString());
        }
        LinkedList<VariableDecision> decisionVariablesWithoutFunction = new LinkedList<VariableDecision>();
        Iterator<Variable> nVarsIterator = decisionNetwork.getVariables();
        while (nVarsIterator.hasNext()) {
            Variable currentVariable = nVarsIterator.next();
            DecisionNetwork.VariableProperties currentVariableProperties = decisionNetwork.variableProperties(currentVariable);
            if (currentVariable instanceof VariableNature) {
                output.format("\n%s\n", "<VARIABLE TYPE=\"nature\">");
            } else if (currentVariable instanceof VariableDecision) {
                output.format("\n%s\n", "<VARIABLE TYPE=\"decision\">");
                if (currentVariableProperties.getFactorsNum() == 0) {
                    decisionVariablesWithoutFunction.add((VariableDecision)currentVariable);
                }
            } else {
                throw new UnsupportedOperationException("Unknown type for variable '" + currentVariable.getName(false) + "'!");
            }
            output.format("\t<NAME>%s</NAME>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(currentVariable.getName(false)));
            Iterator<?> domainIterator = currentVariable.getDomain().iterator();
            while (domainIterator.hasNext()) {
                output.format("\t<OUTCOME>%s</OUTCOME>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(domainIterator.next().toString()));
            }
            Iterator<Property> variablePropertiesIterator = currentVariableProperties.getVariableProperties().get();
            while (variablePropertiesIterator.hasNext()) {
                output.format("\t<PROPERTY>%s</PROPERTY>\n", variablePropertiesIterator.next().toString());
            }
            output.format("%s\n", "</VARIABLE>");
        }
        FactorUtility utilFactor = null;
        if (decisionNetwork.isDecisionNetwork()) {
            utilFactor = decisionNetwork.getUtility();
            output.format("\n%s\n", "<VARIABLE TYPE=\"utility\">");
            output.format("\t<NAME>%s</NAME>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(utilFactor.getUtilityName()));
            Iterator<Property> utilityPropertiesIterator = decisionNetwork.utilityProperties().get();
            while (utilityPropertiesIterator.hasNext()) {
                output.format("\t<PROPERTY>%s</PROPERTY>\n", utilityPropertiesIterator.next().toString());
            }
            output.format("%s\n", "</VARIABLE>");
        }
        Iterator<Factor> factorsIterator = decisionNetwork.getFactors(false);
        while (factorsIterator.hasNext()) {
            Factor curFactor = factorsIterator.next();
            Variable childVariable = ((FactorDirected)((Object)curFactor)).getChild();
            output.format("\n%s\n", "<DEFINITION>");
            output.format("\t<FOR>%s</FOR>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(childVariable.getName(false)));
            variablesIterator = ((FactorDirected)((Object)curFactor)).getParents();
            while (variablesIterator.hasNext()) {
                output.format("\t<GIVEN>%s</GIVEN>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(variablesIterator.next().getName(false)));
            }
            if (childVariable instanceof VariableNature) {
                if (((FactorDirected)((Object)curFactor)).getChildIndex() != curFactor.getVariablesNum() - 1) {
                    Variable[] variables = new Variable[curFactor.getVariablesNum()];
                    variablesIterator = curFactor.getVariables();
                    int index = ((FactorDirected)((Object)curFactor)).getChildIndex();
                    int j = 0;
                    while (j < index) {
                        variables[j++] = variablesIterator.next();
                    }
                    variables[variables.length - 1] = variablesIterator.next();
                    while (variablesIterator.hasNext()) {
                        variables[j++] = variablesIterator.next();
                    }
                    curFactor = curFactor.reorder(variables, false, false);
                }
                output.format("\t%s", "<TABLE>");
                FactorIterator elementsIterator = curFactor.iterator();
                if (elementsIterator.hasNext()) {
                    output.format("%s", elementsIterator.next());
                }
                while (elementsIterator.hasNext()) {
                    output.format(" %s", elementsIterator.next());
                }
                output.format("%s\n", "</TABLE>");
            } else if (childVariable instanceof VariableDecision) {
                output.format("\t%s", "<TABLE>");
                Iterator<Integer> actnItr = ((FactorDecision)curFactor).getDecisionFunctionValues();
                if (actnItr.hasNext()) {
                    output.format("%s", actnItr.next());
                }
                while (actnItr.hasNext()) {
                    output.format(" %s", actnItr.next());
                }
                output.format("%s\n", "</TABLE>");
            }
            definitionPropertiesIterator = decisionNetwork.variableProperties(childVariable).getDefinitionProperties().get();
            while (definitionPropertiesIterator.hasNext()) {
                output.format("\t<PROPERTY>%s</PROPERTY>\n", definitionPropertiesIterator.next().toString());
            }
            output.format("%s\n", "</DEFINITION>");
        }
        if (decisionNetwork.isDecisionNetwork()) {
            for (VariableDecision currentVariable : decisionVariablesWithoutFunction) {
                output.format("\n%s\n", "<DEFINITION>");
                output.format("\t<FOR>%s</FOR>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(currentVariable.getName(false)));
                variablesIterator = decisionNetwork.getParents(currentVariable);
                while (variablesIterator.hasNext()) {
                    output.format("\t<GIVEN>%s</GIVEN>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(variablesIterator.next().getName(false)));
                }
                definitionPropertiesIterator = decisionNetwork.variableProperties(currentVariable).getDefinitionProperties().get();
                while (definitionPropertiesIterator.hasNext()) {
                    output.format("\t<PROPERTY>%s</PROPERTY>\n", definitionPropertiesIterator.next().toString());
                }
                output.format("%s\n", "</DEFINITION>");
            }
            output.format("\n%s\n", "<DEFINITION>");
            output.format("\t<FOR>%s</FOR>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(utilFactor.getUtilityName()));
            Iterator<Variable> variablesIterator2 = utilFactor.getVariables();
            while (variablesIterator2.hasNext()) {
                output.format("\t<GIVEN>%s</GIVEN>\n", DecisionNetworkFromXMLBIFv0_3.replaceWithEntities(variablesIterator2.next().getName(false)));
            }
            FactorIterator elementsIterator = utilFactor.iterator();
            output.format("\t%s", "<TABLE>");
            if (elementsIterator.hasNext()) {
                output.format("%s", elementsIterator.next());
            }
            while (elementsIterator.hasNext()) {
                output.format(" %s", elementsIterator.next());
            }
            output.format("%s\n", "</TABLE>");
            output.format("%s\n", "</DEFINITION>");
        }
        output.format("%s\n", "</NETWORK>");
        output.format("%s", "</BIF>");
        return output.toString();
    }

    private static String replaceWithEntities(String input) {
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static final class MyErrorHandler
    implements ErrorHandler {
        private final List<String> warnings;

        private MyErrorHandler(List<String> warnings) {
            this.warnings = warnings;
        }

        @Override
        public void warning(SAXParseException spe) {
            if (spe.getLineNumber() != -1 && spe.getColumnNumber() != 0) {
                this.warnings.add(String.valueOf(spe.getMessage().replace("\"http://www.cs.ubc.ca/labs/lci/fopi/XMLBIFv0_4\":", "")) + " Line " + spe.getLineNumber() + ", column " + spe.getColumnNumber() + ".");
            } else {
                this.warnings.add(spe.getMessage());
            }
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            if (spe.getLineNumber() != -1 && spe.getColumnNumber() != 0) {
                throw new SAXException(String.valueOf(spe.getMessage().replace("\"http://www.cs.ubc.ca/labs/lci/fopi/XMLBIFv0_4\":", "")) + " Line " + spe.getLineNumber() + ", column " + spe.getColumnNumber() + ".");
            }
            throw new SAXException(spe.getMessage());
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            if (spe.getLineNumber() != -1 && spe.getColumnNumber() != 0) {
                throw new SAXException(String.valueOf(spe.getMessage().replace("\"http://www.cs.ubc.ca/labs/lci/fopi/XMLBIFv0_4\":", "")) + " Line " + spe.getLineNumber() + ", column " + spe.getColumnNumber() + ".");
            }
            throw new SAXException(spe.getMessage());
        }
    }
}

