/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.parsers.factors;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.FactorUtility;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;
import org.AIspace.ve.properties.Property;
import org.AIspace.ve.properties.PropertyGeneric;
import org.AIspace.ve.properties.PropertyPosition;
import org.AIspace.ve.tools.Pair;
import org.AIspace.ve.tools.Triple;

public class DecisionNetworkFromFactors
extends DecisionNetwork {
    public DecisionNetworkFromFactors(String name, Variable[] variables, Factor[] factors, Pair<VariableDecision, Variable[]>[] parents, FactorUtility utility, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        Object[] objectArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = objectArray[n2];
            this.addVariable(variable, null);
            ++n2;
        }
        objectArray = factors;
        n = factors.length;
        n2 = 0;
        while (n2 < n) {
            Comparable<Variable> factor = objectArray[n2];
            this.addFactor((Factor)factor, null);
            ++n2;
        }
        if (parents != null) {
            objectArray = parents;
            n = parents.length;
            n2 = 0;
            while (n2 < n) {
                Object pair = objectArray[n2];
                this.addParents((VariableDecision)((Pair)pair).getFirstElement(), (Variable[])((Pair)pair).getSecondElement(), null);
                ++n2;
            }
        }
        if (utility != null) {
            this.addUtility(utility, null);
        }
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(String name, Pair<Variable, Iterator<Property>>[] variables, Pair<Factor, Iterator<Property>>[] factors, Triple<VariableDecision, Variable[], Iterator<Property>>[] parents, Pair<FactorUtility, Iterator<Property>> utility, Iterator<Property> properties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        Object[] objectArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<Variable, Iterator<Property>> variable = objectArray[n2];
            this.addVariable(variable.getFirstElement(), variable.getSecondElement());
            ++n2;
        }
        objectArray = factors;
        n = factors.length;
        n2 = 0;
        while (n2 < n) {
            Pair<Comparable<Variable>, Iterator<Property>> factor = objectArray[n2];
            this.addFactor((Factor)factor.getFirstElement(), factor.getSecondElement());
            ++n2;
        }
        if (parents != null) {
            objectArray = parents;
            n = parents.length;
            n2 = 0;
            while (n2 < n) {
                Object triple = objectArray[n2];
                this.addParents((VariableDecision)((Triple)triple).getFirstElement(), (Variable[])((Triple)triple).getSecondElement(), (Iterator)((Triple)triple).getThirdElement());
                ++n2;
            }
        }
        if (utility != null) {
            this.addUtility(utility.getFirstElement(), utility.getSecondElement());
        }
        this.addProperties(properties);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(String name, Iterator<Variable> variables, Iterator<Factor> factors, Iterator<Pair<VariableDecision, Variable[]>> parents, FactorUtility utility, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        while (variables.hasNext()) {
            this.addVariable(variables.next(), null);
        }
        while (factors.hasNext()) {
            this.addFactor(factors.next(), null);
        }
        if (parents != null) {
            while (parents.hasNext()) {
                Pair<VariableDecision, Variable[]> pair = parents.next();
                this.addParents(pair.getFirstElement(), pair.getSecondElement(), null);
            }
        }
        if (utility != null) {
            this.addUtility(utility, null);
        }
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(String name, Iterator<Pair<Variable, Iterator<Property>>> variables, Iterator<Pair<Factor, Iterator<Property>>> factors, Iterator<Triple<VariableDecision, Variable[], Iterator<Property>>> parents, Pair<FactorUtility, Iterator<Property>> utility, Iterator<Property> properties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        while (variables.hasNext()) {
            Pair<Variable, Iterator<Property>> variable = variables.next();
            this.addVariable(variable.getFirstElement(), variable.getSecondElement());
        }
        while (factors.hasNext()) {
            Pair<Factor, Iterator<Property>> factor = factors.next();
            this.addFactor(factor.getFirstElement(), factor.getSecondElement());
        }
        if (parents != null) {
            while (parents.hasNext()) {
                Triple<VariableDecision, Variable[], Iterator<Property>> triple = parents.next();
                this.addParents(triple.getFirstElement(), triple.getSecondElement(), triple.getThirdElement());
            }
        }
        if (utility != null) {
            this.addUtility(utility.getFirstElement(), utility.getSecondElement());
        }
        this.addProperties(properties);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, FactorDecision[] policy, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        Iterator<Variable> variables = decisionNetwork.getVariables();
        while (variables.hasNext()) {
            this.addVariable(variables.next(), null);
        }
        Iterator<Factor> factors = decisionNetwork.getFactors(false);
        while (factors.hasNext()) {
            this.addFactor(factors.next(), null);
        }
        FactorDecision[] factorDecisionArray = policy;
        int n = policy.length;
        int n2 = 0;
        while (n2 < n) {
            FactorDecision decisionFunction = factorDecisionArray[n2];
            this.addFactor(decisionFunction, null);
            ++n2;
        }
        this.addUtility(decisionNetwork.getUtility(), null);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, Pair<FactorDecision, Iterator<Property>>[] policy, Iterator<Property> networkProperties, boolean copyProperties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        if (copyProperties) {
            Iterator<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                Variable variable = variables.next();
                this.addVariable(variable, decisionNetwork.variableProperties(variable).getVariableProperties().get());
            }
            Iterator<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                Factor factor = factors.next();
                this.addFactor(factor, decisionNetwork.variableProperties(((FactorDirected)((Object)factor)).getChild()).getDefinitionProperties().get());
            }
            Pair<FactorDecision, Iterator<Property>>[] pairArray = policy;
            int n = policy.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = pairArray[n2];
                if (decisionFunction.getSecondElement() == null) {
                    this.addFactor(decisionFunction.getFirstElement(), decisionNetwork.variableProperties(decisionFunction.getFirstElement().getChild()).getDefinitionProperties().get());
                } else {
                    this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
                }
                ++n2;
            }
            this.addUtility(decisionNetwork.getUtility(), decisionNetwork.utilityProperties().get());
            if (networkProperties == null) {
                this.addProperties(decisionNetwork.properties().get());
            } else {
                this.addProperties(networkProperties);
            }
        } else {
            Iterator<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                this.addVariable(variables.next(), null);
            }
            Iterator<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                this.addFactor(factors.next(), null);
            }
            Pair<FactorDecision, Iterator<Property>>[] pairArray = policy;
            int n = policy.length;
            int n3 = 0;
            while (n3 < n) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = pairArray[n3];
                this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
                ++n3;
            }
            this.addUtility(decisionNetwork.getUtility(), null);
            if (networkProperties != null) {
                while (networkProperties.hasNext()) {
                    this.addProperty(networkProperties.next());
                }
            }
        }
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, Iterator<FactorDecision> policy, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        Iterator<Variable> variables = decisionNetwork.getVariables();
        while (variables.hasNext()) {
            this.addVariable(variables.next(), null);
        }
        Iterator<Factor> factors = decisionNetwork.getFactors(false);
        while (factors.hasNext()) {
            this.addFactor(factors.next(), null);
        }
        while (policy.hasNext()) {
            this.addFactor(policy.next(), null);
        }
        this.addUtility(decisionNetwork.getUtility(), null);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, Iterator<Pair<FactorDecision, Iterator<Property>>> policy, Iterator<Property> networkProperties, boolean copyProperties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        if (copyProperties) {
            Iterator<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                Variable variable = variables.next();
                this.addVariable(variable, decisionNetwork.variableProperties(variable).getVariableProperties().get());
            }
            Iterator<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                Factor factor = factors.next();
                this.addFactor(factor, decisionNetwork.variableProperties(((FactorDirected)((Object)factor)).getChild()).getDefinitionProperties().get());
            }
            while (policy.hasNext()) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = policy.next();
                if (decisionFunction.getSecondElement() == null) {
                    this.addFactor(decisionFunction.getFirstElement(), decisionNetwork.variableProperties(decisionFunction.getFirstElement().getChild()).getDefinitionProperties().get());
                    continue;
                }
                this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
            }
            this.addUtility(decisionNetwork.getUtility(), decisionNetwork.utilityProperties().get());
            if (networkProperties == null) {
                this.addProperties(decisionNetwork.properties().get());
            } else {
                this.addProperties(networkProperties);
            }
        } else {
            Iterator<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                this.addVariable(variables.next(), null);
            }
            Iterator<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                this.addFactor(factors.next(), null);
            }
            while (policy.hasNext()) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = policy.next();
                this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
            }
            this.addUtility(decisionNetwork.getUtility(), null);
            if (networkProperties != null) {
                while (networkProperties.hasNext()) {
                    this.addProperty(networkProperties.next());
                }
            }
        }
        this.finishConstruction(true);
    }

    public static String saveToString(DecisionNetwork decisionNetwork) {
        String networkName = decisionNetwork.getName(false);
        if (!DecisionNetworkFromFactors.isJavaIdentifier(networkName)) {
            throw new UnsupportedOperationException("Network's name \"" + networkName + "\" is not a valid Java identifier!");
        }
        Formatter output = new Formatter();
        output.format("%s\n", "import java.util.Arrays;");
        output.format("%s\n\n", "import java.util.Iterator;");
        output.format("%s\n", "import org.AIspace.ve.Configuration;");
        output.format("%s\n", "import org.AIspace.ve.DecisionNetwork;");
        output.format("%s\n", "import org.AIspace.ve.Factor;");
        output.format("%s\n", "import org.AIspace.ve.FactorCPT;");
        output.format("%s\n", "import org.AIspace.ve.FactorUtility;");
        output.format("%s\n", "import org.AIspace.ve.Variable;");
        output.format("%s\n", "import org.AIspace.ve.VariableDecision;");
        output.format("%s\n", "import org.AIspace.ve.VariableNature;");
        output.format("%s\n", "import org.AIspace.ve.domains.DomainStored;");
        output.format("%s\n", "import org.AIspace.ve.properties.Property;");
        output.format("%s\n", "import org.AIspace.ve.properties.PropertyPosition;");
        output.format("%s\n", "import org.AIspace.ve.tools.Pair;");
        output.format("%s\n", "import org.AIspace.ve.tools.Triple;");
        output.format("%s\n", "import org.AIspace.ve.parsers.factors.DecisionNetworkFromFactors;");
        output.format("\n%s\n", "/**");
        output.format(" * Generated by org.AIspace.ve.Factors.DecisionNetworkFromFactors.saveToString() from \"%s\".\n", networkName);
        output.format("%s\n", " */");
        output.format("public class %s {\n", networkName);
        output.format("\n\t%s\n", "/**");
        output.format("\t%s\n", " * @param args not used.");
        output.format("\t%s\n", " */");
        output.format("\t%s\n", "@SuppressWarnings(\"unchecked\")");
        output.format("\t%s\n", "public static void main(String[] args) {");
        output.format("\t\t%s\n", "// Set up inference configuration");
        output.format("\t\t%s\n", "Configuration configuration = new Configuration();");
        output.format("\t\tconfiguration.setFactorSavingForTracing(%b);\n", decisionNetwork.factorSavingForTracing());
        output.format("\t\tconfiguration.setFactorStructuredThreshold(%s);\n", decisionNetwork.factorStructuredThreshold());
        output.format("\n\t\t%s\n", "// Create the network");
        output.format("\t\t%s\n", "// Variables");
        output.format("\t\tPair<Variable, Iterator<Property>>[] variables = new Pair[%d]; // @SuppressWarnings(\"unchecked\")\n", decisionNetwork.getNumVariables());
        Iterator<Variable> variablesIterator = decisionNetwork.getVariables();
        int i = 0;
        LinkedList<VariableDecision> decisionVariables = new LinkedList<VariableDecision>();
        HashMap<Variable, Integer> variableToIndex = new HashMap<Variable, Integer>();
        while (variablesIterator.hasNext()) {
            Variable variable = variablesIterator.next();
            variableToIndex.put(variable, i);
            DecisionNetwork.VariableProperties variableProperties = decisionNetwork.variableProperties(variable);
            if (variable instanceof VariableDecision && variableProperties.getFactorsNum() == 0) {
                decisionVariables.add((VariableDecision)variable);
            }
            Iterator<?> domainIterator = variable.getDomain().iterator();
            Formatter domain = new Formatter();
            domain.format("new DomainStored<String>(new String[]{\"%s\"", DecisionNetworkFromFactors.replaceWithEscapes(domainIterator.next().toString()));
            while (domainIterator.hasNext()) {
                domain.format(",\"%s\"", DecisionNetworkFromFactors.replaceWithEscapes(domainIterator.next().toString()));
            }
            domain.format("%s", "}, String.class, false)");
            output.format("\t\t variables[%d] = new Pair<Variable, Iterator<Property>>(new Variable%s(\"%s\", %s), %s);\n", i++, variable instanceof VariableDecision ? "Decision" : "Nature", DecisionNetworkFromFactors.replaceWithEscapes(variable.getName(false)), domain, DecisionNetworkFromFactors.generateProperties(variableProperties.getVariableProperties().get()));
        }
        output.format("\n\t\t%s\n", "// Factors");
        output.format("\t\tPair<Factor, Iterator<Property>>[] factors = new Pair[%d]; // @SuppressWarnings(\"unchecked\")\n", decisionNetwork.getNumProbFactors());
        Iterator<Factor> factorsIterator = decisionNetwork.getFactors(false);
        i = 0;
        while (factorsIterator.hasNext()) {
            Factor factor = factorsIterator.next();
            output.format("\t\t factors[%d] = new Pair<Factor, Iterator<Property>>(new FactorCPT(new Variable[]{%s", i++, factor.getVariablesNum() != 0 ? "variables[" + variableToIndex.get(factor.getVariable(0)) + "].getFirstElement()" : "");
            int j = 1;
            while (j < factor.getVariablesNum()) {
                output.format(",variables[%d].getFirstElement()", variableToIndex.get(factor.getVariable(j)));
                ++j;
            }
            FactorIterator elementsIterator = factor.iterator();
            output.format("}, false, %d, new double[]{%s", ((FactorDirected)((Object)factor)).getChildIndex(), elementsIterator.next());
            while (elementsIterator.hasNext()) {
                output.format(",%s", elementsIterator.next());
            }
            output.format("}, false, %s), %s);\n", decisionNetwork.factorStructuredThreshold(), DecisionNetworkFromFactors.generateProperties(decisionNetwork.variableProperties(((FactorDirected)((Object)factor)).getChild()).getDefinitionProperties().get()));
        }
        if (decisionNetwork.isDecisionNetwork()) {
            FactorUtility utility = decisionNetwork.getUtility();
            output.format("\n\t\t%s\n", "// Utility factor");
            output.format("\t\tPair<FactorUtility,Iterator<Property>> utility = new Pair(new FactorUtility(new Variable[]{%s", utility.getVariablesNum() != 0 ? "variables[" + variableToIndex.get(utility.getVariable(0)) + "].getFirstElement()" : "");
            int j = 1;
            while (j < utility.getVariablesNum()) {
                output.format(",variables[%s].getFirstElement()", variableToIndex.get(utility.getVariable(j)));
                ++j;
            }
            FactorIterator elementsIterator = utility.iterator();
            output.format("}, false, new double[]{%s", elementsIterator.next());
            while (elementsIterator.hasNext()) {
                output.format(",%s", elementsIterator.next());
            }
            output.format("}, false, \"%s\"), %s);\n", DecisionNetworkFromFactors.replaceWithEscapes(utility.getUtilityName()), DecisionNetworkFromFactors.generateProperties(decisionNetwork.utilityProperties().get()));
            output.format("\n\t\t%s\n", "// Parents of decision variables");
            output.format("\t\t%s", "Triple<VariableDecision, Variable[], Iterator<Property>>[] parents = new Triple[]{");
            boolean firstDV = true;
            Iterator decisionVariablesIterator = decisionVariables.iterator();
            while (decisionVariablesIterator.hasNext()) {
                if (firstDV) {
                    firstDV = false;
                } else {
                    output.format("%s", ", ");
                }
                VariableDecision decisionVariable = (VariableDecision)decisionVariablesIterator.next();
                output.format("new Triple<VariableDecision, Variable[], Iterator<Property>>((VariableDecision) variables[%d].getFirstElement(), new Variable[]{", variableToIndex.get(decisionVariable));
                boolean firstP = true;
                Iterator<Variable> parentsIterator = decisionNetwork.getParents(decisionVariable);
                while (parentsIterator.hasNext()) {
                    if (firstP) {
                        firstP = false;
                    } else {
                        output.format("%s", ", ");
                    }
                    output.format("variables[%d].getFirstElement()", variableToIndex.get(parentsIterator.next()));
                }
                output.format("}, %s)", DecisionNetworkFromFactors.generateProperties(decisionNetwork.variableProperties(decisionVariable).getDefinitionProperties().get()));
            }
            output.format("%s\n", "}; // @SuppressWarnings(\"unchecked\")");
        }
        String prefix = decisionNetwork.isDecisionNetwork() ? "decision" : "belief";
        output.format("\n\t\t%s\n", "// Network");
        output.format("\t\tDecisionNetwork %sNetwork;\n", prefix);
        output.format("\t\t%s\n", "try {");
        if (decisionNetwork.isDecisionNetwork()) {
            output.format("\t\t\tdecisionNetwork = new DecisionNetworkFromFactors(\"%s\", variables, factors, parents, utility, %s, configuration);\n", networkName, DecisionNetworkFromFactors.generateProperties(decisionNetwork.properties().get()));
        } else {
            output.format("\t\t\tbeliefNetwork = new DecisionNetworkFromFactors(\"%s\", variables, factors, null, null, %s, configuration);\n", networkName, DecisionNetworkFromFactors.generateProperties(decisionNetwork.properties().get()));
        }
        output.format("\t\t%s\n", "} catch (Exception e) {");
        output.format("\t\t\t%s\n", "System.out.println(\"Error: \" + e.toString());");
        output.format("\t\t\t%s\n", "return;");
        output.format("\t\t%s\n", "}");
        output.format("\t\tSystem.out.println(\"* '\" + %sNetwork.getName(false) + \"' network created.\");\n", prefix);
        output.format("\n\t\t%s\n", "// Display the network on the screen");
        output.format("\t\tSystem.out.println(\"\\n\" + %sNetwork.toString(false, false)); // In expanded form, without unique id-s\n", prefix);
        output.format("\t%s\n", "}");
        output.format("%s", "}");
        return output.toString();
    }

    private static boolean isJavaIdentifier(String string) {
        if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String replaceWithEscapes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String generateProperties(Iterator<Property> propertiesIterator) {
        if (!propertiesIterator.hasNext()) {
            return "null";
        }
        Formatter output = new Formatter();
        output.format("Arrays.asList(new Property[]{", new Object[0]);
        while (propertiesIterator.hasNext()) {
            Property property = propertiesIterator.next();
            if (property instanceof PropertyPosition) {
                output.format("new PropertyPosition(%s, %s)", ((PropertyPosition)property).getPosX(), ((PropertyPosition)property).getPosX());
            } else {
                output.format("new PropertyGeneric(\"%s\", \"%s\")", DecisionNetworkFromFactors.replaceWithEscapes(property.getName()), DecisionNetworkFromFactors.replaceWithEscapes(((PropertyGeneric)property).getValue()));
            }
            if (!propertiesIterator.hasNext()) continue;
            output.format(",", new Object[0]);
        }
        output.format("}).iterator()", new Object[0]);
        return output.toString();
    }
}

