/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.properties;

import net.jcip.annotations.Immutable;
import org.AIspace.ve.properties.Property;

@Immutable
public final class PropertyGeneric
extends Property {
    private final String value;

    public final String getValue() {
        return this.value;
    }

    public PropertyGeneric(String name, String value) {
        super(name);
        if (name.equals("position")) {
            throw new IllegalArgumentException("Position property must be stored in PropertyPosition object'.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Property's value is 'null'.");
        }
        if (name.indexOf(59) != -1) {
            throw new IllegalArgumentException("Property value contains ';' character.");
        }
        this.value = value;
    }

    @Override
    public final String toString() {
        return String.valueOf(super.toString()) + this.value;
    }

    public static final String parseValue(String propertyString) {
        String propertyStringTrimmed = propertyString.trim();
        int indexOfEquality = propertyStringTrimmed.indexOf(61);
        if (indexOfEquality == -1) {
            throw new IllegalArgumentException("Equality '=' sign missing in the property string.");
        }
        if (propertyStringTrimmed.indexOf(59) != -1) {
            throw new IllegalArgumentException("Property string contains ';' character.");
        }
        return propertyStringTrimmed.substring(indexOfEquality + 1, propertyStringTrimmed.length()).trim();
    }

    public static final PropertyGeneric parse(String propertyString) {
        return new PropertyGeneric(Property.parseName(propertyString), PropertyGeneric.parseValue(propertyString));
    }
}

