/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.tools;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ItrArraySkip<T>
implements Iterator<T> {
    private int cursor;
    private int skipIndex;
    private final T[] array;

    public ItrArraySkip(T[] array, int skipIndex) {
        if (skipIndex < 0 || skipIndex >= array.length) {
            throw new IllegalArgumentException("Invalid index of the element to be skipped.");
        }
        this.cursor = 0;
        this.array = array;
        this.skipIndex = skipIndex;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.array.length - (this.cursor != this.skipIndex ? 0 : 1);
    }

    @Override
    public T next() {
        if (this.cursor == this.skipIndex) {
            ++this.cursor;
        }
        if (this.cursor == this.array.length) {
            throw new NoSuchElementException();
        }
        return this.array[this.cursor++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

