/*
 * Decompiled with CFR 0.152.
 */
package CIspace.Constraint;

import CIspace.Constraint.CnsConstraintEdge;
import CIspace.Constraint.ConstraintVariable;
import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPgraph;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.ConstraintEdge;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Point;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Stack;

public class ConstraintCSP
extends CSP {
    private Stack pivotNodes = new Stack();

    ConstraintCSP(Frame parent, boolean inline) {
        super(parent, inline);
    }

    public void revertVariables() {
        this.resetVariables();
    }

    public CSPVariable newVariable(DomainDiscrete dom, CSPgraph graph, Point p) {
        return new ConstraintVariable(dom, graph, p, this.getName(), this.varIndex++);
    }

    public ConstraintEdge newConstraintEdge(Constraint constraint, Graph graph, CSPVariable variable) {
        return new CnsConstraintEdge(constraint, graph, variable);
    }

    public void backtrackOn(ConstraintVariable node, int[] allowed, int[] backtrackAllowed) {
        this.pivotNodes.push(node);
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            ConstraintVariable tmpNode = (ConstraintVariable)v.nextElement();
            tmpNode.pushOldConstraint();
        }
        node.popOldConstraint();
        node.backTrack(allowed, backtrackAllowed);
        node.setLabel();
        this.varChanged(node);
        Enumeration e = this.getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            CnsConstraintEdge edgeToCheck = (CnsConstraintEdge)e.nextElement();
            edgeToCheck.pushOldQueueValue();
        }
    }

    public void backtrackOn(ConstraintVariable node, int value) {
        this.pivotNodes.push(node);
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            ConstraintVariable tmpNode = (ConstraintVariable)v.nextElement();
            tmpNode.pushOldConstraint();
        }
        node.popOldConstraint();
        node.backTrack(value);
        node.setLabel();
        this.varChanged(node);
        Enumeration e = this.getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            CnsConstraintEdge edgeToCheck = (CnsConstraintEdge)e.nextElement();
            edgeToCheck.pushOldQueueValue();
        }
    }

    public ConstraintVariable revertNodes() {
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            ConstraintVariable tmpNode = (ConstraintVariable)v.nextElement();
            tmpNode.popOldConstraint();
            tmpNode.setLabel();
        }
        Enumeration e = this.getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            CnsConstraintEdge edge = (CnsConstraintEdge)e.nextElement();
            edge.popOldQueueValue();
        }
        return (ConstraintVariable)this.pivotNodes.pop();
    }

    public void resetNodes() {
        this.resetVariables();
        this.pivotNodes.removeAllElements();
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            ConstraintVariable tmpNode = (ConstraintVariable)v.nextElement();
            tmpNode.pushOldConstraint();
            tmpNode.setLabel();
            tmpNode.xw = 0;
        }
        Enumeration e = this.getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            CnsConstraintEdge edge = (CnsConstraintEdge)e.nextElement();
            edge.putOnQueue();
            edge.xw = 0;
        }
    }

    public boolean queueEmpty() {
        Enumeration e = this.getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            if (!((CnsConstraintEdge)e.nextElement()).isOnQueue()) continue;
            return false;
        }
        return true;
    }

    public void varChanged(CSPVariable var) {
        Enumeration c = this.getConstraints().elements();
        while (c.hasMoreElements()) {
            Constraint constraint = (Constraint)c.nextElement();
            if (!constraint.containsVariable(var)) continue;
            Enumeration e = constraint.getConstraintEdges().elements();
            while (e.hasMoreElements()) {
                CnsConstraintEdge newedge = (CnsConstraintEdge)e.nextElement();
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.putOnQueue();
                newedge.xw = 0;
            }
        }
    }
}

