/*
 * Decompiled with CFR 0.152.
 */
package CIspace.Constraint;

import CIspace.Constraint.AutoAC;
import CIspace.Constraint.AutoFineStep;
import CIspace.Constraint.CnsConstraintEdge;
import CIspace.Constraint.ConstraintCSP;
import CIspace.Constraint.ConstraintVariable;
import CIspace.Constraint.ConstraintWindow;
import CIspace.Constraint.NodeValueDialog;
import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPcanvas;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.ConstraintEdge;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.graphToolKit.Entity;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class ConstraintCanvas
extends CSPcanvas {
    public boolean inspectMode = false;
    private NodeValueDialog backtrackDialog;
    protected AutoAC auto;
    protected AutoFineStep autoFS;
    protected int dt = 500;
    protected boolean splittable = true;
    protected int fineStepCount = 0;
    protected boolean showFS = true;
    protected CnsConstraintEdge fineStepEdge;
    protected MenuItem backtrack = new MenuItem("Backtrack");
    protected boolean lastStepWasStep = true;

    public ConstraintCanvas(Container parent, boolean inline, CSP csp) {
        super(parent, inline, csp);
        this.backtrack.setActionCommand(this.backtrack.getLabel());
        this.backtrack.addActionListener(this);
        this.backtrack.setEnabled(false);
    }

    protected void popupSCanv() {
        this.pop.setLabel("Canvas Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Auto Arc-Consistency");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Step");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("FineStep");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Stop");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.add(this.backtrack);
        this.pop.addSeparator();
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Reset Edge Labels");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
    }

    protected void popupSVariable() {
        this.pop.setLabel("Node Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Inspect");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
    }

    protected void popupSConstraint() {
        this.pop.setLabel("Edge Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Make Consistent");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Reset Edge Labels");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Inspect");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
    }

    public void setSplittable(boolean split) {
        this.splittable = split;
    }

    public void setSpeed(int speed) {
        this.dt = speed;
        if (this.auto != null) {
            this.auto.dt = speed;
        }
        if (this.autoFS != null) {
            this.autoFS.dt = speed;
        }
    }

    private void makeConsistent(CnsConstraintEdge edge) {
        boolean inconsistent = this.stepOne(edge);
        edge.setConsistent(!inconsistent);
        if (inconsistent) {
            this.stepTwo(edge);
            this.stepThree(edge);
        }
    }

    public void step() {
        if (this.autoFSAlive()) {
            return;
        }
        if (this.fineStepEdge != null) {
            while (this.fineStepCount != 0) {
                this.fineStep(this.fineStepEdge);
            }
        }
        this.lastStepWasStep = true;
        Enumeration e = ((ConstraintCSP)this.csp).getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            CnsConstraintEdge edge = (CnsConstraintEdge)e.nextElement();
            if (!edge.isOnQueue()) continue;
            if (this.showFS) {
                this.autoFS(edge);
            } else {
                this.makeConsistent(edge);
            }
            return;
        }
    }

    private boolean stepOne(CnsConstraintEdge edge) {
        edge.removeFromQueue();
        CSPVariable var = edge.getVariable();
        Constraint constraint = edge.getConstraint();
        DomainDiscrete dom = var.getDomain();
        int[] split = dom.getSplitElements();
        boolean changed = false;
        int index = constraint.index(var);
        int j = 0;
        while (j < split.length) {
            if (!constraint.viable(index, split[j])) {
                changed = true;
            }
            ++j;
        }
        return changed;
    }

    private void stepTwo(CnsConstraintEdge edge) {
        ConstraintVariable var = (ConstraintVariable)edge.getVariable();
        var.xw = (int)this.graph.getLineWidth();
        Constraint cns = edge.getConstraint();
        Enumeration c = this.csp.getConstraints().elements();
        while (c.hasMoreElements()) {
            Constraint constraint = (Constraint)c.nextElement();
            if (!constraint.containsVariable(var) || cns.equals(constraint)) continue;
            Enumeration e = constraint.getConstraintEdges().elements();
            while (e.hasMoreElements()) {
                CnsConstraintEdge newedge = (CnsConstraintEdge)e.nextElement();
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.xw = (int)this.graph.getLineWidth();
            }
        }
    }

    private void stepThree(CnsConstraintEdge edge) {
        CSPVariable var = edge.getVariable();
        Constraint cns = edge.getConstraint();
        DomainDiscrete dom = var.getDomain();
        int[] split = dom.getSplitElements();
        boolean changed = false;
        int index = cns.index(var);
        int i = 0;
        int j = 0;
        while (j < split.length) {
            if (!cns.viable(index, split[j])) {
                dom.hide(i);
            } else {
                ++i;
            }
            ++j;
        }
        edge.setConsistent(true);
        var.setLabel();
        Enumeration c = this.csp.getConstraints().elements();
        while (c.hasMoreElements()) {
            Constraint constraint = (Constraint)c.nextElement();
            if (!constraint.containsVariable(var) || cns.equals(constraint)) continue;
            Enumeration e = constraint.getConstraintEdges().elements();
            while (e.hasMoreElements()) {
                CnsConstraintEdge newedge = (CnsConstraintEdge)e.nextElement();
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.putOnQueue();
                newedge.xw = 0;
            }
        }
    }

    public boolean fineStep(CnsConstraintEdge edge) {
        this.lastStepWasStep = false;
        if (this.fineStepCount == 0) {
            edge.xw = (int)this.graph.getLineWidth();
            ++this.fineStepCount;
        } else if (this.fineStepCount == 1) {
            boolean inconsistent = this.stepOne(edge);
            edge.setConsistent(!inconsistent);
            if (!inconsistent) {
                this.fineStepCount = 0;
                edge.xw = 0;
                return false;
            }
            ++this.fineStepCount;
            this.stepTwo(edge);
            ++this.fineStepCount;
        } else if (this.fineStepCount == 2) {
            this.stepTwo(edge);
            ++this.fineStepCount;
        } else if (this.fineStepCount == 3) {
            edge.xw = 0;
            this.stepThree(edge);
            this.fineStepCount = 0;
            return false;
        }
        return true;
    }

    public void fineStep() {
        if (this.autoFSAlive()) {
            return;
        }
        if (this.fineStepEdge != null) {
            this.fineStep(this.fineStepEdge);
            if (this.fineStepCount == 0) {
                this.fineStepEdge = null;
            }
            return;
        }
        Enumeration e = this.csp.getConstraintEdges().elements();
        while (e.hasMoreElements()) {
            this.fineStepEdge = (CnsConstraintEdge)e.nextElement();
            if (!this.fineStepEdge.isOnQueue()) continue;
            this.fineStep();
            return;
        }
    }

    public void autoAC() {
        this.auto = new AutoAC(this, this.dt, (ConstraintCSP)this.csp);
        this.auto.start();
        this.setPromptLabel("Running auto arc-consistency...");
    }

    public void stopAC() {
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
        this.setPromptLabel("Stopped auto arc-consistency");
    }

    public void doneAC() {
        ((ConstraintWindow)this.parent).stop.setEnabled(false);
        this.setPromptLabel("All arcs are consistent!");
        this.repaint();
    }

    public void autoFS(CnsConstraintEdge edge) {
        this.fineStepCount = 0;
        this.autoFS = new AutoFineStep(this, this.dt, edge);
        this.autoFS.start();
    }

    public void stopFS() {
        if (this.autoFS == null) {
            return;
        }
        if (this.autoFS.isAlive()) {
            this.autoFS.quit();
        }
    }

    public boolean autoFSAlive() {
        if (this.autoFS == null) {
            return false;
        }
        return this.autoFS.isAlive();
    }

    public void showFS(boolean bool) {
        this.showFS = bool;
    }

    public ConstraintVariable backtrack() {
        ConstraintVariable node = null;
        try {
            node = ((ConstraintCSP)this.csp).revertNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
        return node;
    }

    public void resetCSP() {
        ((ConstraintCSP)this.csp).resetNodes();
        if (this.mode == 2221) {
            if (this.inspectMode) {
                this.setPromptLabel("Click on a node or an arc to inspect its domain");
            } else {
                this.setPromptLabel("Click on a node to split its domain.\nClick on an arc to make it arc-consistent.");
            }
            if (!this.inline) {
                ((ConstraintWindow)this.parent).blinkLabel();
            }
        }
        this.backtrack.setEnabled(false);
        this.repaint();
    }

    public void startInspectMode() {
        this.inspectMode = true;
        this.clearMouse();
    }

    public void stopInspectMode() {
        this.inspectMode = false;
        this.clearMouse();
    }

    public void disposeWindows() {
        super.disposeWindows();
        if (this.backtrackDialog != null) {
            this.backtrackDialog.dispose();
        }
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
    }

    protected void inspectEdge(ConstraintEdge edge) {
        this.pause();
        this.unpause();
    }

    protected void inspectNode(ConstraintVariable node) {
    }

    protected void splitDomain(ConstraintVariable node) {
        if (this.backtrackDialog == null) {
            this.backtrackDialog = new NodeValueDialog(this);
        }
        this.backtrackDialog.open(node, (ConstraintCSP)this.csp, true);
        if (!this.backtrackDialog.userCancelled()) {
            ((ConstraintWindow)this.parent).domainSplittingOccurred(node);
            this.backtrack.setEnabled(true);
        }
    }

    protected Entity mClicked(MouseEvent e) {
        super.mClicked(e);
        if (e.getModifiers() == 4) {
            return this.entClicked;
        }
        if (this.entClicked == null) {
            return this.entClicked;
        }
        if (this.mode == 2221 && this.entClicked.type == 7770) {
            if (this.autoFSAlive()) {
                return this.entClicked;
            }
            if (this.auto != null && this.auto.isAlive()) {
                return this.entClicked;
            }
            this.pause();
            if (this.entClicked instanceof ConstraintVariable) {
                ConstraintVariable tmpNode = (ConstraintVariable)this.entClicked;
                if (this.inspectMode) {
                    this.inspectNode(tmpNode);
                } else if (this.splittable) {
                    this.splitDomain(tmpNode);
                }
            } else if (this.entClicked instanceof Constraint) {
                this.inspectConstraint((Constraint)this.entClicked);
            }
            this.unpause();
        }
        return this.entClicked;
    }

    protected Entity mPressed(MouseEvent e) {
        if (this.autoFSAlive()) {
            return null;
        }
        Entity ent = super.mPressed(e);
        if (e.getModifiers() == 4) {
            return ent;
        }
        if (this.mode == 2221 && ent != null && ent instanceof CnsConstraintEdge) {
            CnsConstraintEdge edge = (CnsConstraintEdge)ent;
            if (this.inspectMode) {
                this.inspectEdge(edge);
            } else if (edge.isOnQueue()) {
                if (this.showFS) {
                    this.autoFS(edge);
                } else {
                    this.makeConsistent(edge);
                }
                this.repaint();
            }
        }
        this.repaint();
        return ent;
    }

    protected void aSolvePerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (this.autoFSAlive() && !arg.equals("Stop")) {
            return;
        }
        if (arg.equals("Split Domain")) {
            this.splitDomain((ConstraintVariable)this.entClicked);
        } else if (arg.equals("Make Consistent")) {
            CnsConstraintEdge edge = (CnsConstraintEdge)this.entClicked;
            if (edge.isOnQueue()) {
                if (this.showFS) {
                    this.autoFS(edge);
                } else {
                    this.makeConsistent(edge);
                }
                this.repaint();
            }
        } else if (arg.equals("Inspect")) {
            if (this.entClicked.type == 7770) {
                this.inspectNode((ConstraintVariable)this.entClicked);
            } else if (this.entClicked.type == 7771) {
                this.inspectEdge((ConstraintEdge)this.entClicked);
            }
        } else if (arg.equals("Auto Arc-Consistency")) {
            this.autoAC();
        } else if (arg.equals("Step")) {
            this.step();
            this.repaint();
        } else if (arg.equals("Fine Step")) {
            this.fineStep();
            this.repaint();
        } else if (arg.equals("Stop")) {
            this.stopAC();
            this.repaint();
        } else if (arg.equals("Backtrack")) {
            this.backtrack();
        } else if (arg.equals("Reset CSP")) {
            this.resetCSP();
        }
        this.graph.deselectAll();
    }

    public void kPressed(KeyEvent e) {
        super.kPressed(e);
        int arg = e.getKeyCode();
        if (arg == 32 || arg == 10 || arg == 83) {
            if (this.lastStepWasStep) {
                this.step();
            } else {
                this.fineStep();
            }
            this.repaint();
        }
    }
}

