/*
 * Decompiled with CFR 0.152.
 */
package CIspace.Constraint;

import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Point;
import java.util.EmptyStackException;
import java.util.Stack;

public class ConstraintVariable
extends CSPVariable {
    private Stack indentStack = new Stack();
    protected Stack oldSplits = new Stack();

    ConstraintVariable(DomainDiscrete dom, Graph graph, Point p, String name, int index) {
        super(dom, graph, p, name, index);
    }

    public void pushIndent(int indent) {
        this.indentStack.push(new Integer(indent));
    }

    public int popIndent() {
        Integer tempInteger;
        try {
            tempInteger = (Integer)this.indentStack.pop();
        }
        catch (EmptyStackException e) {
            tempInteger = new Integer(0);
        }
        return tempInteger;
    }

    public void popOldConstraint() {
        try {
            this.domain.set((int[])this.oldSplits.pop());
        }
        catch (EmptyStackException e) {
            this.domain.resetSplit();
        }
    }

    public String getSplittingString() {
        return String.valueOf(this.name) + " in {" + this.domain.getSplitRep() + "}";
    }

    public void resetNode() {
        this.reset();
        this.indentStack.removeAllElements();
        this.oldSplits.removeAllElements();
    }

    public boolean connected() {
        return this.edgesIn.size() > 0 || this.edgesOut.size() > 0;
    }

    public void pushOldConstraint() {
        int[] split = this.domain.getSplitElements();
        int[] oldSplit = new int[split.length];
        int i = 0;
        while (i < split.length) {
            oldSplit[i] = split[i];
            ++i;
        }
        this.oldSplits.push(oldSplit);
    }

    public void backTrack(int[] allowed, int[] backtrackAllowed) {
        this.domain.setSplitElements(allowed);
        this.oldSplits.push(backtrackAllowed);
    }

    public void backTrack(int selectedValue) {
        if (selectedValue < 0 || selectedValue >= this.domain.getSize()) {
            this.oldSplits.push(this.domain.getSplitElements());
            return;
        }
        int[] split = this.domain.getSplitElements();
        int[] oldSplit = new int[split.length - 1];
        int i = 0;
        while (i < oldSplit.length) {
            if (split[i] == selectedValue) continue;
            oldSplit[i] = split[i];
            ++i;
        }
        this.oldSplits.push(oldSplit);
        this.domain.setSplitElements(new int[]{selectedValue});
    }
}

