/*
 * Decompiled with CFR 0.152.
 */
package CIspace.Constraint;

import CIspace.Constraint.ConstraintCSP;
import CIspace.Constraint.ConstraintCanvas;
import CIspace.Constraint.ConstraintVariable;
import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPWindow;
import CIspace.cspTools.CSPcanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.HelpMenu;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

public class ConstraintWindow
extends CSPWindow {
    private Panel bottom;
    private CheckboxMenuItem xFast;
    private CheckboxMenuItem fast;
    private CheckboxMenuItem medium;
    private CheckboxMenuItem slow;
    private CheckboxMenuItem showFS;
    private Button auto;
    private Button step;
    private Button fineStep;
    public Button stop;
    private Button backtrack;
    private Button reset;
    private CheckboxGroup solveInspectGroup;
    private Checkbox[] solveInspect;
    private TextArea ta;
    private int indent;
    private int splitsOnStack;
    private String extension;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private MenuItem mItemAuto;
    private MenuItem mItemStop;
    private MenuItem mItemReset;

    public ConstraintWindow(Applet parent) {
        super(parent);
        this.setTitle("CSP Version 2.6b --- untitled.txt");
        this.bottom = new Panel();
        this.bottom.setBackground(this.bg);
        this.bottom.setLayout(new BorderLayout());
        this.ta = new TextArea("Domain-splitting History:\n", 7, 100);
        this.ta.setEditable(false);
        this.ta.setBackground(GraphConsts.bg);
        this.ta.setForeground(GraphConsts.fg);
        this.bottom.add("Center", this.ta);
        this.main.add("South", this.bottom);
        this.add("Center", this.main);
        this.indent = 0;
        this.splitsOnStack = 0;
    }

    protected CSPcanvas getCanvas(CSP csp) {
        return new ConstraintCanvas(this, false, csp);
    }

    protected CSP getCSP() {
        return new ConstraintCSP(this, false);
    }

    protected Panel getSolvePanel() {
        GridBagLayout gbl2 = new GridBagLayout();
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 18;
        gbc2.fill = 1;
        Panel panel = new Panel();
        panel.setLayout(gbl2);
        this.auto = new Button("Auto Arc-Consistency");
        this.auto.addActionListener(this);
        this.stop = new Button("Stop");
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        this.step = new Button("Step");
        this.step.addActionListener(this);
        this.fineStep = new Button("Fine Step");
        this.fineStep.addActionListener(this);
        this.backtrack = new Button("Backtrack");
        this.backtrack.addActionListener(this);
        this.backtrack.setEnabled(false);
        this.reset = new Button("Reset CSP");
        this.reset.addActionListener(this);
        this.addComponent(this.step, panel, 0, 0, 2, 1, 0.0, 0.0, gbc2, gbl2);
        this.addComponent(this.fineStep, panel, 1, 0, 2, 1, 0.0, 0.0, gbc2, gbl2);
        this.addComponent(this.auto, panel, 2, 0, 2, 1, 0.0, 0.0, gbc2, gbl2);
        this.addComponent(this.stop, panel, 3, 0, 2, 1, 0.0, 0.0, gbc2, gbl2);
        this.addComponent(this.backtrack, panel, 4, 0, 2, 1, 0.0, 0.0, gbc2, gbl2);
        this.addComponent(this.reset, panel, 5, 0, 2, 1, 0.0, 0.0, gbc2, gbl2);
        return panel;
    }

    protected Menu getOptionsMenu() {
        Menu m = super.getOptionsMenu();
        Menu speed = new Menu("AutoAC Speed");
        this.xFast = new CheckboxMenuItem("Very Fast (0 s)", false);
        this.xFast.addItemListener(this);
        speed.add(this.xFast);
        this.fast = new CheckboxMenuItem("Fast (0.1 s)", false);
        this.fast.addItemListener(this);
        speed.add(this.fast);
        this.medium = new CheckboxMenuItem("Medium (0.5 s)", true);
        this.medium.addItemListener(this);
        speed.add(this.medium);
        this.slow = new CheckboxMenuItem("Slow (1 s)", false);
        this.slow.addItemListener(this);
        speed.add(this.slow);
        m.add(speed);
        this.showFS = new CheckboxMenuItem("Show Fine Steps", true);
        this.showFS.addItemListener(this);
        m.add(this.showFS);
        return m;
    }

    protected Menu getControlsMenu() {
        Menu m = new Menu("Controls");
        this.mItemAuto = new MenuItem("Auto Arc-Consistency");
        this.mItemAuto.setActionCommand(this.mItemAuto.getLabel());
        this.mItemAuto.addActionListener(this);
        MenuShortcut shortcut = new MenuShortcut(65, true);
        this.mItemAuto.setShortcut(shortcut);
        this.mItemAuto.setEnabled(false);
        m.add(this.mItemAuto);
        this.mItemStop = new MenuItem("Stop");
        this.mItemStop.setActionCommand(this.mItemStop.getLabel());
        this.mItemStop.addActionListener(this);
        shortcut = new MenuShortcut(83, true);
        this.mItemStop.setShortcut(shortcut);
        this.mItemStop.setEnabled(false);
        m.add(this.mItemStop);
        this.mItemReset = new MenuItem("Reset CSP");
        this.mItemReset.setActionCommand(this.mItemReset.getLabel());
        this.mItemReset.addActionListener(this);
        shortcut = new MenuShortcut(82, true);
        this.mItemReset.setShortcut(shortcut);
        this.mItemReset.setEnabled(false);
        m.add(this.mItemReset);
        m.addSeparator();
        MenuItem mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(90, true);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        return m;
    }

    protected Menu getHelpMenu() {
        return new HelpMenu(this.applet, "Constraint", this);
    }

    protected void setMode(boolean solve) {
        ((ConstraintCanvas)this.canvas).stopAC();
        this.indent = 0;
        this.splitsOnStack = 0;
        this.ta.setText("Domain-splitting History:\n");
        this.backtrack.setEnabled(false);
        if (!solve) {
            this.setPromptLabel("");
        } else if (solve) {
            ((ConstraintCanvas)this.canvas).resetCSP();
            if (((ConstraintCanvas)this.canvas).inspectMode) {
                this.setPromptLabel("Click on a node or an arc to inspect its domain");
            } else {
                this.setPromptLabel("Click on a node to split its domain.\nClick on an arc to make it arc-consistent.");
            }
            this.blinkLabel();
        }
    }

    public void domainSplittingOccurred(ConstraintVariable splittingNode) {
        splittingNode.pushIndent(this.indent);
        this.ta.append("\n");
        int i = 0;
        while (i < this.indent) {
            this.ta.append("    ");
            ++i;
        }
        this.ta.append(splittingNode.getSplittingString());
        ++this.indent;
        this.backtrack.setEnabled(true);
        ++this.splitsOnStack;
    }

    public void backtrackingOccurred(ConstraintVariable backtrackNode) {
        this.indent = backtrackNode.popIndent();
        this.ta.append("\n");
        int i = 0;
        while (i < this.indent) {
            this.ta.append("    ");
            ++i;
        }
        this.ta.append(backtrackNode.getSplittingString());
        ++this.indent;
        --this.splitsOnStack;
        if (this.splitsOnStack <= 0) {
            this.backtrack.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        String arg = e.getItem().toString();
        if (arg.equals("Very Fast (0 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(0);
            this.xFast.setState(true);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(false);
        } else if (arg.equals("Fast (0.1 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(100);
            this.xFast.setState(false);
            this.fast.setState(true);
            this.medium.setState(false);
            this.slow.setState(false);
        } else if (arg.equals("Medium (0.5 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(500);
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(true);
            this.slow.setState(false);
        } else if (arg.equals("Slow (1 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(1000);
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(true);
        } else if (arg.equals("Solve")) {
            ((ConstraintCanvas)this.canvas).stopInspectMode();
            this.setPromptLabel("Click on a node to split its domain.\nClick on an arc to make it arc-consistent.");
        } else if (arg.equals("Inspect")) {
            ((ConstraintCanvas)this.canvas).startInspectMode();
            this.setPromptLabel("Click on a node or an arc to inspect its domain");
        } else if (arg.equals("Show Fine Steps")) {
            ((ConstraintCanvas)this.canvas).showFS(this.showFS.getState());
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand();
        if (arg.equals("Auto Arc-Consistency")) {
            this.stop.setEnabled(true);
            ((ConstraintCanvas)this.canvas).autoAC();
        } else if (arg.equals("Stop")) {
            this.stop.setEnabled(false);
            ((ConstraintCanvas)this.canvas).stopAC();
            this.canvas.repaint();
        } else if (arg.equals("Step")) {
            ((ConstraintCanvas)this.canvas).step();
            this.canvas.repaint();
        } else if (arg.equals("Fine Step")) {
            ((ConstraintCanvas)this.canvas).fineStep();
            this.canvas.repaint();
        } else if (arg.equals("Backtrack")) {
            this.backtrackingOccurred(((ConstraintCanvas)this.canvas).backtrack());
        } else if (arg.equals("Reset CSP")) {
            this.indent = 0;
            this.splitsOnStack = 0;
            this.ta.setText("Domain-splitting History:\n");
            this.backtrack.setEnabled(false);
            ((ConstraintCanvas)this.canvas).resetCSP();
        } else if (arg.equals("Edge Colors...")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        }
    }

    public static void main(String[] args) {
        ConstraintWindow window = new ConstraintWindow(null);
        window.showWindow();
    }
}

