/*
 * Decompiled with CFR 0.152.
 */
package CIspace.Constraint;

import CIspace.Constraint.ConstraintCSP;
import CIspace.Constraint.ConstraintCanvas;
import CIspace.Constraint.ConstraintVariable;
import CIspace.cspTools.CSP;
import CIspace.cspTools.domains.DomainDiscrete;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class NodeValueDialog
extends Dialog
implements ActionListener,
WindowListener {
    private Panel promptPanel;
    private Label choicePrompt;
    private ScrollPane scrollPanel;
    private Panel choicePanel;
    private Checkbox[] choices;
    private boolean empty;
    private Panel donePanel;
    private Button cancelButton;
    private Button doneButton;
    private Panel splitPanel;
    private boolean cancelWasPushed;
    private ConstraintCSP csp;
    private ConstraintVariable variable;
    private DomainDiscrete domain;
    private int[] split;
    private int currSize;
    private ConstraintCanvas parent;
    private boolean editable;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;

    public NodeValueDialog(ConstraintCanvas parent) {
        super((Frame)parent.parent, "Split The Domain...", true);
        this.setFont(new Font("SansSerif", 0, 12));
        this.parent = parent;
        this.addWindowListener(this);
        this.doneButton = new Button("OK");
        this.doneButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.choicePanel = new Panel();
        this.promptPanel = new Panel();
        this.scrollPanel = new ScrollPane();
        this.splitPanel = new Panel();
        this.donePanel = new Panel();
        this.split = new int[1];
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.setLayout(this.gbl);
        this.addComponent(this.promptPanel, this, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.scrollPanel, this, 1, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.splitPanel, this, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.donePanel, this, 3, 0, 1, 1, 0.0, 0.0);
    }

    private void addComponent(Component c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    public void open(ConstraintVariable variable, ConstraintCSP csp, boolean editable) {
        if (!editable) {
            this.setTitle("Inspect a variable...");
        }
        this.variable = variable;
        this.csp = csp;
        this.editable = editable;
        this.domain = variable.getDomain();
        this.split = this.domain.getSplitElements();
        String[] elements = this.domain.getDomain();
        this.cancelWasPushed = false;
        this.choicePanel.removeAll();
        this.empty = true;
        this.choices = new Checkbox[this.split.length];
        this.currSize = 0;
        CSP.intSort(this.split);
        int index = 0;
        while (index < this.split.length) {
            int row = (int)Math.ceil((double)(index + 1) / 4.0) - 1;
            int col = index % 4;
            String tmpString = elements[this.split[index]];
            this.choices[index] = new Checkbox(tmpString, false);
            this.choicePanel.add(this.choices[index]);
            this.empty = false;
            ++this.currSize;
            ++index;
        }
        if (editable) {
            if (this.empty) {
                this.choicePrompt = new Label("There are no values left to prune!");
                editable = false;
            } else {
                this.choicePrompt = new Label("Select values to keep (in the domain of " + variable.getName() + "):");
            }
        } else {
            this.choicePrompt = new Label("Current values of the domain of " + variable.getName());
        }
        this.promptPanel.removeAll();
        this.promptPanel.add(this.choicePrompt);
        this.scrollPanel.removeAll();
        if (!this.empty) {
            this.scrollPanel.add(this.choicePanel);
        }
        this.splitPanel.removeAll();
        if (editable && !this.empty) {
            Button half = new Button("Select Half");
            half.addActionListener(this);
            Button random = new Button("Select Random");
            random.addActionListener(this);
            this.splitPanel.add(half);
            this.splitPanel.add(random);
        }
        this.donePanel.removeAll();
        this.donePanel.add(this.doneButton);
        if (!this.empty) {
            this.donePanel.add(this.cancelButton);
        }
        this.validate();
        this.pack();
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    private void selectHalf() {
        int j = 0;
        int i = 0;
        while (i < this.split.length) {
            if (this.choices[i] != null) {
                if (j < this.currSize / 2) {
                    this.choices[i].setState(true);
                } else {
                    this.choices[i].setState(false);
                }
                ++j;
            }
            ++i;
        }
    }

    private void selectRandom() {
        int i = 0;
        while (i < this.split.length) {
            if (this.choices[i] != null) {
                if (Math.random() < 0.5) {
                    this.choices[i].setState(true);
                } else {
                    this.choices[i].setState(false);
                }
            }
            ++i;
        }
    }

    public boolean userCancelled() {
        return this.cancelWasPushed;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            if (this.editable && !this.empty) {
                Vector<Integer> allowVector = new Vector<Integer>();
                Vector<Integer> backtVector = new Vector<Integer>();
                int i = 0;
                while (i < this.split.length) {
                    if (this.choices[i] != null && this.choices[i].getState()) {
                        allowVector.addElement(new Integer(this.split[i]));
                    } else {
                        backtVector.addElement(new Integer(this.split[i]));
                    }
                    ++i;
                }
                int[] allowed = new int[allowVector.size()];
                int[] backtrackAllowed = new int[backtVector.size()];
                i = 0;
                while (i < allowed.length) {
                    allowed[i] = (Integer)allowVector.elementAt(i);
                    ++i;
                }
                i = 0;
                while (i < backtrackAllowed.length) {
                    backtrackAllowed[i] = (Integer)backtVector.elementAt(i);
                    ++i;
                }
                this.csp.backtrackOn(this.variable, allowed, backtrackAllowed);
            }
            if (this.empty) {
                this.cancelWasPushed = true;
            }
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand() == "Cancel") {
            this.cancelWasPushed = true;
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals("Select Half")) {
            this.selectHalf();
        } else if (e.getActionCommand().equals("Select Random")) {
            this.selectRandom();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cancelWasPushed = true;
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

