/*
 * Decompiled with CFR 0.152.
 */
package CIspace.XMLReader;

import CIspace.XMLReader.Pair;
import CIspace.XMLReader.XMLBlock;
import java.util.StringTokenizer;

public class XMLTree {
    protected XMLBlock headNode = new XMLBlock();

    public void readString(String input) {
        String noCommentInput = this.stripComments(input);
        this.readString(noCommentInput, this.headNode);
    }

    private String stripComments(String s) {
        String input = s;
        int commentStart = input.indexOf("<!--");
        int commentEnd = 0;
        while (commentStart != -1) {
            commentEnd = input.indexOf("-->");
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(commentEnd + 3);
            commentStart = input.indexOf("<!--");
        }
        commentStart = input.indexOf("<?");
        commentEnd = 0;
        while (commentStart != -1) {
            commentEnd = input.indexOf("?>");
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(commentEnd + 2);
            commentStart = input.indexOf("<?");
        }
        commentStart = input.indexOf("<!DOCTYPE");
        commentEnd = 0;
        while (commentStart != -1) {
            commentEnd = input.indexOf("]>");
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(commentEnd + 2);
            commentStart = -1;
        }
        input = input.substring(input.indexOf("<"));
        return input;
    }

    private void readString(String input, XMLBlock currentNode) {
        int startOfTag = input.indexOf("<");
        int endOfTagName = input.indexOf(" ");
        endOfTagName = input.indexOf(" ") < input.indexOf(">") && input.indexOf(" ") > 0 ? input.indexOf(" ") : input.indexOf(">");
        int endOfStartTag = input.indexOf(">");
        String tag = input.substring(startOfTag + 1, endOfTagName);
        currentNode.setTag(tag);
        int endOfTag = input.indexOf("</" + tag + ">");
        if (input.indexOf("<", endOfStartTag + 1) == endOfTag) {
            currentNode.setText(input.substring(endOfStartTag + 1, endOfTag));
        }
        if (endOfStartTag - endOfTagName > 0) {
            StringTokenizer startTag = new StringTokenizer(input.substring(endOfTagName + 1, endOfStartTag));
            while (startTag.hasMoreTokens()) {
                String property = startTag.nextToken();
                String propertyName = property.substring(0, property.indexOf("="));
                String propertyValue = property.substring(property.indexOf("=") + 1);
                currentNode.addProperty(propertyName, propertyValue);
            }
        }
        String remainingString = input.substring(endOfStartTag + 1, endOfTag);
        while (remainingString.indexOf("<") != -1) {
            int startOfNewTag;
            int endOfNewTagName = startOfNewTag = remainingString.indexOf("<");
            endOfNewTagName = remainingString.indexOf(" ", startOfNewTag) < remainingString.indexOf(">") && remainingString.indexOf(" ") > 0 ? remainingString.indexOf(" ") : remainingString.indexOf(">");
            tag = remainingString.substring(startOfNewTag + 1, endOfNewTagName);
            int endOfNewTag = remainingString.indexOf("</" + tag + ">");
            XMLBlock newChildNode = new XMLBlock();
            String childString = String.valueOf(remainingString.substring(startOfNewTag, endOfNewTag)) + "</" + tag + ">";
            remainingString = remainingString.substring(endOfNewTag + ("/" + tag + ">").length() + 1);
            this.readString(childString, newChildNode);
            currentNode.addChild(newChildNode);
        }
    }

    public void print() {
        this.printAll(this.headNode, 0);
    }

    private void printAll(XMLBlock currNode, int spaces) {
        String s = "";
        int i = 0;
        while (i < spaces) {
            s = String.valueOf(s) + "\t ";
            ++i;
        }
        System.out.println(String.valueOf(s) + "node tag: " + currNode.getTag());
        i = 0;
        while (i < currNode.getProperties().size()) {
            System.out.println(String.valueOf(s) + "Property: " + ((Pair)currNode.getProperties().elementAt((int)i)).name);
            ++i;
        }
        System.out.println(String.valueOf(s) + "Text: " + currNode.getText());
        System.out.println(String.valueOf(s) + "Children: ");
        i = 0;
        while (i < currNode.childBlocks.size()) {
            this.printAll((XMLBlock)currNode.childBlocks.elementAt(i), spaces + 1);
            ++i;
        }
    }

    public XMLBlock getHead() {
        return this.headNode;
    }
}

