/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPcanvas;
import CIspace.cspTools.CSPgraph;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.ConstraintEdge;
import CIspace.cspTools.IO;
import CIspace.cspTools.VariableEdge;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;

public class CSP
implements Cloneable {
    private static int CHAR_LENGTH = 20;
    private String name = "Untitled";
    protected Vector constraints;
    protected Vector variables;
    protected Vector variableNames;
    protected int varIndex = 0;
    protected CSPgraph graph;
    protected CSPcanvas canvas;
    protected Frame parent;
    protected boolean inline;

    public CSP(Frame parent, boolean inline) {
        this.parent = parent;
        this.inline = inline;
    }

    public void init(CSPcanvas canvas) {
        this.varIndex = 0;
        this.constraints = new Vector();
        this.variables = new Vector();
        this.variableNames = new Vector();
        this.canvas = canvas;
        canvas.reset();
        this.graph = (CSPgraph)canvas.graph;
    }

    public void initFromText(CSPcanvas canvas, String xml) {
        this.init(canvas);
        IO.parseXML(xml, this);
    }

    public Constraint newConstraint(CSPgraph graph, Point p, Vector variables, int draw, CSP csp) {
        Constraint cns = new Constraint(graph, p, variables, draw, csp);
        return cns;
    }

    public CSPVariable newVariable(DomainDiscrete dom, CSPgraph graph, Point p) {
        return new CSPVariable(dom, graph, p, this.getName(), this.varIndex++);
    }

    public ConstraintEdge newConstraintEdge(Constraint constraint, Graph graph, CSPVariable variable) {
        return new ConstraintEdge(constraint, graph, variable);
    }

    public VariableEdge newVariableEdge(Constraint constraint, Graph graph, CSPVariable node1, CSPVariable node2) {
        return new VariableEdge(constraint, graph, node1, node2);
    }

    public void resetVariables() {
        Enumeration e = this.variables.elements();
        while (e.hasMoreElements()) {
            CSPVariable v = (CSPVariable)e.nextElement();
            v.reset();
            v.setLabel();
        }
    }

    public void resetLabels() {
        Node v;
        Enumeration e = this.variables.elements();
        while (e.hasMoreElements()) {
            v = (CSPVariable)e.nextElement();
            ((CSPVariable)v).setLabel();
        }
        e = this.constraints.elements();
        while (e.hasMoreElements()) {
            v = (Constraint)e.nextElement();
            ((Constraint)v).setLabel();
        }
    }

    public String getName() {
        int var = this.varIndex;
        while (!this.nameOK("N" + var)) {
            ++var;
        }
        return "N" + var;
    }

    public Point getPos() {
        Point p = new Point();
        p.y = 0.0f;
        p.x = this.varIndex * 20 - 100;
        return p;
    }

    public final boolean addConstraint(Constraint constraint) {
        this.constraints.addElement(constraint);
        this.graph.addNode(constraint);
        return true;
    }

    public final boolean remConstraint(Constraint constraint) {
        boolean bool = this.constraints.removeElement(constraint);
        return bool;
    }

    public final boolean addVariable(CSPVariable variable) {
        this.variables.addElement(variable);
        this.variableNames.addElement(variable.getName());
        this.graph.addNode(variable);
        return true;
    }

    public final boolean remVariable(CSPVariable variable) {
        this.variableNames.removeElement(variable.getName());
        return this.variables.removeElement(variable);
    }

    public final CSPcanvas getCanvas() {
        return this.canvas;
    }

    public final void changeDisplayMode() {
        Enumeration c = this.constraints.elements();
        while (c.hasMoreElements()) {
            ((Constraint)c.nextElement()).changeDisplayMode();
        }
    }

    public final CSPVariable getRandVariable() {
        return (CSPVariable)this.variables.elementAt((int)Math.floor(Math.random() * (double)this.variables.size()));
    }

    public final Constraint getRandConstraint() {
        return (Constraint)this.constraints.elementAt((int)Math.floor(Math.random() * (double)this.constraints.size()));
    }

    public final int numVariables() {
        return this.variables.size();
    }

    public final int numConstraints() {
        return this.constraints.size();
    }

    public final boolean nameOK(String name) {
        if (this.variableNames.contains(name)) {
            return false;
        }
        if (name == "") {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final Vector getConstraintEdges() {
        Vector edges = new Vector();
        Enumeration v = this.constraints.elements();
        while (v.hasMoreElements()) {
            Enumeration e = ((Constraint)v.nextElement()).getConstraintEdges().elements();
            while (e.hasMoreElements()) {
                edges.addElement(e.nextElement());
            }
        }
        return edges;
    }

    public final Vector getConstraints() {
        return (Vector)this.constraints.clone();
    }

    public final Vector getVariables() {
        return (Vector)this.variables.clone();
    }

    public final CSPVariable getVariable(int index) {
        return (CSPVariable)this.variables.elementAt(index);
    }

    public final CSPVariable getVariable(String name) {
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            CSPVariable var = (CSPVariable)v.nextElement();
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    public void setMode(boolean solve) {
        Enumeration v = this.constraints.elements();
        while (v.hasMoreElements()) {
            ((Constraint)v.nextElement()).setMode(solve);
        }
        v = this.variables.elements();
        while (v.hasMoreElements()) {
            ((CSPVariable)v.nextElement()).setMode(solve);
        }
        this.resetVariables();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void checkEditablity() {
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            ((CSPVariable)v.nextElement()).setEdit(true);
        }
        v = this.constraints.elements();
        while (v.hasMoreElements()) {
            Constraint c = (Constraint)v.nextElement();
            Vector vars = c.getVariables();
            Enumeration ve = vars.elements();
            while (ve.hasMoreElements()) {
                CSPVariable var = (CSPVariable)ve.nextElement();
                var.setEdit(false);
            }
        }
    }

    public void setPosition() {
        Enumeration e = this.constraints.elements();
        while (e.hasMoreElements()) {
            ((Constraint)e.nextElement()).setPosition();
        }
    }

    public static void intSort(int[] vars) {
        int i = 1;
        while (i < vars.length) {
            int var = vars[i];
            int j = i - 1;
            while (j >= 0 && vars[j] > var) {
                vars[j + 1] = vars[j];
                --j;
            }
            vars[j + 1] = var;
            ++i;
        }
    }

    public String toXML(String indent, boolean current) {
        String rep = "";
        rep = String.valueOf(rep) + indent + "<" + "CSP" + ">\n";
        rep = String.valueOf(rep) + indent + "<" + "NAME" + ">";
        rep = String.valueOf(rep) + this.name;
        rep = String.valueOf(rep) + indent + "</" + "NAME" + ">\n";
        Enumeration e = this.variables.elements();
        while (e.hasMoreElements()) {
            rep = String.valueOf(rep) + ((CSPVariable)e.nextElement()).toXML(indent, current);
        }
        e = this.constraints.elements();
        while (e.hasMoreElements()) {
            rep = String.valueOf(rep) + ((Constraint)e.nextElement()).toXML(indent);
        }
        rep = String.valueOf(rep) + indent + "</" + "CSP" + ">\n";
        return rep;
    }

    public static String trim(String s) {
        if (s.length() < CHAR_LENGTH) {
            return s;
        }
        String ns = s.substring(0, 16);
        return String.valueOf(ns) + "...";
    }
}

