/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.CSP;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.ConstraintEdge;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.HistogramNode;
import CIspace.graphToolKit.Point;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class CSPVariable
extends HistogramNode {
    protected DomainDiscrete domain;
    protected String name;
    protected int index;
    protected boolean edit = true;
    protected boolean solve;

    public CSPVariable(DomainDiscrete domain, Graph graph, Point point, String name, int index) {
        super(graph, String.valueOf(name) + ":\n" + domain.getRep(), point, Color.black, 1110);
        this.domain = domain;
        this.name = name;
        this.clearHistogram();
    }

    public boolean setDomain(DomainDiscrete domain) {
        this.domain = domain;
        return true;
    }

    public int index() {
        return this.index;
    }

    public boolean getEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public void setLabel() {
        this.label[0] = CSP.trim(String.valueOf(this.name) + ":");
        this.label[1] = this.solve ? CSP.trim("{" + this.domain.getSplitRep() + "}") : CSP.trim("{" + this.domain.getRep() + "}");
        this.updateSize();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DomainDiscrete getDomain() {
        return this.domain;
    }

    public Vector getConstraints() {
        Vector<Constraint> constraints = new Vector<Constraint>();
        Vector edges = (Vector)this.edgesIn.clone();
        Enumeration e = this.edgesOut.elements();
        while (e.hasMoreElements()) {
            edges.addElement(e.nextElement());
        }
        e = edges.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof ConstraintEdge)) continue;
            constraints.addElement(((ConstraintEdge)o).getConstraint());
        }
        return constraints;
    }

    public void reset() {
        this.domain.resetSplit();
    }

    public AffirmPanel getPanel(CSP csp, boolean editable) {
        return new VariablePanel(this, csp, editable);
    }

    public void setMode(boolean solve) {
        this.solve = solve;
    }

    protected int getWidth() {
        int width1 = this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
        int width2 = this.graph.canvas.getFontMetrics().stringWidth(this.label[1]) + this.wPad;
        return Math.max(width1, width2);
    }

    protected int getHeight() {
        return (this.graph.canvas.getFontMetrics().getHeight() + this.hPad) * 2;
    }

    protected void drawLabel(Graphics offscreen) {
        int width1 = this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
        int width2 = this.graph.canvas.getFontMetrics().stringWidth(this.label[1]) + this.wPad;
        if (this.isBold) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(Color.black);
        }
        offscreen.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y - (this.height - this.hPad) / 4);
        offscreen.drawString(this.label[1], (int)this.pos.x - (width2 - this.wPad) / 2, (int)this.pos.y + (this.height - this.hPad) / 4);
    }

    public String toXML(String indent, boolean current) {
        String rep = "";
        rep = String.valueOf(rep) + indent + "<" + "VARIABLE" + " " + "TYPE" + "=" + '\"' + this.domain.getTypeString() + '\"' + ">\n";
        rep = String.valueOf(rep) + indent + "\t<" + "NAME" + ">";
        rep = String.valueOf(rep) + this.name;
        rep = String.valueOf(rep) + "</NAME>\n";
        if (!current) {
            int i = 0;
            while (i < this.domain.getSize()) {
                rep = String.valueOf(rep) + indent + "\t<" + "VALUE" + ">";
                rep = String.valueOf(rep) + this.domain.getElementString(i);
                rep = String.valueOf(rep) + "</VALUE>\n";
                ++i;
            }
        } else {
            int[] split = this.domain.getSplitElements();
            int i = 0;
            while (i < split.length) {
                rep = String.valueOf(rep) + indent + "\t<" + "VALUE" + ">";
                rep = String.valueOf(rep) + this.domain.getElementString(split[i]);
                rep = String.valueOf(rep) + "</VALUE>\n";
                ++i;
            }
        }
        rep = String.valueOf(rep) + indent + "\t<" + "PROPERTY" + ">";
        rep = String.valueOf(rep) + "position = (" + this.pos.x + ", " + this.pos.y + ")";
        rep = String.valueOf(rep) + "</PROPERTY>\n";
        rep = String.valueOf(rep) + indent + "</" + "VARIABLE" + ">\n";
        return rep;
    }

    class VariablePanel
    extends AffirmPanel
    implements ActionListener {
        private CSPVariable variable;
        private TextField value;
        private Label title;
        private Button addButton;
        private Label name;
        private String initialName;
        private CSP csp;

        VariablePanel(CSPVariable variable, CSP csp, boolean edit) {
            this.variable = variable;
            this.setLayout(new GridLayout(4, 1));
            this.csp = csp;
            this.addButton = new Button("Change name");
            this.addButton.addActionListener(this);
            this.value = new TextField(variable.getName(), 10);
            this.value.addActionListener(this);
            this.title = new Label("Change Variable Name...");
            this.name = new Label(variable.getName());
            this.initialName = variable.getName();
            this.add(this.title);
            this.add(this.value);
            this.add(this.addButton);
            this.add(this.name);
        }

        public void actionPerformed(ActionEvent e) {
            if ((e.getActionCommand() == "Change name" || e.getSource().equals(this.value)) && this.csp.nameOK(this.value.getText())) {
                this.name.setText(this.value.getText());
                this.value.setText("");
            }
        }

        public void ok() {
            this.variable.setName(this.name.getText());
        }

        public void cancel() {
        }
    }
}

