/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPcanvas;
import CIspace.cspTools.IO;
import CIspace.cspTools.ProblemDialog;
import CIspace.cspTools.TextFrame;
import CIspace.graphToolKit.CanvasTab;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.GrooveCanvas;
import CIspace.graphToolKit.GroovePanel;
import CIspace.graphToolKit.HelpMenu;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.graphToolKit.MessageDialog;
import CIspace.graphToolKit.OpenLocationDialog;
import CIspace.graphToolKit.Point;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;

public class CSPWindow
extends Frame
implements WindowListener,
ItemListener,
ActionListener,
AdjustmentListener {
    protected String title = "CSP vs 1.0";
    protected CSPcanvas canvas;
    protected CSP csp;
    protected CanvasTab tabs;
    private CheckboxGroup createModeGroup;
    private Checkbox[] createModes;
    private CheckboxGroup rightModeGroup;
    private Checkbox[] rightModes;
    public CardLayout cardManager;
    protected Panel main;
    protected Panel cards;
    protected Panel left;
    protected Panel right;
    protected Scrollbar hbar;
    protected Scrollbar vbar;
    private CheckboxMenuItem largeFont;
    private CheckboxMenuItem mediumFont;
    private CheckboxMenuItem smallFont;
    private CheckboxMenuItem otherFont;
    private CheckboxMenuItem wideLine;
    private CheckboxMenuItem mediumLine;
    private CheckboxMenuItem narrowLine;
    private CheckboxMenuItem showCP;
    private CheckboxMenuItem showMP;
    private MenuItem currentText;
    private MessageDialog md;
    protected GridBagConstraints gbc;
    protected GridBagLayout gbl;
    private LabelCanvas lCanvas;
    protected Color bg;
    public Applet applet;
    private String filename;
    private String extension;
    private boolean setCNS = false;

    public CSPWindow(Applet parent) {
        this.applet = parent;
        Color bg = GraphConsts.bg;
        ((Component)this).setBackground(bg);
        this.setForeground(GraphConsts.fg);
        this.setTitle("Hyper CSP Demo");
        ((Component)this).setSize(600, 600);
        this.addWindowListener(this);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.tabs = new CanvasTab();
        this.tabs.addActionListener(this);
        this.tabs.addTab("Create");
        this.tabs.addTab("Solve");
        this.tabs.selectTab("Create");
        Panel card1 = this.getCreatePanel();
        Panel card2 = this.getSolvePanel();
        this.gbc.fill = 1;
        this.cards = new Panel();
        this.cards.setBackground(bg);
        this.cardManager = new CardLayout();
        this.cards.setLayout(this.cardManager);
        this.cards.add("create", card1);
        this.cards.add("solve", card2);
        Panel leftCenter = new Panel();
        leftCenter.setLayout(this.gbl);
        GrooveCanvas west = new GrooveCanvas(4441, bg);
        GrooveCanvas south = new GrooveCanvas(4442, bg);
        GrooveCanvas east = new GrooveCanvas(4443, bg);
        this.addComponent(west, leftCenter, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.cards, leftCenter, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(east, leftCenter, 0, 2, 1, 1, 0.0, 0.0);
        this.addComponent(south, leftCenter, 1, 0, 3, 1, 0.0, 0.0);
        Panel leftBottom = new Panel();
        leftBottom.setBackground(bg);
        leftBottom.setLayout(this.gbl);
        Button resetLabel = new Button("Arrange Constraints");
        resetLabel.addActionListener(this);
        Button autoscale = new Button("Autoscale");
        autoscale.addActionListener(this);
        this.rightModeGroup = new CheckboxGroup();
        this.rightModes = new Checkbox[2];
        this.rightModes[0] = new Checkbox("Pan", this.rightModeGroup, false);
        this.rightModes[1] = new Checkbox("Zoom", this.rightModeGroup, true);
        this.rightModes[0].addItemListener(this);
        this.rightModes[1].addItemListener(this);
        this.addComponent(resetLabel, leftBottom, 0, 0, 2, 1, 0.0, 0.0);
        this.addComponent(autoscale, leftBottom, 1, 0, 2, 1, 0.0, 0.0);
        this.addComponent(this.rightModes[0], leftBottom, 2, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.rightModes[1], leftBottom, 2, 1, 1, 1, 1.0, 0.0);
        GroovePanel groovy = new GroovePanel(((Component)this).getBackground(), leftBottom);
        this.left = new Panel();
        this.left.setLayout(this.gbl);
        this.addComponent(this.tabs, this.left, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(leftCenter, this.left, 1, 0, 1, 1, 0.0, 1.0);
        this.addComponent(groovy, this.left, 2, 0, 1, 1, 0.0, 0.0);
        this.right = new Panel();
        this.lCanvas = new LabelCanvas();
        this.csp = this.getCSP();
        this.canvas = this.getCanvas(this.csp);
        this.csp.init(this.canvas);
        this.right.setLayout(this.gbl);
        this.hbar = new Scrollbar(0, 0, 10, 0, 110);
        this.hbar.setBackground(bg);
        this.hbar.setBlockIncrement(10);
        this.hbar.setValue(50);
        this.hbar.addAdjustmentListener(this);
        this.vbar = new Scrollbar(1, 0, 10, 0, 110);
        this.vbar.setBackground(bg);
        this.vbar.setBlockIncrement(10);
        this.vbar.setValue(50);
        this.vbar.addAdjustmentListener(this);
        Panel gray = new Panel();
        gray.setBackground(bg);
        this.addComponent(this.canvas, this.right, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.vbar, this.right, 0, 1, 1, 2, 0.0, 0.0);
        this.addComponent(this.lCanvas, this.right, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.hbar, this.right, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(gray, this.right, 2, 1, 1, 1, 0.0, 0.0);
        this.main = new Panel();
        this.main.setBackground(bg.darker());
        this.main.setLayout(new BorderLayout());
        this.main.add("West", this.left);
        this.main.add("Center", this.right);
        this.extension = ".txt";
        this.setLayout(new BorderLayout());
        this.add("Center", this.main);
        this.menu();
    }

    public void showWindow() {
        this.centerWindow();
        this.show();
        this.canvas.setGraphics();
        this.canvas.setScrollbars(this.hbar, this.vbar);
    }

    protected CSPcanvas getCanvas(CSP csp) {
        return new CSPcanvas(this, false, csp);
    }

    protected CSP getCSP() {
        return new CSP(this, false);
    }

    protected void reset() {
        this.canvas.reset();
        this.csp.init(this.canvas);
    }

    protected void set(CSPcanvas canvas, CSP csp) {
        this.right.remove(this.canvas);
        this.canvas = canvas;
        canvas.setScrollbars(this.hbar, this.vbar);
        this.csp = csp;
        this.addComponent(canvas, this.right, 0, 0, 1, 1, 1.0, 1.0);
        this.validate();
    }

    private Panel getCreatePanel() {
        Panel panel = new Panel();
        panel.setLayout(this.gbl);
        this.createModeGroup = new CheckboxGroup();
        this.createModes = new Checkbox[6];
        this.createModes[0] = new Checkbox("Create Constraint", this.createModeGroup, false);
        this.createModes[0].addItemListener(this);
        this.createModes[1] = new Checkbox("Create Variable", this.createModeGroup, true);
        this.createModes[1].addItemListener(this);
        this.createModes[2] = new Checkbox("Select Entity", this.createModeGroup, false);
        this.createModes[2].addItemListener(this);
        this.createModes[3] = new Checkbox("Move Entity", this.createModeGroup, false);
        this.createModes[3].addItemListener(this);
        this.createModes[4] = new Checkbox("Delete Entity", this.createModeGroup, false);
        this.createModes[4].addItemListener(this);
        this.createModes[5] = new Checkbox("Set Properties", this.createModeGroup, false);
        this.createModes[5].addItemListener(this);
        this.gbc.fill = 0;
        this.addComponent(this.createModes[0], panel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.createModes[1], panel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[2], panel, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[3], panel, 3, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[4], panel, 4, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.createModes[5], panel, 5, 0, 1, 1, 0.0, 0.0);
        return panel;
    }

    protected Panel getSolvePanel() {
        Panel panel = new Panel();
        Button changeModes = new Button("Change Display");
        changeModes.addActionListener(this);
        this.gbc.fill = 0;
        this.addComponent(changeModes, panel, 6, 0, 1, 1, 0.0, 0.0);
        return panel;
    }

    protected void addComponent(Component c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    protected void addComponent(Component c, Container p, int row, int column, int width, int height, double wx, double wy, GridBagConstraints gbc, GridBagLayout gbl) {
        gbc.gridx = column;
        gbc.gridy = row;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbl.setConstraints(c, gbc);
        p.add(c);
    }

    public void showMessage(String title, String msg) {
        if (this.md == null) {
            this.md = new MessageDialog(this);
        }
        this.md.open(title, msg);
    }

    private void menu() {
        MenuBar menus = new MenuBar();
        Menu file = this.getFileMenu();
        Menu edit = this.getEditMenu();
        Menu options = this.getOptionsMenu();
        Menu help = this.getHelpMenu();
        menus.add(file);
        menus.add(edit);
        menus.add(options);
        menus.setHelpMenu(help);
        this.setMenuBar(menus);
    }

    protected Menu getFileMenu() {
        Menu m = new Menu("File");
        MenuItem mItem = new MenuItem("Create New CSP");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        MenuShortcut shortcut = new MenuShortcut(78);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        mItem = new MenuItem("Load Sample CSP");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(76);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        if (this.applet == null) {
            mItem = new MenuItem("Open CSP");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(79);
            mItem.setShortcut(shortcut);
            m.add(mItem);
            mItem = new MenuItem("Save CSP");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(83);
            mItem.setShortcut(shortcut);
            m.add(mItem);
        }
        mItem = new MenuItem("Open Location");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (this.applet == null) {
            mItem = new MenuItem("Print");
            mItem.setActionCommand(mItem.getLabel());
            mItem.addActionListener(this);
            shortcut = new MenuShortcut(80);
            mItem.setShortcut(shortcut);
            m.add(mItem);
        }
        mItem = new MenuItem("Quit");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        shortcut = new MenuShortcut(81);
        mItem.setShortcut(shortcut);
        m.add(mItem);
        return m;
    }

    protected Menu getEditMenu() {
        Menu m = new Menu("Edit");
        MenuItem mItem = new MenuItem("View/Edit Text Representation");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        m.add(mItem);
        this.currentText = new MenuItem("View Current State Text Representation");
        this.currentText.setActionCommand(this.currentText.getLabel());
        this.currentText.addActionListener(this);
        m.add(this.currentText);
        this.currentText.setEnabled(false);
        return m;
    }

    protected Menu getOptionsMenu() {
        Menu m = new Menu("Options");
        Menu font = new Menu("Font Size");
        this.largeFont = new CheckboxMenuItem("Large (20 pt)", false);
        this.largeFont.addItemListener(this);
        font.add(this.largeFont);
        this.mediumFont = new CheckboxMenuItem("Medium (12 pt)", true);
        this.mediumFont.addItemListener(this);
        font.add(this.mediumFont);
        this.smallFont = new CheckboxMenuItem("Small (9 pt)", false);
        this.smallFont.addItemListener(this);
        font.add(this.smallFont);
        this.otherFont = new CheckboxMenuItem("others...", false);
        this.otherFont.addItemListener(this);
        font.add(this.otherFont);
        m.add(font);
        Menu line = new Menu("Line Width");
        this.wideLine = new CheckboxMenuItem("Wide (4 pixels)", false);
        this.wideLine.addItemListener(this);
        line.add(this.wideLine);
        this.mediumLine = new CheckboxMenuItem("Medium (2 pixels)", false);
        this.mediumLine.addItemListener(this);
        line.add(this.mediumLine);
        this.narrowLine = new CheckboxMenuItem("Narrow (1 pixel)", true);
        this.narrowLine.addItemListener(this);
        line.add(this.narrowLine);
        m.add(line);
        m.addSeparator();
        this.showCP = new CheckboxMenuItem("Show Control Panel", true);
        this.showCP.addItemListener(this);
        m.add(this.showCP);
        this.showMP = new CheckboxMenuItem("Show Message Panel", true);
        this.showMP.addItemListener(this);
        m.add(this.showMP);
        return m;
    }

    protected Menu getControlsMenu() {
        Menu m = new Menu("Controls");
        return m;
    }

    protected Menu getHelpMenu() {
        return new HelpMenu(this.applet, "CSP", this);
    }

    private void loadPreset() {
    }

    public final void newTab(String str) {
        if (str == "Create") {
            this.cardManager.show(this.cards, "create");
            this.canvas.setMode(2220);
            this.currentText.setEnabled(false);
            this.csp.setMode(false);
            this.setMode(false);
        } else if (str == "Solve") {
            this.cardManager.show(this.cards, "solve");
            this.canvas.setMode(2221);
            this.currentText.setEnabled(true);
            this.csp.setMode(true);
            this.setMode(true);
        }
    }

    protected void setMode(boolean solve) {
    }

    public void load(String filename) {
        this.load("saves/", filename);
    }

    public void load(String dir, String filename) {
        try {
            boolean xml;
            this.filename = filename;
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            boolean bl = xml = !ext.equals("txt");
            if (this.applet != null) {
                URL url = new URL(this.applet.getCodeBase() + dir + filename);
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)), xml);
            } else {
                this.load(new BufferedReader(new FileReader(String.valueOf(dir) + filename)), xml);
            }
        }
        catch (IOException e) {
            filename = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(BufferedReader in, boolean xml) {
        try {
            String all = "";
            String errMsg = "";
            Vector<String> lines = new Vector<String>();
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                lines.addElement(line);
                line = in.readLine();
            }
            in.close();
            if (!xml) {
                this.setCNS = true;
                all = IO.parseOld2XML(lines);
            }
            this.updateCSPFromText(all);
            this.setTitle("CSP Version 2.5 --- " + this.filename);
            this.tabs.repaint();
        }
        catch (IOException e) {
            this.showMessage("Error", e.toString());
        }
    }

    public void save(String dir, String filename) {
        if (!filename.endsWith(this.extension)) {
            filename = String.valueOf(filename) + this.extension;
        }
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + filename);
            PrintWriter out = new PrintWriter(fos);
            out.println(IO.createXML(this.csp, false));
            out.close();
            this.setTitle("CSP Version 2.5 --- " + filename);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public boolean updateCSPFromText(String text) {
        CSP newcsp = this.getCSP();
        CSPcanvas newcanvas = this.getCanvas(newcsp);
        newcsp.init(newcanvas);
        if (IO.parseXML(text, newcsp)) {
            this.set(newcanvas, newcsp);
            this.tabs.selectTab("Solve");
            this.newTab("Solve");
            if (this.setCNS) {
                newcsp.setPosition();
            }
            this.setCNS = false;
            return true;
        }
        return false;
    }

    public void setPromptLabel(String str) {
        this.lCanvas.setText(str);
    }

    public String getPromptLabel() {
        return this.lCanvas.getText();
    }

    public void blinkLabel() {
        this.lCanvas.blink();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.canvas.disposeWindows();
        if (this.md != null) {
            this.md.dispose();
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        String arg = e.getItem().toString();
        if (arg.equals("Create Variable")) {
            this.canvas.setSubmode(351);
            this.setPromptLabel("Click the canvas to create a node.");
        } else if (arg.equals("Create Constraint")) {
            this.canvas.setSubmode(350);
            this.setPromptLabel("Click on the canvas to create a constraint.");
        } else if (arg.equals("Select Entity")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        } else if (arg.equals("Move Entity")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click and drag an entity to move it around.");
        } else if (arg.equals("Delete Entity")) {
            this.canvas.setSubmode(3333);
            this.setPromptLabel("Click on an entity to delete.");
        } else if (arg.equals("Set Properties")) {
            this.canvas.setSubmode(3334);
            this.setPromptLabel("Click on an entity to set its properties.");
        } else if (arg.equals("Pan")) {
            this.canvas.setRMode(4440);
            this.setPromptLabel("Drag the right mouse button to pan the CSP.");
        } else if (arg.equals("Zoom")) {
            this.canvas.setRMode(4441);
            this.setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
        } else if (arg.equals("Large (20 pt)")) {
            this.canvas.changeFont(20);
            this.largeFont.setState(true);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Medium (12 pt)")) {
            this.canvas.changeFont(12);
            this.largeFont.setState(false);
            this.mediumFont.setState(true);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Small (9 pt)")) {
            this.canvas.changeFont(9);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(true);
            this.otherFont.setState(false);
        } else if (arg.equals("others...")) {
            this.canvas.changeFont(-1);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(true);
        } else if (arg.equals("Wide (4 pixels)")) {
            this.canvas.graph.setLineWidth(4);
            this.canvas.changeLineWidth();
            this.wideLine.setState(true);
            this.mediumLine.setState(false);
            this.narrowLine.setState(false);
        } else if (arg.equals("Medium (2 pixels)")) {
            this.canvas.graph.setLineWidth(2);
            this.canvas.changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(true);
            this.narrowLine.setState(false);
        } else if (arg.equals("Narrow (1 pixel)")) {
            this.canvas.graph.setLineWidth(1);
            this.canvas.changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(false);
            this.narrowLine.setState(true);
        } else if (arg.equals("Show Control Panel")) {
            this.left.setVisible(this.showCP.getState());
            this.validate();
        } else if (arg.equals("Show Message Panel")) {
            this.lCanvas.setVisible(this.showMP.getState());
            this.validate();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("canvasTab")) {
            this.newTab(this.tabs.getSelectedTab());
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Arrange Constraints")) {
            this.csp.setPosition();
            this.canvas.repaint();
        } else if (arg.equals("Create New CSP")) {
            this.setTitle("CSP Version 2.0 --- untitled.txt");
            this.reset();
            this.tabs.selectTab("Create");
            this.tabs.repaint();
            this.newTab("Create");
        } else if (arg.equals("Open CSP")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            FileDialog load = new FileDialog((Frame)this, "Open CSP", 0);
            load.setDirectory("saves/");
            ((Component)load).setLocation(0, 0);
            load.show();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
            String filename = load.getFile();
            String dir = load.getDirectory();
            if (filename == null) {
                return;
            }
            this.load(dir, filename);
        } else if (arg.equals("Open Location")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            OpenLocationDialog old = new OpenLocationDialog(this);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
            String urlString = old.url;
            if (urlString != null) {
                this.filename = urlString.substring(urlString.lastIndexOf("/") + 1);
                try {
                    String ext = this.filename.substring(this.filename.lastIndexOf(".1"));
                    boolean xml = !ext.equals("txt");
                    URL url = new URL(urlString);
                    InputStream iStream = url.openStream();
                    this.load(new BufferedReader(new InputStreamReader(iStream)), xml);
                }
                catch (IOException exc) {
                    this.showMessage("Error", exc.toString());
                }
            }
        } else if (arg.equals("Save CSP")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            FileDialog save = new FileDialog((Frame)this, "Save CSP", 1);
            save.setDirectory("saves");
            save.setFile(this.getTitle().substring(this.getTitle().indexOf("--- ") + 4));
            ((Component)save).setLocation(0, 0);
            save.show();
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
            String filename = save.getFile();
            String dir = save.getDirectory();
            if (filename == null) {
                return;
            }
            this.save(dir, filename);
        } else if (arg.equals("Load Sample CSP")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            ProblemDialog pDialog = new ProblemDialog(this);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Print")) {
            this.canvas.print(this.getTitle().substring(this.getTitle().indexOf("--- ") + 4));
        } else if (arg.equals("Quit")) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (arg.equals("View Prolog Code")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("View/Edit Text Representation")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            String textRep = IO.createXML(this.csp, false);
            TextFrame tf = new TextFrame(this, textRep, true);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("View Current State Text Representation")) {
            this.setCursor(GraphConsts.WAIT_CURSOR);
            String textRep = IO.createXML(this.csp, true);
            TextFrame tf = new TextFrame(this, textRep, false);
            this.setCursor(GraphConsts.DEFAULT_CURSOR);
        } else if (arg.equals("Create New CSP")) {
            this.canvas.reset();
            this.tabs.selectTab("Create");
            this.tabs.repaint();
            this.newTab("Create");
        } else if (arg.equals("Print")) {
            this.canvas.print("No Title");
        } else if (arg.equals("Quit")) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (arg.equals("Change Display")) {
            this.csp.changeDisplayMode();
            this.canvas.repaint();
            this.setPromptLabel("");
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int width = this.canvas.getSize().width;
        int x0 = (int)((double)(width * (this.hbar.getValue() - 50)) / 100.0);
        int height = this.canvas.getSize().height;
        int y0 = (int)((double)(width * (this.vbar.getValue() - 50)) / 100.0);
        this.canvas.offset(-x0, -y0);
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        ((Component)this).setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    public static void main(String[] args) {
        CSPWindow window = new CSPWindow(null);
        window.showWindow();
    }
}

