/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPgraph;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.ConstraintEdge;
import CIspace.cspTools.Relation;
import CIspace.cspTools.RelationDialog;
import CIspace.cspTools.VariableDialog;
import CIspace.cspTools.domains.DomainBoolean;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class CSPcanvas
extends GraphCanvas {
    public static final int C_CREATE_CONSTRAINT = 350;
    public static final int C_CREATE_VARIABLE = 351;
    private boolean makingHOConstraint = false;
    private boolean addingVar2Constraint = false;
    private Vector tempvariables = new Vector();
    protected CSP csp;
    protected boolean noInteraction = false;
    private VariableDialog variableDialog;
    private RelationDialog relationDialog;

    public CSPcanvas(Container parent, boolean inline, CSP csp) {
        super(parent, inline);
        this.submode = 351;
        this.csp = csp;
        this.graph = new CSPgraph(csp, this);
    }

    public void noInteraction(boolean bool) {
        this.noInteraction = bool;
    }

    protected void popupCanvas(int x, int y) {
        if (this.mode == 2220) {
            this.popupCCanv();
        }
        if (this.mode == 2221) {
            this.popupSCanv();
        }
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        if (this.entClicked instanceof CSPVariable) {
            if (this.mode == 2220) {
                this.popupCVar();
            }
            if (this.mode == 2221) {
                this.popupSVar();
            }
        } else {
            if (this.mode == 2220) {
                this.popupCCns();
            }
            if (this.mode == 2221) {
                this.popupSCns();
            }
        }
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        if (this.mode == 2220) {
            this.popupCEdge();
        }
        if (this.mode == 2221) {
            this.popupSEdge();
        }
        this.pop.show(this, x, y);
    }

    public void setPromptLabel(String s) {
    }

    public String getPromptLabel() {
        return null;
    }

    public String parse(String str) {
        return "ERROR PARSE NOT IMPLEMENTED";
    }

    public void disposeWindows() {
        super.disposeWindows();
    }

    protected void createVariable(Entity ent, Point p) {
        if (ent != null) {
            return;
        }
        this.repaint();
        this.pause();
        DomainBoolean dom = new DomainBoolean();
        CSPVariable var = this.csp.newVariable(dom, (CSPgraph)this.graph, p);
        this.variableDialog = new VariableDialog((Frame)this.parent, var, this.csp, true);
        if (!this.variableDialog.cancelled) {
            this.csp.addVariable(var);
            var.setLabel();
        }
        this.unpause();
    }

    protected void createConstraint(Entity ent, Point p) {
        this.repaint();
        this.pause();
        Constraint cns = this.csp.newConstraint((CSPgraph)this.graph, p, new Vector(), 1, this.csp);
        this.relationDialog = new RelationDialog((Frame)this.parent, null, cns, true);
        if (!this.relationDialog.cancelled) {
            this.csp.addConstraint(cns);
            cns.setLabel();
        } else {
            cns.delete();
        }
        this.unpause();
    }

    protected void createConstraint(Vector variables) {
        float bottom;
        float right;
        this.repaint();
        this.pause();
        if (variables.size() == 0) {
            System.out.println("ERROR NO VARIABLES");
            return;
        }
        Enumeration v = variables.elements();
        Node n = (Node)v.nextElement();
        float left = right = n.pos.x;
        float top = bottom = n.pos.y;
        while (v.hasMoreElements()) {
            n = (Node)v.nextElement();
            if (n.pos.x < left) {
                left = n.pos.x;
            }
            if (n.pos.x > right) {
                right = n.pos.x;
            }
            if (n.pos.y < bottom) {
                bottom = n.pos.y;
            }
            if (!(n.pos.y > top)) continue;
            top = n.pos.y;
        }
        Point p = variables.size() > 1 ? new Point((left + right) / 2.0f, (top + bottom) / 2.0f) : new Point(left, top + 100.0f);
        Constraint cns = this.csp.newConstraint((CSPgraph)this.graph, p, variables, 1, this.csp);
        this.relationDialog = new RelationDialog((Frame)this.parent, null, cns, true);
        if (!this.relationDialog.cancelled) {
            this.csp.addConstraint(cns);
            cns.setLabel();
        } else {
            cns.delete();
        }
        this.unpause();
    }

    protected final void createAConstraint(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
            this.makingEdge = 0;
            if (ent == null || !(ent instanceof Node)) {
                this.pause();
                if (this.from instanceof CSPVariable) {
                    Vector<Node> tempVariable = new Vector<Node>(1);
                    tempVariable.addElement(this.from);
                    this.createConstraint(tempVariable);
                }
                this.unpause();
            } else {
                this.pause();
                this.to = (Node)ent;
                if (!this.to.equals(this.from)) {
                    if (this.to instanceof Constraint && this.from instanceof CSPVariable) {
                        Constraint cns = (Constraint)this.to;
                        if (cns.addVariable((CSPVariable)this.from)) {
                            if (cns.openRD()) {
                                new RelationDialog((Frame)this.parent, cns.getRelation(), cns, true);
                            }
                            cns.setLabel();
                        }
                    } else if (this.to instanceof CSPVariable) {
                        if (this.from instanceof Constraint) {
                            Constraint cns = (Constraint)this.from;
                            if (cns.addVariable((CSPVariable)this.to) && cns.openRD()) {
                                new RelationDialog((Frame)this.parent, cns.getRelation(), cns, true);
                            }
                            cns.setLabel();
                        } else if (this.from instanceof CSPVariable) {
                            Vector<Node> tempvariables = new Vector<Node>(2);
                            tempvariables.addElement(this.from);
                            tempvariables.addElement(this.to);
                            this.createConstraint(tempvariables);
                        }
                    }
                }
                this.unpause();
            }
        } else if (ent == null) {
            this.createConstraint(ent, p);
        } else if (ent instanceof Node) {
            this.from = (Node)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    protected void editVariable(CSPVariable var) {
        this.pause();
        this.variableDialog = new VariableDialog((Frame)this.parent, var, this.csp, true);
        this.unpause();
    }

    protected void editConstraint(Constraint cns) {
        Relation rel = cns.getRelation();
        this.pause();
        this.relationDialog = new RelationDialog((Frame)this.parent, rel, cns, true);
        if (!this.relationDialog.cancelled) {
            cns.setRelation(this.relationDialog.getRelation());
            cns.setLabel();
        }
        this.unpause();
    }

    protected void inspectVariable(CSPVariable var) {
        this.pause();
        this.variableDialog = new VariableDialog((Frame)this.parent, var, this.csp, false);
        if (!this.variableDialog.cancelled) {
            this.csp.addVariable(var);
        }
        this.unpause();
    }

    protected void inspectConstraint(Constraint cns) {
        Relation rel = cns.getRelation();
        this.pause();
        this.relationDialog = new RelationDialog((Frame)this.parent, rel, cns, false);
        if (!this.relationDialog.cancelled) {
            cns.setRelation(this.relationDialog.getRelation());
        }
        this.unpause();
    }

    protected Entity mPressed(MouseEvent e) {
        if (this.noInteraction) {
            return null;
        }
        Entity ent = super.mPressed(e);
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        if (e.getModifiers() == 4) {
            return ent;
        }
        if (this.mode == 2220) {
            if (this.submode == 351) {
                this.createVariable(ent, p);
            } else if (this.submode == 350) {
                this.createAConstraint(ent, p);
            } else if (this.submode == 3333 && ent != null) {
                this.deleteEnt(ent);
            }
        }
        this.repaint();
        return ent;
    }

    protected void mMoved(MouseEvent e) {
        if (this.noInteraction) {
            return;
        }
        super.mMoved(e);
        if (!this.ready) {
            return;
        }
        Point p = new Point((float)e.getX() - this.origin.x - this.offset.x, (float)e.getY() - this.origin.y - this.offset.y);
        if (this.submode == 350 && this.makingEdge == 1) {
            this.mMovedPos.move(p);
            this.repaint();
        }
    }

    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            Constraint cns;
            if (ent instanceof Constraint) {
                cns = (Constraint)ent;
                this.editConstraint(cns);
            }
            if (ent instanceof CSPVariable) {
                CSPVariable var = (CSPVariable)ent;
                this.editVariable(var);
            }
            if (ent instanceof ConstraintEdge) {
                cns = ((ConstraintEdge)ent).getConstraint();
                this.editConstraint(cns);
            }
        }
    }

    protected final void aPerformed(ActionEvent e) {
        if (this.noInteraction) {
            return;
        }
        if (this.mode == 2221) {
            this.aSolvePerformed(e);
        } else {
            super.aPerformed(e);
        }
        this.graph.deselectAll();
    }

    protected void aSolvePerformed(ActionEvent e) {
        System.out.println("aSolveAction");
    }

    protected final void popupStands() {
        this.pop.addSeparator();
        MenuItem mItem = new MenuItem("Autoscale");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Reset Edge Labels");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
    }

    protected final void popupCCanv() {
        this.pop.setLabel("Canvas Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Create Variable");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Create Constraint");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.popupStands();
    }

    protected final void popupCCns() {
        this.pop.setLabel("Constraint Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Add Variable to Constraint");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Properties");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Delete");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.popupStands();
    }

    protected final void popupCVar() {
        this.pop.setLabel("Variable Options");
        this.pop.removeAll();
        MenuItem mItem = new MenuItem("Add Variable to Constraint");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Properties");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new MenuItem("Delete");
        mItem.setActionCommand(mItem.getLabel());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.popupStands();
    }

    protected final void popupCEdge() {
    }

    protected void popupSCanv() {
    }

    protected void popupSCns() {
    }

    protected void popupSVar() {
    }

    protected void popupSEdge() {
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "Add Variable to Constraint") {
            this.createAConstraint(this.entClicked, this.mClickedPos);
            this.tmpMode = this.submode;
            this.submode = 350;
        } else if (e.getActionCommand() == "Create Variable") {
            this.createVariable(this.entClicked, this.mClickedPos);
        } else if (e.getActionCommand() == "Create Constraint") {
            this.createConstraint(this.entClicked, this.mClickedPos);
        }
    }

    public void reset() {
        this.graph = new CSPgraph(this.csp, this);
        this.clearMouse();
        this.repaint();
    }

    public CSP getCSP() {
        return this.csp;
    }
}

