/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPcanvas;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.ConstraintEdge;
import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import java.util.Enumeration;
import java.util.Vector;

public class CSPgraph
extends Graph {
    protected CSP csp;

    public CSPgraph(CSP csp, CSPcanvas canvas) {
        super(canvas);
        this.csp = csp;
    }

    public void forget(Entity ent) {
        if (ent instanceof Node) {
            this.nodes.removeElement(ent);
        }
        if (ent instanceof Edge) {
            this.edges.removeElement(ent);
        }
    }

    public void deleteSelected() {
        Enumeration e = this.selectedEdges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!(edge instanceof ConstraintEdge)) continue;
            this.deleteConstraintEdge((ConstraintEdge)edge);
        }
        Enumeration n = this.selectedNodes.elements();
        while (n.hasMoreElements()) {
            Node node = (Node)n.nextElement();
            if (node instanceof Constraint) {
                this.deleteConstraint((Constraint)node);
            }
            if (!(node instanceof CSPVariable)) continue;
            this.deleteVariable((CSPVariable)node);
        }
        this.csp.checkEditablity();
        super.deleteSelected();
    }

    private void deleteConstraintEdge(ConstraintEdge edge) {
        CSPVariable var = edge.getVariable();
        Constraint cns = edge.getConstraint();
        if (cns != null && var != null) {
            cns.removeVariable(var);
        }
    }

    private void deleteConstraint(Constraint cns) {
        cns.delete();
        this.csp.remConstraint(cns);
    }

    private void deleteVariable(CSPVariable var) {
        Vector[] varEdges = var.getAllEdges();
        int i = 0;
        while (i < 2) {
            Enumeration e = varEdges[i].elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof ConstraintEdge)) continue;
                this.deleteConstraintEdge((ConstraintEdge)o);
            }
            ++i;
        }
        this.nodes.removeElement(var);
        this.csp.remVariable(var);
    }
}

