/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPgraph;
import CIspace.cspTools.ConstraintEdge;
import CIspace.cspTools.Relation;
import CIspace.cspTools.VariableEdge;
import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class Constraint
extends Node {
    public static final int DCONNECT = 0;
    public static final int DSTANDARD = 1;
    public static final Color COLOR_NEUTRAL = Color.black;
    public static final Color COLOR_TRUE = Color.green;
    public static final Color COLOR_FALSE = Color.red;
    public static final Color COLOR_SUFFIC = Color.black;
    public static final Color COLOR_UNSUFF = Color.orange;
    private int displayMode;
    protected Vector variables;
    protected Relation relation;
    protected static int arity;
    protected boolean solve;
    protected Vector connectEdges;
    protected Vector standEdges;
    protected AffirmPanel cnsEdit;
    protected CSP csp;

    public Constraint(CSPgraph graph, Point point, Vector variables, int displayMode, CSP csp) {
        super(graph, "Constraint", point, COLOR_NEUTRAL, 1111);
        if (variables == null) {
            variables = new Vector();
        }
        this.variables = new Vector();
        this.connectEdges = new Vector();
        this.standEdges = new Vector();
        this.setDisplayMode(displayMode);
        this.csp = csp;
        int i = variables.size() - 1;
        while (i >= 0) {
            CSPVariable var = (CSPVariable)variables.elementAt(i);
            this.add(var);
            --i;
        }
    }

    public void setRelation(Relation r) {
        this.relation = r;
        this.setLabel();
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Vector getVariables() {
        return this.variables;
    }

    public void setVariables(Vector vars) {
        this.variables = vars;
    }

    public final boolean containsVariable(CSPVariable var) {
        return this.variables.contains(var);
    }

    public final boolean containsEdge(Edge edge) {
        return this.standEdges.contains(edge) || this.connectEdges.contains(edge);
    }

    public final int variableIndex(CSPVariable var) {
        return this.variables.indexOf(var);
    }

    public boolean test() {
        return this.relation.test();
    }

    public boolean getAllowed(int[] v) {
        return this.relation.getAllowed(v);
    }

    public boolean viable(int var, int val) {
        return this.relation.viable(var, val);
    }

    protected boolean testVar(CSPVariable var) {
        return this.relation.testVar(var);
    }

    protected boolean complete() {
        return this.relation.complete();
    }

    public Vector getConstraintEdges() {
        return this.standEdges;
    }

    protected final boolean addVariable(CSPVariable var) {
        if (!this.testVar(var)) {
            return false;
        }
        if (this.variables.contains(var)) {
            return false;
        }
        if (this.add(var)) {
            this.relation.addDomain(var.getDomain());
            return true;
        }
        return false;
    }

    private final boolean add(CSPVariable var) {
        boolean drawedge = this.displayMode == 1;
        ConstraintEdge constedge = this.csp.newConstraintEdge(this, this.graph, var);
        this.standEdges.addElement(constedge);
        constedge.setDraw(true);
        this.graph.addEdge(constedge);
        Enumeration v = this.variables.elements();
        while (v.hasMoreElements()) {
            VariableEdge varedge = this.csp.newVariableEdge(this, this.graph, var, (CSPVariable)v.nextElement());
            varedge.setDraw(true);
            this.connectEdges.addElement(varedge);
        }
        this.variables.insertElementAt(var, 0);
        var.setEdit(false);
        return true;
    }

    protected final boolean removeVariable(CSPVariable var) {
        Edge edge;
        this.variables.removeElement(var);
        Enumeration e = this.connectEdges.elements();
        while (e.hasMoreElements()) {
            edge = (Edge)e.nextElement();
            if (!edge.end.equals(var) && !edge.start.equals(var)) continue;
            this.connectEdges.removeElement(edge);
            this.graph.select(edge);
            this.graph.deleteSelected();
        }
        e = this.standEdges.elements();
        while (e.hasMoreElements()) {
            edge = (Edge)e.nextElement();
            if (!edge.end.equals(var) && !edge.start.equals(var)) continue;
            this.standEdges.removeElement(edge);
            this.graph.select(edge);
            this.graph.deleteSelected();
        }
        this.relation.removeDomain(var.getDomain());
        this.setLabel();
        return true;
    }

    public void setLabel() {
        if (this.relation == null) {
            this.setLabel("Constraint");
        } else {
            this.setLabel(CSP.trim(this.relation.getLabel()));
        }
        this.updateSize();
    }

    public final void setDisplayMode(int mode) {
        block7: {
            block6: {
                if (mode != 1) break block6;
                if (this.displayMode == 1) {
                    return;
                }
                this.displayMode = 1;
                Enumeration e = this.connectEdges.elements();
                while (e.hasMoreElements()) {
                    ((CSPgraph)this.graph).forget((Entity)e.nextElement());
                }
                this.graph.addNode(this);
                e = this.standEdges.elements();
                while (e.hasMoreElements()) {
                    this.graph.addEdge((Edge)e.nextElement());
                }
                break block7;
            }
            if (mode != 0) break block7;
            if (this.displayMode == 0) {
                return;
            }
            this.displayMode = 0;
            ((CSPgraph)this.graph).forget(this);
            Enumeration e = this.standEdges.elements();
            while (e.hasMoreElements()) {
                ((CSPgraph)this.graph).forget((Entity)e.nextElement());
            }
            e = this.connectEdges.elements();
            while (e.hasMoreElements()) {
                this.graph.addEdge((Edge)e.nextElement());
            }
        }
    }

    public final void changeDisplayMode() {
        if (this.displayMode == 1) {
            this.setDisplayMode(0);
        } else if (this.displayMode == 0) {
            this.setDisplayMode(1);
        }
    }

    public final void delete() {
        Edge edge;
        Enumeration e = this.standEdges.elements();
        while (e.hasMoreElements()) {
            edge = (Edge)e.nextElement();
            this.standEdges.removeElement(edge);
            this.removeEdge(edge);
            ((CSPgraph)this.graph).forget(edge);
        }
        e = this.connectEdges.elements();
        while (e.hasMoreElements()) {
            edge = (Edge)e.nextElement();
            this.connectEdges.removeElement(edge);
            this.removeEdge(edge);
            ((CSPgraph)this.graph).forget(edge);
        }
        ((CSPgraph)this.graph).forget(this);
    }

    private final void removeEdge(Edge e) {
        e.end.removeEdgesIn(e);
        e.start.removeEdgesOut(e);
    }

    public boolean openRD() {
        return this.relation.openRD();
    }

    protected final void setColor(Color color) {
        this.color = color;
        Enumeration e = this.standEdges.elements();
        while (e.hasMoreElements()) {
            ((Edge)e.nextElement()).color = color;
        }
        e = this.connectEdges.elements();
        while (e.hasMoreElements()) {
            ((Edge)e.nextElement()).color = color;
        }
    }

    protected final void setVarColor(CSPVariable var, Color col) {
    }

    public final int index(CSPVariable var) {
        return this.variables.indexOf(var);
    }

    public final void draw(Graphics offscreen, boolean moving) {
        if (this.displayMode == 1) {
            super.draw(offscreen, moving);
        }
    }

    public final void setPosition() {
        float bottom;
        float right;
        Enumeration v = this.variables.elements();
        Node n = (Node)v.nextElement();
        float left = right = n.pos.x;
        float top = bottom = n.pos.y;
        while (v.hasMoreElements()) {
            n = (Node)v.nextElement();
            if (n.pos.x < left) {
                left = n.pos.x;
            }
            if (n.pos.x > right) {
                right = n.pos.x;
            }
            if (n.pos.y < bottom) {
                bottom = n.pos.y;
            }
            if (!(n.pos.y > top)) continue;
            top = n.pos.y;
        }
        Point p = this.variables.size() > 1 ? new Point((left + right) / 2.0f, (top + bottom) / 2.0f) : new Point(left, top + 100.0f);
        this.graph.moveEntities(p, this);
    }

    public void setMode(boolean solve) {
        this.solve = solve;
        if (solve) {
            if (this.complete()) {
                this.setColor(COLOR_SUFFIC);
            } else {
                this.setColor(COLOR_UNSUFF);
            }
        } else if (this.complete()) {
            this.setColor(COLOR_SUFFIC);
        } else {
            this.setColor(COLOR_UNSUFF);
        }
    }

    public String toXML(String indent) {
        String rep = "";
        rep = String.valueOf(rep) + indent + "<" + "CONSTRAINT" + " " + "TYPE" + "=" + '\"' + this.relation.getType() + '\"' + ">\n";
        int i = 0;
        while (i < this.variables.size()) {
            rep = String.valueOf(rep) + indent + "\t<" + "GIVEN" + ">";
            rep = String.valueOf(rep) + ((CSPVariable)this.variables.elementAt(i)).getName();
            rep = String.valueOf(rep) + "</GIVEN>\n";
            ++i;
        }
        rep = String.valueOf(rep) + this.relation.additionalXML(String.valueOf(indent) + "\t");
        rep = String.valueOf(rep) + indent + "\t<" + "PROPERTY" + ">";
        rep = String.valueOf(rep) + "position = (" + this.pos.x + ", " + this.pos.y + ")";
        rep = String.valueOf(rep) + "</PROPERTY>\n";
        rep = String.valueOf(rep) + indent + "</" + "CONSTRAINT" + ">\n";
        return rep;
    }
}

