/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.XMLReader.Pair;
import CIspace.XMLReader.XMLBlock;
import CIspace.XMLReader.XMLTree;
import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.CSPgraph;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.Relation;
import CIspace.cspTools.domains.DomainChooser;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.cspTools.relations.RelationChooser;
import CIspace.graphToolKit.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class IO {
    public static final String xmltag = "CSPIF";
    public static final String xmlvatt = "VERSION";
    public static final String xmlversion = "0.01";
    public static final String csptag = "CSP";
    public static final String nametag = "NAME";
    public static final String vartag = "VARIABLE";
    public static final String atttype = "TYPE";
    public static final String proptag = "PROPERTY";
    public static final String valtag = "VALUE";
    public static final String cnstag = "CONSTRAINT";
    public static final String inptag = "GIVEN";
    public static final String tabletag = "TABLE";
    public static final String argtag = "ARGS";
    private static Hashtable ht;
    private static Hashtable ht2;

    public static String createXML(CSP csp, boolean current) {
        String xml = "";
        xml = String.valueOf(xml) + IO.header();
        xml = String.valueOf(xml) + csp.toXML("", current);
        xml = String.valueOf(xml) + IO.footer();
        return xml;
    }

    private static String header() {
        return "<CSPIF VERSION=\"0.01\">\n";
    }

    private static String footer() {
        return "</CSPIF>\n";
    }

    public static boolean parseXML(String xml, CSP csp) {
        boolean value = false;
        XMLTree tree = new XMLTree();
        tree.readString(xml);
        XMLBlock head = tree.getHead();
        if (head.getTag().equals(csptag)) {
            value = IO.parseCSP(head, csp);
        } else if (head.getTag().equals(xmltag)) {
            Object cspblock = null;
            Vector csps = head.searchChildTag(csptag);
            if (csps != null) {
                value = IO.parseCSP((XMLBlock)csps.elementAt(0), csp);
            }
        }
        if (!value) {
            IO.parseError("No CSP Tags found");
        } else {
            csp.resetLabels();
        }
        return value;
    }

    public static boolean parseCSP(XMLBlock block, CSP csp) {
        XMLBlock current;
        Enumeration e;
        Vector variables = block.searchChildTag(vartag);
        Vector constraints = block.searchChildTag(cnstag);
        Vector names = block.searchChildTag(nametag);
        if (names == null || names.size() == 0) {
            csp.setName("Untitled");
        } else {
            csp.setName(((XMLBlock)names.elementAt(0)).getText());
        }
        if (variables != null) {
            e = variables.elements();
            while (e.hasMoreElements()) {
                current = (XMLBlock)e.nextElement();
                if (IO.parseVariable(current, csp)) continue;
                return false;
            }
        }
        if (constraints != null) {
            e = constraints.elements();
            while (e.hasMoreElements()) {
                current = (XMLBlock)e.nextElement();
                if (IO.parseConstraint(current, csp)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean parseVariable(XMLBlock block, CSP csp) {
        DomainDiscrete domain;
        String name = null;
        Point p = null;
        String type = null;
        Vector values = null;
        Vector<String> stringValues = new Vector<String>();
        Vector properties = block.getProperties();
        if (properties.size() != 1) {
            IO.parseError("Incorrect Properties Length\n" + block.toString());
            return false;
        }
        Pair property = (Pair)properties.elementAt(0);
        if (!property.name.equals(atttype)) {
            IO.parseError("Incorrect Property " + property.name + " " + property.value);
            return false;
        }
        type = IO.strip(property.value).nextToken();
        values = block.searchChildTag(valtag);
        Vector names = block.searchChildTag(nametag);
        Vector props = block.searchChildTag(proptag);
        if (names != null && names.size() != 0) {
            name = ((XMLBlock)names.elementAt(0)).getText();
        }
        if (props != null && props.size() != 0) {
            StringTokenizer tkn = IO.strip(((XMLBlock)props.elementAt(0)).getText());
            if (!tkn.nextToken().equals("position")) {
                IO.parseError("Unknown Property");
            } else {
                try {
                    p = new Point();
                    String val = tkn.nextToken();
                    Float point = new Float(val);
                    p.x = point.floatValue();
                    val = tkn.nextToken();
                    point = new Float(val);
                    p.y = point.floatValue();
                }
                catch (Exception e) {
                    p = null;
                    IO.parseError("Incorrect Position Syntax");
                }
            }
        }
        if (values != null) {
            Enumeration e = values.elements();
            while (e.hasMoreElements()) {
                XMLBlock value = (XMLBlock)e.nextElement();
                stringValues.addElement(value.getText());
            }
        }
        if ((domain = DomainChooser.newObject(type)) == null) {
            IO.parseError("Variable TYPE " + type + " Not Found");
            return false;
        }
        domain.clear();
        Enumeration e = stringValues.elements();
        while (e.hasMoreElements()) {
            domain.addElement((String)e.nextElement());
        }
        if (p == null) {
            p = csp.getPos();
        }
        CSPVariable var = csp.newVariable(domain, (CSPgraph)csp.getCanvas().graph, p);
        if (name == null) {
            name = csp.getName();
        }
        var.setName(name);
        csp.addVariable(var);
        return true;
    }

    public static boolean parseConstraint(XMLBlock block, CSP csp) {
        Point p = null;
        String type = null;
        Vector variables = block.searchChildTag(inptag);
        Vector props = block.searchChildTag(proptag);
        Vector args = block.searchChildTag(argtag);
        Vector table = block.searchChildTag(tabletag);
        Vector<String> stringVarNames = new Vector<String>();
        Vector properties = block.getProperties();
        if (properties.size() != 1) {
            IO.parseError("Incorrect Properties Length\n" + block.toString());
            return false;
        }
        Pair property = (Pair)properties.elementAt(0);
        if (!property.name.equals(atttype)) {
            IO.parseError("Incorrect Property " + property.name + " " + property.value);
            return false;
        }
        type = IO.strip(property.value).nextToken();
        if (props != null && props.size() != 0) {
            StringTokenizer tkn = IO.strip(((XMLBlock)props.elementAt(0)).getText());
            if (!tkn.nextToken().equals("position")) {
                IO.parseError("Unknown Property");
            } else {
                try {
                    p = new Point();
                    String val = tkn.nextToken();
                    Float point = new Float(val);
                    p.x = point.floatValue();
                    val = tkn.nextToken();
                    point = new Float(val);
                    p.y = point.floatValue();
                }
                catch (Exception e) {
                    p = null;
                    IO.parseError("Incorrect Position Syntax");
                }
            }
        }
        if (variables != null) {
            Enumeration e = variables.elements();
            while (e.hasMoreElements()) {
                XMLBlock value = (XMLBlock)e.nextElement();
                stringVarNames.addElement(value.getText());
            }
        }
        Vector<CSPVariable> vars = new Vector<CSPVariable>();
        Enumeration e = stringVarNames.elements();
        while (e.hasMoreElements()) {
            String nm = (String)e.nextElement();
            CSPVariable v = csp.getVariable(nm);
            if (v != null) {
                vars.addElement(v);
                continue;
            }
            IO.parseError("GIVEN " + nm + " does not have corresponding variable");
        }
        if (p == null) {
            p = csp.getPos();
        }
        Constraint cns = csp.newConstraint((CSPgraph)csp.getCanvas().graph, p, vars, 1, csp);
        Relation relation = RelationChooser.newObject(type, cns);
        cns.setRelation(relation);
        if (args != null && args.size() != 0) {
            relation.setArgs(IO.strip(((XMLBlock)args.elementAt(0)).getText()));
        }
        relation.reset();
        if (table != null && table.size() != 0) {
            relation.setArgs(IO.strip(((XMLBlock)table.elementAt(0)).getText()));
        }
        csp.addConstraint(cns);
        return true;
    }

    private static StringTokenizer strip(String s) {
        StringTokenizer tkn = new StringTokenizer(s, " \"=(,)\t\n");
        return tkn;
    }

    public static void parseError(String error) {
        System.err.println("XML Parsing Error: " + error);
    }

    public static String parseOld2XML(Vector oldGraph) {
        ht = new Hashtable();
        ht2 = new Hashtable();
        String xml = "<!--Translated From Original CIspace CSP Format-->\n" + IO.header() + "<" + csptag + ">\n";
        Enumeration e = oldGraph.elements();
        while (e.hasMoreElements()) {
            xml = String.valueOf(xml) + IO.parseOldLine((String)e.nextElement());
        }
        xml = String.valueOf(xml) + "</CSP>\n" + IO.footer();
        ht = null;
        ht2 = null;
        return xml;
    }

    private static String parseOldLine(String line) {
        String val = "";
        StringTokenizer ln = new StringTokenizer(line, ":,/;*");
        if (!ln.hasMoreTokens()) {
            return val;
        }
        String lntype = ln.nextToken();
        if (lntype.charAt(0) == '%') {
            return "";
        }
        if (lntype.charAt(0) == 'n') {
            int numvals = 0;
            Integer index = new Integer(ln.nextToken());
            String name = ln.nextToken();
            Float xcoord = new Float(ln.nextToken());
            Float ycoord = new Float(ln.nextToken());
            String type = ln.nextToken();
            Vector<String> domain = new Vector<String>();
            while (ln.hasMoreTokens()) {
                ++numvals;
                domain.addElement(ln.nextToken());
            }
            if (type.toUpperCase().equals("BOOLEAN")) {
                domain.addElement("true");
                domain.addElement("false");
            }
            ht.put(index, name);
            ht2.put(index, new Integer(numvals));
            val = String.valueOf(val) + "<VARIABLE TYPE=" + type + ">\n";
            val = String.valueOf(val) + "\t<NAME>" + name + "</" + nametag + ">\n";
            val = String.valueOf(val) + "\t<PROPERTY>position =" + xcoord + "," + ycoord + "</" + proptag + ">\n";
            Enumeration e = domain.elements();
            while (e.hasMoreElements()) {
                val = String.valueOf(val) + "\t<VALUE>" + (String)e.nextElement() + "</" + valtag + ">\n";
            }
            val = String.valueOf(val) + "</VARIABLE>\n";
        } else if (lntype.charAt(0) == 'e' && !lntype.equals("endConstraintGraph")) {
            Integer index0 = new Integer(ln.nextToken());
            Integer index1 = new Integer(ln.nextToken());
            String type = ln.nextToken();
            Vector<String> args = new Vector<String>();
            while (ln.hasMoreTokens()) {
                args.addElement(ln.nextToken());
            }
            String newtype = "Custom";
            boolean complement = false;
            boolean invert = false;
            if (type.equals("<")) {
                newtype = "LessThan";
            } else if (type.equals(">")) {
                newtype = "GreaterThan";
            } else if (type.equals("=")) {
                newtype = "Equals";
            } else if (type.equals("!=")) {
                newtype = "Equals";
                complement = true;
            } else if (type.equals("CROSSWORD")) {
                newtype = "Crossword";
            } else if (type.equals("QUEENS")) {
                newtype = "Queens";
            } else if (type.equals("XOR")) {
                newtype = "LessThan";
            } else if (type.equals("NAND")) {
                newtype = "And";
                complement = true;
            } else if (type.equals("NOR")) {
                newtype = "Or";
                complement = true;
            } else if (type.equals("<-")) {
                newtype = "Implies";
                invert = true;
            } else if (type.equals("->")) {
                newtype = "Implies";
            } else if (type.equals("TRUE")) {
                newtype = "Trivial";
            } else if (type.equals("<=")) {
                newtype = "GreaterThan";
                complement = true;
            } else if (type.equals(">=")) {
                newtype = "LessThan";
                complement = true;
            } else if (type.equals("AND")) {
                newtype = "And";
            } else if (type.equals("OR")) {
                newtype = "Or";
            } else if (type.equals("Custom")) {
                newtype = "Custom";
            }
            if (invert) {
                Integer temp = index0;
                index0 = index1;
                index1 = temp;
            }
            String arguments = "";
            String table = "";
            if (newtype.equals("Custom")) {
                table = String.valueOf(table) + "<TABLE>\n\t";
                Enumeration e = args.elements();
                int s0 = (Integer)ht2.get(index0);
                int s1 = (Integer)ht2.get(index1);
                int maxsize = s1 * s0;
                int[] trueEls = new int[args.size() / 2];
                int i = 0;
                while (e.hasMoreElements()) {
                    Integer a0 = new Integer((String)e.nextElement());
                    Integer a1 = new Integer((String)e.nextElement());
                    trueEls[i] = s1 * a1 + a0;
                    ++i;
                }
                String[] b = new String[maxsize];
                int j = 0;
                while (j < b.length) {
                    b[j] = "F";
                    ++j;
                }
                j = 0;
                while (j < trueEls.length) {
                    b[trueEls[j]] = "T";
                    ++j;
                }
                j = 0;
                while (j < b.length) {
                    table = String.valueOf(table) + b[j] + " ";
                    ++j;
                }
                table = String.valueOf(table) + "\n</TABLE>\n";
            } else {
                if (complement) {
                    arguments = String.valueOf(arguments) + "complement ";
                }
                Enumeration e = args.elements();
                while (e.hasMoreElements()) {
                    arguments = String.valueOf(arguments) + (String)e.nextElement() + " ";
                }
            }
            val = String.valueOf(val) + "<CONSTRAINT TYPE=" + newtype + ">\n";
            val = String.valueOf(val) + "<GIVEN>" + (String)ht.get(index0) + "</" + inptag + ">\n";
            val = String.valueOf(val) + "<GIVEN>" + (String)ht.get(index1) + "</" + inptag + ">\n";
            val = String.valueOf(val) + "\t<ARGS>" + arguments + "</" + argtag + ">\n";
            val = String.valueOf(val) + table;
            val = String.valueOf(val) + "</CONSTRAINT>\n";
        }
        return val;
    }
}

