/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSPWindow;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class ProblemDialog
extends Dialog
implements ActionListener,
WindowListener {
    private Button cancel_button;
    private Button load_button;
    private CSPWindow window;
    private Vector problemList;
    private Choice sampleChoice;

    public ProblemDialog(CSPWindow w) {
        super(w, "Load Sample Problems", true);
        this.window = w;
        Label label = new Label("Select an Example File:");
        Panel top = new Panel();
        top.add("Center", label);
        this.sampleChoice = new Choice();
        this.problemList = new Vector(5, 2);
        if (!this.getProblemList()) {
            return;
        }
        int i = 0;
        while (i < this.problemList.size()) {
            this.sampleChoice.add(((String[])this.problemList.elementAt(i))[0]);
            ++i;
        }
        this.sampleChoice.select(0);
        Panel middle = new Panel();
        middle.add("Center", this.sampleChoice);
        Panel bottom = new Panel();
        this.load_button = new Button("Load");
        this.load_button.addActionListener(this);
        this.cancel_button = new Button("Cancel");
        this.cancel_button.addActionListener(this);
        bottom.add(this.load_button);
        bottom.add(this.cancel_button);
        this.add("North", top);
        this.add("Center", middle);
        this.add("South", bottom);
        this.pack();
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public boolean getProblemList() {
        try {
            String text;
            BufferedReader in;
            if (this.window.applet != null) {
                URL url = new URL(this.window.applet.getCodeBase() + "SampleProblems.txt");
                InputStream iStream = url.openStream();
                in = new BufferedReader(new InputStreamReader(iStream));
            } else {
                File f = new File("SampleProblems.txt");
                in = new BufferedReader(new FileReader(f));
            }
            while ((text = in.readLine()) != null) {
                if (text.trim().length() <= 0) continue;
                int p1 = text.indexOf(",");
                String[] tempString = new String[]{new String(text.substring(0, p1)), new String(text.substring(p1 + 2, text.trim().length()))};
                this.problemList.addElement(tempString);
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.window.showMessage("Error", "Need SampleProblems.txt in the base directory." + e.getMessage());
            return false;
        }
    }

    public void loadProblem() {
        int index = this.sampleChoice.getSelectedIndex();
        if (index >= 0) {
            this.window.load(((String[])this.problemList.elementAt(index))[1]);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("Cancel")) {
            this.loadProblem();
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

