/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.Relation;
import CIspace.cspTools.relations.RelationChooser;
import CIspace.cspTools.relations.ReorderDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class RelationDialog
extends Dialog
implements WindowListener,
ActionListener {
    private Relation rel;
    private Relation original;
    private AffirmPanel relPanel;
    private RelationChooser relChooser;
    private Constraint cns;
    public boolean cancelled = false;
    private boolean editable;

    public RelationDialog(Frame parent, Relation relation, Constraint cns, boolean edit) {
        super(parent, "Constraint", true);
        this.addWindowListener(this);
        ((Component)this).setSize(200, 200);
        this.editable = edit;
        this.relChooser = new RelationChooser(relation, parent, cns, this.editable);
        this.relChooser.setCnsDialog(this);
        this.cns = cns;
        this.original = relation;
        this.rel = relation;
        if (this.rel == null) {
            this.rel = RelationChooser.newObject(0, parent, cns);
        }
        this.relPanel = this.rel.getEditPanel(edit);
        Panel west = new Panel(new BorderLayout());
        west.add((Component)this.relChooser, "Center");
        Button reorderButton = new Button("Reorder Variables");
        west.add((Component)reorderButton, "South");
        this.add((Component)this.relPanel, "Center");
        this.add((Component)west, "West");
        Panel p = new Panel();
        Button ok = new Button("OK");
        Button cancel = new Button("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        reorderButton.addActionListener(this);
        p.add(ok);
        p.add(cancel);
        this.add((Component)p, "South");
        this.pack();
        ((Component)this).setVisible(true);
    }

    public Relation getRelation() {
        return this.rel;
    }

    public void setRelation(Relation rel) {
        this.remove(this.relPanel);
        this.relPanel = rel.getEditPanel(this.editable);
        this.add((Component)this.relPanel, "East");
        this.rel = rel;
        this.validate();
    }

    public void reorder() {
        this.resetRelation();
    }

    public void resetRelation() {
        this.remove(this.relPanel);
        this.rel.reset();
        this.relPanel = this.rel.getEditPanel(this.editable);
        this.add((Component)this.relPanel, "East");
        this.validate();
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getSource().equals(this.relChooser)) {
            if (e.getActionCommand() == "OK") {
                this.relPanel.ok();
                this.cns.setRelation(this.rel);
                this.cancelled = false;
                ((Component)this).setVisible(false);
            } else if (e.getActionCommand() == "Cancel") {
                this.relPanel.cancel();
                this.cancelled = true;
                ((Component)this).setVisible(false);
            } else if (e.getActionCommand() == "Reorder Variables") {
                ReorderDialog rd = new ReorderDialog(this, this.cns);
                ((Component)rd).setVisible(true);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cancelled = true;
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

