/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSPWindow;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class TextFrame
extends Frame
implements ActionListener,
WindowListener {
    private Button cancelButton;
    private Button updateGraphButton;
    private TextArea display;
    private CSPWindow parent;

    public TextFrame(CSPWindow parent, String textRep, boolean editme) {
        super("Text Representation of the CSP");
        if (!editme) {
            this.setTitle("Current State of CSP");
        }
        this.addWindowListener(this);
        this.parent = parent;
        Panel p = new Panel();
        if (editme) {
            this.updateGraphButton = new Button("Update Graph");
            this.updateGraphButton.addActionListener(this);
            this.cancelButton = new Button("Cancel");
            this.cancelButton.addActionListener(this);
            p.add(this.cancelButton);
            p.add(this.updateGraphButton);
        } else {
            Button ok = new Button("OK");
            ok.addActionListener(this);
            p.add(ok);
        }
        this.display = new TextArea(40, 80);
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.display.setText(textRep);
        this.display.setEditable(editme);
        this.add("Center", this.display);
        this.add("South", p);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel") || e.getActionCommand().equals("OK")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Update Graph") && this.parent.updateCSPFromText(this.display.getText())) {
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

