/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.domains.DomainBoolean;
import CIspace.cspTools.domains.DomainChooser;
import CIspace.cspTools.domains.DomainDiscrete;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class VariableDialog
extends Dialog
implements WindowListener,
ActionListener {
    private CSPVariable var;
    private DomainDiscrete dom;
    private DomainDiscrete original;
    private AffirmPanel varPanel;
    private AffirmPanel domPanel;
    private DomainChooser domainChooser;
    public boolean cancelled = false;
    private boolean editable;

    public VariableDialog(Frame parent, CSPVariable var, CSP csp, boolean editable) {
        super(parent, "Edit Variable", true);
        this.addWindowListener(this);
        ((Component)this).setSize(200, 200);
        boolean edit = var.getEdit() && editable;
        this.editable = editable;
        if (var == null) {
            return;
        }
        this.var = var;
        this.dom = this.original = var.getDomain();
        this.varPanel = var.getPanel(csp, editable);
        this.add((Component)this.varPanel, "West");
        if (this.dom == null) {
            this.dom = new DomainBoolean();
        }
        this.domPanel = this.dom.getEditPanel(edit);
        this.add((Component)this.domPanel, "East");
        this.domainChooser = new DomainChooser(this.dom, edit);
        this.domainChooser.setVarDialog(this);
        this.add((Component)this.domainChooser, "Center");
        Panel p = new Panel();
        Button ok = new Button("OK");
        Button cancel = new Button("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        p.add(ok);
        p.add(cancel);
        this.add((Component)p, "South");
        this.pack();
        this.show();
    }

    public void setDomain(DomainDiscrete domain) {
        this.remove(this.domPanel);
        this.dom = domain;
        this.domPanel = this.dom.getEditPanel(this.editable);
        this.add((Component)this.domPanel, "East");
        this.validate();
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getSource().equals(this.domainChooser)) {
            if (e.getActionCommand() == "OK") {
                this.varPanel.ok();
                this.domPanel.ok();
                this.var.setDomain(this.dom);
                this.var.setLabel();
                this.cancelled = false;
                ((Component)this).setVisible(false);
            } else if (e.getActionCommand() == "Cancel") {
                this.varPanel.cancel();
                this.domPanel.cancel();
                this.var.setDomain(this.original);
                this.cancelled = true;
                ((Component)this).setVisible(false);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

