/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.domains;

import CIspace.cspTools.VariableDialog;
import CIspace.cspTools.domains.DomainDiscrete;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class DomainChooser
extends Panel
implements ItemListener {
    private static final String[] DOMAIN_NAMES = new String[]{"DomainInteger", "DomainString", "DomainBoolean"};
    private static final String DOMAIN_PATH = "CIspace.cspTools.domains.";
    private static Class[] DOMAIN_CLASSES;
    private Choice domainChooser;
    private DomainDiscrete current;
    private VariableDialog varDialog;

    public DomainChooser(DomainDiscrete current, boolean edit) {
        this.setLayout(new GridLayout(4, 1));
        this.add(new Label("Choose Domain Type..."));
        this.current = current;
        this.domainChooser = new Choice();
        this.domainChooser.addItemListener(this);
        DomainChooser.loadClasses();
        int i = 0;
        while (i < DOMAIN_CLASSES.length) {
            DomainDiscrete cur = DomainChooser.newObject(i);
            String s = cur == null ? "" : cur.getTypeString();
            this.domainChooser.add(s);
            if (DOMAIN_CLASSES[i].isInstance(current)) {
                this.domainChooser.select(i);
            }
            ++i;
        }
        this.add(this.domainChooser);
        this.domainChooser.setEnabled(edit);
    }

    public static final void loadClasses() {
        if (DOMAIN_CLASSES != null) {
            return;
        }
        DOMAIN_CLASSES = new Class[DOMAIN_NAMES.length];
        int i = 0;
        while (i < DOMAIN_CLASSES.length) {
            try {
                DomainChooser.DOMAIN_CLASSES[i] = Class.forName(DOMAIN_PATH + DOMAIN_NAMES[i]);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class Not Found: " + DOMAIN_NAMES[i] + " exiting");
                System.exit(0);
            }
            ++i;
        }
    }

    public static final DomainDiscrete newObject(int i) {
        if (DOMAIN_CLASSES == null) {
            DomainChooser.loadClasses();
        }
        if (i >= DOMAIN_CLASSES.length) {
            return null;
        }
        try {
            Object o = DOMAIN_CLASSES[i].newInstance();
            if (o instanceof DomainDiscrete) {
                return (DomainDiscrete)o;
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error requested class could not be created due to instantiation or access error");
            return null;
        }
    }

    public static final DomainDiscrete newObject(String s) {
        if (DOMAIN_CLASSES == null) {
            DomainChooser.loadClasses();
        }
        int i = 0;
        while (i < DOMAIN_CLASSES.length) {
            try {
                Object o = DOMAIN_CLASSES[i].newInstance();
                if (o instanceof DomainDiscrete && ((DomainDiscrete)o).getTypeString().toUpperCase().equals(s.toUpperCase())) {
                    return (DomainDiscrete)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public void setVarDialog(VariableDialog varDialog) {
        this.varDialog = varDialog;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.domainChooser)) {
            Class newDomainType = DOMAIN_CLASSES[this.domainChooser.getSelectedIndex()];
            if (newDomainType.isInstance(this.current)) {
                return;
            }
            this.current = DomainChooser.newObject(this.domainChooser.getSelectedIndex());
            if (this.varDialog != null) {
                this.varDialog.setDomain(this.current);
            }
        }
    }
}

