/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.domains;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.Domain;
import CIspace.cspTools.ve.Variable;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DomainDiscrete
extends Variable
implements Domain {
    protected int[] splitElements = new int[0];
    protected DomainPanel panel;

    public DomainDiscrete() {
        super("Discrete", new String[0]);
    }

    public String[] getElements() {
        return this.domain;
    }

    public boolean contains(String l) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(l)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getElementString(int i) {
        return this.domain[i];
    }

    public int getSize() {
        return this.domain.length;
    }

    public final int[] getSplitElements() {
        return this.splitElements;
    }

    public final boolean setSplitElements(int[] elements) {
        this.splitElements = elements;
        return true;
    }

    public boolean removeElement(String s) {
        int i = this.index(s);
        if (i > -1) {
            return this.removeElement(i);
        }
        return false;
    }

    public boolean removeElement(int i) {
        if (i < 0 || i >= this.domain.length) {
            return false;
        }
        String[] dom = new String[this.domain.length - 1];
        int j = 0;
        while (j < this.domain.length) {
            if (j != i) {
                if (j < i) {
                    dom[j] = this.domain[j];
                } else {
                    dom[j - 1] = this.domain[j];
                }
            }
            ++j;
        }
        this.domain = dom;
        return true;
    }

    protected boolean addElementAtEnd(String s) {
        String[] dom = new String[this.domain.length + 1];
        int i = 0;
        while (i < this.domain.length) {
            dom[i] = this.domain[i];
            ++i;
        }
        dom[dom.length - 1] = s;
        this.domain = dom;
        return true;
    }

    public int index(String s) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final AffirmPanel getEditPanel(boolean edit) {
        return new DomainPanel(this, edit);
    }

    public String getRep() {
        String rep = "";
        if (this.domain == null || this.domain.length == 0) {
            return "";
        }
        int i = 0;
        while (i < this.domain.length - 1) {
            rep = String.valueOf(rep) + this.domain[i] + " ";
            ++i;
        }
        rep = String.valueOf(rep) + this.domain[this.domain.length - 1];
        return rep;
    }

    public String getSplitRep() {
        String rep = "";
        if (this.splitElements == null || this.splitElements.length == 0) {
            return "";
        }
        int i = 0;
        while (i < this.splitElements.length - 1) {
            rep = String.valueOf(rep) + this.domain[this.splitElements[i]] + " ";
            ++i;
        }
        rep = String.valueOf(rep) + this.domain[this.splitElements[this.splitElements.length - 1]];
        return rep;
    }

    public final void resetSplit() {
        this.splitElements = new int[this.domain.length];
        int i = 0;
        while (i < this.splitElements.length) {
            this.splitElements[i] = i;
            ++i;
        }
    }

    public final void hide(int j) {
        int[] newSplit = new int[this.splitElements.length - 1];
        int i = 0;
        while (i < this.splitElements.length) {
            if (j > i) {
                newSplit[i] = this.splitElements[i];
            } else if (j < i) {
                newSplit[i - 1] = this.splitElements[i];
            }
            ++i;
        }
        this.splitElements = newSplit;
    }

    public boolean setRand(int j) {
        if (j < 0) {
            j = (int)Math.floor(Math.random() * (double)this.domain.length);
        }
        this.splitElements = new int[j];
        int i = 0;
        Vector<Integer> elements = new Vector<Integer>();
        while (i < j) {
            Integer element = new Integer((int)Math.floor(Math.random() * (double)this.domain.length));
            if (elements.contains(element)) continue;
            elements.addElement(element);
            this.splitElements[i] = element;
            ++i;
        }
        return true;
    }

    public boolean set(Object vals) {
        if (!(vals instanceof int[])) {
            return false;
        }
        int[] els = (int[])vals;
        this.setSplitElements(els);
        return true;
    }

    public void clear() {
        this.domain = new String[0];
        this.splitElements = new int[0];
    }

    public abstract boolean addElement(String var1);

    public abstract Object getObject(int var1);

    public abstract String getTypeString();

    class DomainPanel
    extends AffirmPanel
    implements ActionListener {
        private DomainDiscrete domain;
        private TextField value;
        private Label title;
        private Button addButton;
        private Button removeButton;
        private TextArea domainValues;
        private Vector addedValues;
        protected String name = "discrete";

        DomainPanel(DomainDiscrete domain, boolean edit) {
            this.domain = domain;
            this.setLayout(new GridLayout(4, 1));
            this.addButton = new Button("Add");
            this.addButton.addActionListener(this);
            this.removeButton = new Button("Remove");
            this.removeButton.addActionListener(this);
            Panel buttons = new Panel(new GridLayout(1, 2));
            buttons.add(this.addButton);
            buttons.add(this.removeButton);
            this.value = new TextField("", 10);
            this.value.addActionListener(this);
            this.title = new Label("Edit Values...");
            this.domainValues = new TextArea("{ " + domain.getRep() + "}", 1, 15, 2);
            this.domainValues.setEditable(false);
            this.add(this.title);
            this.add(this.value);
            this.add(buttons);
            this.add(this.domainValues);
            this.addedValues = new Vector();
            this.value.setEnabled(edit);
            this.addButton.setEnabled(edit);
            this.removeButton.setEnabled(edit);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Add" || e.getSource().equals(this.value)) {
                if (this.domain.addElement(this.value.getText())) {
                    this.domainValues.setText("{ " + this.domain.getRep() + "}");
                    this.addedValues.addElement(this.value.getText());
                    this.value.setText("");
                }
            } else if (e.getActionCommand() == "Remove" && this.domain.removeElement(this.value.getText())) {
                this.domainValues.setText("{ " + this.domain.getRep() + "}");
                this.addedValues.removeElement(this.value.getText());
                this.value.setText("");
            }
        }

        public void ok() {
        }

        public void cancel() {
            Enumeration v = this.addedValues.elements();
            while (v.hasMoreElements()) {
                this.domain.removeElement((String)v.nextElement());
            }
        }
    }
}

