/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.relations;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.ve.EltsIterator;
import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorUpdatable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class FactorPanel
extends AffirmPanel
implements ActionListener {
    private FactorUpdatable factor;
    private Vector probButtons;
    private Button reorderButton;
    protected String observationString;
    protected Vector context;
    private Vector dFrames;
    private Label headerLabels;
    private int fontSize;
    private Frame parent;
    private boolean editable;
    Vector variables;

    public FactorPanel(Frame parent, FactorUpdatable f, int fSize, Vector variables, boolean editable) {
        this.factor = f;
        this.parent = parent;
        this.fontSize = fSize > 20 ? 20 : fSize;
        this.setLayout(new BorderLayout());
        this.editable = editable;
        this.variables = variables;
        if (this.factor.size() < 101) {
            this.setPanels(f);
        } else {
            TextArea ta = new TextArea("Custom Constraint is too large to display (size>100)\n Please choose another Constraint type or edit this Constraint using text representation\nCustom Constraint defaults to False");
            ta.setEditable(false);
            this.add((Component)ta, "Center");
        }
        this.dFrames = new Vector();
    }

    private void setPanels(Factor f) {
        Panel chart = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        GridBagLayout g = new GridBagLayout();
        chart.setLayout(g);
        this.probButtons = new Vector(this.factor.size());
        this.context = new Vector();
        String headers = "";
        String[] heads = new String[this.variables.size()];
        int[] headerSizes = new int[this.variables.size()];
        int i = 0;
        while (i < this.variables.size()) {
            CSPVariable v = (CSPVariable)this.variables.elementAt(i);
            headers = String.valueOf(headers) + "         " + v.getName();
            headerSizes[i] = v.getName().length();
            ++i;
        }
        this.headerLabels = new Label(headers);
        this.headerLabels.setFont(new Font("Courier", 0, this.fontSize));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 3.0;
        g.setConstraints(this.headerLabels, c);
        chart.add(this.headerLabels);
        Label tempLabel = new Label("Value");
        tempLabel.setFont(new Font("Courier", 0, this.fontSize));
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        g.setConstraints(tempLabel, c);
        chart.add(tempLabel);
        int[] index = new int[this.factor.getVariables().length];
        EltsIterator iter = this.factor.iterator();
        Vector<String> v = new Vector<String>(this.factor.getVariables().length);
        int counter = 0;
        while (iter.hasNext()) {
            String truefalseLabels = "";
            ++counter;
            int i2 = 0;
            while (i2 < this.factor.getVariables().length) {
                String temp = this.factor.getVariables()[i2].getDomain()[index[i2]];
                if (!temp.equals("Val")) {
                    int j = 0;
                    while (j < headerSizes[i2] - headerSizes[i2] / 2) {
                        truefalseLabels = String.valueOf(truefalseLabels) + " ";
                        ++j;
                    }
                    truefalseLabels = String.valueOf(truefalseLabels) + "        " + temp;
                    j = 0;
                    while (j < headerSizes[i2] / 2) {
                        truefalseLabels = String.valueOf(truefalseLabels) + " ";
                        ++j;
                    }
                    v.addElement(temp);
                }
                ++i2;
            }
            Label l = new Label(truefalseLabels);
            l.setFont(new Font("Courier", 0, this.fontSize));
            c.gridx = 0;
            c.gridy = counter;
            c.weightx = 3.0;
            c.fill = 0;
            g.setConstraints(l, c);
            chart.add(l);
            Double prob = new Double(iter.next());
            Double roundProb = new Double((double)Math.round(prob * 10000.0) / 10000.0);
            String probval = prob == 0.0 ? "false" : "true";
            Button probButton = new Button(probval);
            probButton.addActionListener(this);
            this.probButtons.addElement(probButton);
            probButton.setFont(new Font("SansSerif", 0, this.fontSize));
            c.gridx = 1;
            c.gridy = counter;
            c.weightx = 1.0;
            c.fill = 2;
            g.setConstraints(probButton, c);
            chart.add(probButton);
            boolean allMax = true;
            this.context.addElement(v);
            v = new Vector(this.factor.getVariables().length);
            int i3 = this.factor.getVariables().length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.factor.getVariables()[i3].getDomain().length - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < this.factor.getVariables().length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        Panel title = new Panel();
        title.setLayout(new GridLayout(1, 3));
        Label instructionLabel = this.editable ? new Label("Click on buttons to toggle truth value.") : new Label("Truth values...");
        instructionLabel.setForeground(Color.red);
        Panel titlePanel = new Panel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)title, "North");
        titlePanel.add((Component)instructionLabel, "South");
        Panel derivationPanel = new Panel();
        Label howDerived = this.editable ? new Label("Customise factor") : new Label("");
        howDerived.setAlignment(1);
        derivationPanel.add((Component)howDerived, "North");
        ScrollPane gridPane = new ScrollPane();
        gridPane.add(chart);
        this.add((Component)titlePanel, "North");
        this.add((Component)gridPane, "Center");
        this.add((Component)derivationPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.editable) {
            if (e.getSource() == this.reorderButton) {
                Object newHeaders = null;
                Object var3_4 = null;
            }
            int i = 0;
            while (i < this.probButtons.size()) {
                if (e.getSource() == (Button)this.probButtons.elementAt(i) && this.editable) {
                    Button b = (Button)this.probButtons.elementAt(i);
                    String s = b.getLabel();
                    if (s == "true") {
                        b.setLabel("false");
                    } else {
                        b.setLabel("true");
                    }
                }
                ++i;
            }
        }
    }

    public void openDerivationFrame(int index) {
        System.out.println("DERIVATION FRAME");
    }

    public double getValueFor(Vector vec, Factor f) {
        EltsIterator iter = f.iterator();
        int[] index = new int[f.getVariables().length];
        while (iter.hasNext()) {
            Vector<String> tempVec = new Vector<String>(vec.size());
            int i = 0;
            while (i < f.getVariables().length) {
                tempVec.addElement(f.getVariables()[i].getDomain()[index[i]]);
                ++i;
            }
            boolean isSame = true;
            int i2 = 0;
            while (i2 < tempVec.size() && i2 < vec.size()) {
                if (!((String)tempVec.elementAt(i2)).equals((String)vec.elementAt(i2))) {
                    isSame = false;
                }
                ++i2;
            }
            if (isSame) {
                return iter.next();
            }
            double d = iter.next();
            if (!iter.hasNext()) continue;
            boolean allMax = true;
            int i3 = f.getVariables().length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < f.getVariables()[i3].getDomain().length - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < f.getVariables().length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        return 0.0;
    }

    public void rearrangeValues(EltsIterator iter, String[] headerArray) {
        String headers = "";
        int[] headerSizes = new int[headerArray.length];
        int i = 0;
        while (i < headerArray.length) {
            headers = String.valueOf(headers) + "         " + headerArray[i];
            headerSizes[i] = headerArray[i].length();
            ++i;
        }
        this.headerLabels.setText(headers);
        int counter = 0;
        int[] index = new int[headerArray.length];
        while (iter.hasNext()) {
            Double prob = new Double(iter.next());
            Double roundProb = new Double((double)Math.round(prob * 10000.0) / 10000.0);
            ((Button)this.probButtons.elementAt(counter)).setLabel(roundProb.toString());
            ++counter;
        }
    }

    public void ok() {
        if (this.editable) {
            int i = 0;
            while (i < this.factor.size()) {
                if (((Button)this.probButtons.elementAt(i)).getLabel() == "true") {
                    this.factor.update(i, 1.0);
                } else {
                    this.factor.update(i, 0.0);
                }
                ++i;
            }
        }
    }

    public void cancel() {
    }
}

