/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.relations;

import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.Domain;
import CIspace.cspTools.Relation;
import CIspace.cspTools.RelationDialog;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class RelationChooser
extends Panel
implements ItemListener {
    private static final String[] RELATION_NAMES = new String[]{"RelationFactor", "RelationAnd", "RelationOr", "RelationImply", "RelationXOr", "RelationEquals", "RelationLessThan", "RelationGreaterThan", "RelationFalse", "RelationTrivial", "RelationCrossword", "RelationQueens"};
    private static final String RELATION_PATH = "CIspace.cspTools.relations.";
    private static Class[] RELATION_CLASSES;
    private Vector currentClasses;
    private Choice relationChooser;
    private Relation current;
    private RelationDialog cnsDialog;
    private Frame parent;
    private Constraint cns;
    private Domain[] domains;
    private Label constraintType;
    private int currentIndex;
    private int[] indices;

    public RelationChooser(Relation current, Frame parent, Constraint cns, boolean editable) {
        this.setLayout(new GridLayout(4, 1));
        if (editable) {
            this.add(new Label("Choose Constraint Type..."));
        } else {
            this.add(new Label("Constraint type"));
        }
        this.current = current;
        this.parent = parent;
        this.currentClasses = new Vector();
        this.relationChooser = new Choice();
        this.relationChooser.setEnabled(editable);
        this.relationChooser.addItemListener(this);
        RelationChooser.loadClasses();
        this.domains = null;
        this.cns = cns;
        Vector vars = cns.getVariables();
        if (vars != null && vars.size() > 0) {
            this.domains = new Domain[vars.size()];
            int i = 0;
            while (i < vars.size()) {
                this.domains[i] = ((CSPVariable)vars.elementAt(i)).getDomain();
                ++i;
            }
        }
        this.constraintType = new Label("");
        Vector<Integer> indices = new Vector<Integer>();
        int i = 0;
        while (i < RELATION_CLASSES.length) {
            Relation cur = RelationChooser.newObject(i, parent);
            if (cur == null) {
                return;
            }
            String s = cur.getTypeString();
            if (this.domains == null) {
                this.currentClasses.addElement(RELATION_CLASSES[i]);
                this.relationChooser.add(s);
            } else if (cur.testDomains(this.domains)) {
                indices.add(new Integer(i));
                this.currentClasses.addElement(RELATION_CLASSES[i]);
                this.relationChooser.add(s);
                this.constraintType.setText(cur.getTypeString());
            }
            if (RELATION_CLASSES[i].isInstance(current)) {
                this.relationChooser.select(this.relationChooser.getItemCount() - 1);
                this.currentIndex = this.relationChooser.getSelectedIndex();
            }
            ++i;
        }
        if (editable) {
            this.add(this.relationChooser);
        } else {
            this.add(this.constraintType);
        }
        this.indices = new int[indices.size()];
        i = 0;
        while (i < this.indices.length) {
            this.indices[i] = (Integer)indices.elementAt(i);
            ++i;
        }
    }

    public static final void loadClasses() {
        if (RELATION_CLASSES != null) {
            return;
        }
        RELATION_CLASSES = new Class[RELATION_NAMES.length];
        int i = 0;
        while (i < RELATION_CLASSES.length) {
            try {
                RelationChooser.RELATION_CLASSES[i] = Class.forName(RELATION_PATH + RELATION_NAMES[i]);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class Not Found: " + RELATION_NAMES[i] + " exiting");
                System.exit(0);
            }
            ++i;
        }
    }

    private static final Relation newObject(int i, Frame parent) {
        Relation r;
        if (RELATION_CLASSES == null) {
            RelationChooser.loadClasses();
        }
        if (i >= RELATION_CLASSES.length) {
            return null;
        }
        try {
            Object o = RELATION_CLASSES[i].newInstance();
            if (!(o instanceof Relation)) {
                return null;
            }
            r = (Relation)o;
        }
        catch (Exception e) {
            System.err.println("Error requested class could not be created due to instantiation or access error");
            return null;
        }
        return r;
    }

    private static final Relation newObject(int i, Frame parent, Constraint cns, int[] indices) {
        Relation r = RelationChooser.newObject(indices[i], parent);
        r.init(cns);
        return r;
    }

    public static final Relation newObject(String s, Constraint cns) {
        if (RELATION_CLASSES == null) {
            RelationChooser.loadClasses();
        }
        int i = 0;
        while (i < RELATION_CLASSES.length) {
            try {
                Object o = RELATION_CLASSES[i].newInstance();
                if (o instanceof Relation && ((Relation)o).getTypeString().toUpperCase().equals(s.toUpperCase())) {
                    Relation r = (Relation)o;
                    r.init(cns);
                    return r;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public static final Relation newObject(int i, Frame parent, Constraint cns) {
        return RelationChooser.newObject(0, parent, cns, new int[]{i});
    }

    public void setCnsDialog(RelationDialog cnsDialog) {
        this.cnsDialog = cnsDialog;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.relationChooser)) {
            if (this.relationChooser.getSelectedIndex() == this.currentIndex) {
                return;
            }
            Class newRELATIONType = (Class)this.currentClasses.elementAt(this.relationChooser.getSelectedIndex());
            this.current = RelationChooser.newObject(this.relationChooser.getSelectedIndex(), this.parent, this.cns, this.indices);
            this.currentIndex = this.relationChooser.getSelectedIndex();
            if (this.cnsDialog != null) {
                this.cnsDialog.setRelation(this.current);
            }
        }
    }

    private static Domain[] getDomains(CSPVariable[] vars) {
        Domain[] doms = new Domain[vars.length];
        int i = 0;
        while (i < vars.length) {
            doms[i] = vars[i].getDomain();
            ++i;
        }
        return doms;
    }
}

