/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.relations;

import CIspace.cspTools.AffirmPanel;
import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.Counter;
import CIspace.cspTools.Domain;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.cspTools.relations.RelationFactor;
import CIspace.cspTools.relations.RelationPanel;
import CIspace.cspTools.ve.FactorUpdatable;
import CIspace.cspTools.ve.Variable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class RelationRegular
extends RelationFactor {
    protected boolean complement = false;

    public void setComplement(boolean cmp) {
        this.complement = cmp;
    }

    protected abstract boolean testFunction(int[] var1, DomainDiscrete[] var2);

    private boolean testF(int[] args, DomainDiscrete[] domains) {
        if (this.complement) {
            return !this.testFunction(args, domains);
        }
        return this.testFunction(args, domains);
    }

    public void reset() {
        Variable[] variables = this.getDomains(this.cns.getVariables());
        this.factor = new FactorUpdatable(variables, 0.0);
        this.setOffsets((DomainDiscrete[])variables);
        int[] sizes = new int[variables.length];
        int i = 0;
        while (i < sizes.length) {
            sizes[i] = ((DomainDiscrete)variables[i]).getSize();
            ++i;
        }
        Counter c = new Counter(sizes);
        while (c.hasMoreElements()) {
            if (this.testF(c.next(), (DomainDiscrete[])variables)) {
                this.factor.update(c.getCurrentIndex(), 1.0);
                continue;
            }
            this.factor.update(c.getCurrentIndex(), 0.0);
        }
    }

    public void init(Constraint cns) {
        this.cns = cns;
        this.reset();
    }

    public abstract boolean testDomains(Domain[] var1);

    public abstract boolean testVar(CSPVariable var1);

    public boolean openRD() {
        return false;
    }

    public boolean addDomain(Domain domain) {
        this.reset();
        return true;
    }

    public boolean removeDomain(Domain domain) {
        int n = this.offsets.length;
        this.reset();
        return n != this.offsets.length;
    }

    public AffirmPanel getEditPanel(boolean edit) {
        RelationPanel panel = new RelationPanel(this, this.complement, this.cns.getVariables(), edit);
        return panel;
    }

    public abstract String getTypeString();

    public abstract String getType();

    public String getLabel() {
        if (!this.complement) {
            return this.getDescription(this.cns.getVariables());
        }
        return "not(" + this.getDescription(this.cns.getVariables()) + ")";
    }

    public String additionalXML(String indent) {
        String rep = "";
        String arg = "";
        if (this.complement) {
            arg = "complement";
        }
        rep = String.valueOf(rep) + indent + "<" + "ARGS" + ">" + arg + "</" + "ARGS" + ">\n";
        return rep;
    }

    public boolean setArgs(Enumeration arg) {
        String s;
        if (!arg.hasMoreElements()) {
            return true;
        }
        Object a = arg.nextElement();
        if (a instanceof String && (s = (String)a).toUpperCase().equals("COMPLEMENT")) {
            this.complement = true;
        }
        return true;
    }

    public abstract String getDescription(Vector var1);
}

