/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.relations;

import CIspace.cspTools.CSPVariable;
import CIspace.cspTools.Constraint;
import CIspace.cspTools.RelationDialog;
import CIspace.graphToolKit.Point;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ReorderDialog
extends Dialog
implements WindowListener,
ActionListener {
    private Button upButton;
    private Button downButton;
    private Button okButton;
    private List factorList;
    private RelationDialog rDialog;
    private String[] newStringOrder;
    private int frameType;
    private Vector variables;
    private Constraint cns;
    private RelationDialog rpanel;

    public ReorderDialog(RelationDialog parent, Constraint cns) {
        super(parent, "Reordering Factors", true);
        this.rDialog = parent;
        Panel buttonPanel = new Panel(new BorderLayout());
        this.upButton = new Button("Shift Variable Up");
        this.upButton.addActionListener(this);
        this.downButton = new Button("Shift Variable Down");
        this.downButton.addActionListener(this);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        Button cancelButton = new Button("Cancel");
        cancelButton.addActionListener(this);
        this.cns = cns;
        buttonPanel.add("North", this.upButton);
        buttonPanel.add("South", this.downButton);
        Panel okButtonPanel = new Panel();
        okButtonPanel.add(this.okButton);
        okButtonPanel.add(cancelButton);
        this.factorList = new List();
        this.factorList.setMultipleMode(false);
        this.variables = cns == null ? new Vector() : cns.getVariables();
        int i = 0;
        while (i < this.variables.size()) {
            CSPVariable v = (CSPVariable)this.variables.elementAt(i);
            this.factorList.add(v.getName());
            ++i;
        }
        this.add("East", buttonPanel);
        this.add("Center", this.factorList);
        this.add("South", okButtonPanel);
        this.add("North", new Label("Reordering will reset relation"));
        this.pack();
        this.centerWindow();
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        ((Component)this).setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Shift Variable Up")) {
            this.moveListSelectUp();
        } else if (e.getActionCommand().equals("Shift Variable Down")) {
            this.moveListSelectDown();
        } else if (e.getActionCommand().equals("OK")) {
            if (this.cns != null) {
                this.cns.setVariables(this.variables);
            }
            this.rDialog.reorder();
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals("Cancel")) {
            ((Component)this).setVisible(false);
        }
    }

    public void moveListSelectUp() {
        int index = this.factorList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        String oldItem = this.factorList.getItem(index - 1);
        this.factorList.replaceItem(this.factorList.getSelectedItem(), index - 1);
        this.factorList.replaceItem(oldItem, index);
        this.factorList.select(index - 1);
        CSPVariable v = (CSPVariable)this.variables.elementAt(index);
        this.variables.removeElementAt(index);
        this.variables.insertElementAt(v, index - 1);
    }

    public void moveListSelectDown() {
        int index = this.factorList.getSelectedIndex();
        if (index == this.factorList.getItemCount() - 1 || index < 0) {
            return;
        }
        String oldItem = this.factorList.getItem(index + 1);
        this.factorList.replaceItem(this.factorList.getSelectedItem(), index + 1);
        this.factorList.replaceItem(oldItem, index);
        this.factorList.select(index + 1);
        CSPVariable v = (CSPVariable)this.variables.elementAt(index);
        this.variables.removeElementAt(index);
        this.variables.insertElementAt(v, index + 1);
    }

    public void reorderVariables() {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

