/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.DecisionNetwork;
import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorCPT;
import CIspace.cspTools.ve.FactorObserved;
import CIspace.cspTools.ve.FactorReorder;
import CIspace.cspTools.ve.Variable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BeliefNetwork {
    private Variable[] variables;
    protected Factor[] probFactors;
    protected int numVariables;
    private final int maxDomainSize = 100;
    private final int maxFactorSize = 20;
    private Hashtable stringToVar;

    public Variable[] getVariables() {
        return this.variables;
    }

    public Factor[] getProbFactors() {
        return this.probFactors;
    }

    public int getNumVariables() {
        return this.numVariables;
    }

    public Hashtable getStringToVar() {
        return this.stringToVar;
    }

    public BeliefNetwork(String s, int maxVariables) {
        this.maxDomainSize = 100;
        this.maxFactorSize = 20;
        this.stringToVar = new Hashtable();
        this.probFactors = new Factor[maxVariables];
        this.variables = new Variable[maxVariables];
        StringTokenizer graphTokenizer = new StringTokenizer(s, ";");
        while (graphTokenizer.hasMoreTokens()) {
            String inString = graphTokenizer.nextToken();
            if ((inString = inString.trim()).indexOf("endBayesGraph") != -1) continue;
            String dataString = inString.substring(5, inString.length());
            StringTokenizer nodeTokenizer = new StringTokenizer(dataString, "/");
            String nodeName = nodeTokenizer.nextToken();
            String xpos = nodeTokenizer.nextToken();
            String ypos = nodeTokenizer.nextToken();
            String domainString = nodeTokenizer.nextToken();
            this.variables[this.numVariables] = new Variable(nodeName, BeliefNetwork.stringToStringArray(domainString, 100));
            this.stringToVar.put(nodeName, this.variables[this.numVariables]);
            String parentsString = nodeTokenizer.nextToken();
            String probsString = nodeTokenizer.nextToken();
            this.probFactors[this.numVariables] = BeliefNetwork.removeRedundant(new FactorCPT(this.stringToParents(parentsString, this.numVariables, 20), probsString), this.variables[this.numVariables]);
            if (!BeliefNetwork.sorted(this.probFactors[this.numVariables].getVariables())) {
                Variable[] vars = new Variable[this.probFactors[this.numVariables].getVariables().length];
                int i = 0;
                while (i < this.probFactors[this.numVariables].getVariables().length) {
                    vars[i] = this.probFactors[this.numVariables].getVariables()[i];
                    ++i;
                }
                DecisionNetwork.mySort(vars);
                this.probFactors[this.numVariables] = new FactorReorder(this.probFactors[this.numVariables], vars);
                this.probFactors[this.numVariables].setHow(0);
            }
            ++this.numVariables;
        }
    }

    public BeliefNetwork(Vector curVariables, int maxVariables) {
        try {
            throw (Error)Class.forName("java.lang.Error").getConstructor(Class.forName("java.lang.String")).newInstance("Unresolved compilation problems: \n\tThe method parentsToVarArray() is undefined for the type CIspace.cspTools.CSPVariable\n\tThe method probsToDoubleArray() is undefined for the type CIspace.cspTools.CSPVariable\n");
        }
        catch (Exception exception) {
            throw null;
        }
    }

    private static boolean sorted(Variable[] varray) {
        int i = 1;
        while (i < varray.length) {
            if (varray[i - 1].getId() >= varray[i].getId()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String[] stringToStringArray(String str, int maxSize) {
        String[] tempResult = new String[maxSize];
        int lpar = str.indexOf(91);
        int rpar = str.indexOf(93);
        StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar + 1, rpar), ",");
        int size = 0;
        while (tokenizer.hasMoreTokens()) {
            tempResult[size++] = tokenizer.nextToken().trim();
        }
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = tempResult[i];
            ++i;
        }
        return result;
    }

    private Variable[] stringToParents(String str, int index, int maxSize) {
        Variable[] tempResult = new Variable[maxSize];
        int lpar = str.indexOf(91);
        int rpar = str.indexOf(93);
        StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar + 1, rpar), ",");
        int size = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken().trim();
            try {
                tempResult[size] = this.variables[Integer.parseInt(nextToken)];
            }
            catch (Exception e) {
                Variable par = (Variable)this.stringToVar.get(nextToken);
                if (par == null) {
                    System.out.println("Parent of node " + this.variables[index].getName() + " is undefined.");
                }
                tempResult[size] = par;
            }
            ++size;
        }
        Variable[] result = new Variable[size + 1];
        int i = 0;
        while (i < size) {
            result[i] = tempResult[i];
            ++i;
        }
        result[size] = this.variables[index];
        return result;
    }

    static Factor removeRedundant(Factor fac, Variable var) {
        int numVars = fac.getVariables().length;
        Variable[] redundantVars = new Variable[fac.getVariables().length];
        int numRedundantVars = 0;
        int i = 0;
        while (i < numVars) {
            if (fac.getVariables()[i] != var && fac.isRedundant(fac.getVariables()[i])) {
                redundantVars[numRedundantVars++] = fac.getVariables()[i];
            }
            ++i;
        }
        if (numRedundantVars == 0) {
            return fac;
        }
        Variable[] newVars = new Variable[numRedundantVars];
        int[] vals = new int[numRedundantVars];
        int i2 = 0;
        while (i2 < numRedundantVars) {
            newVars[i2] = redundantVars[i2];
            ++i2;
        }
        return new FactorObserved(fac, newVars, vals);
    }

    BeliefNetwork(Variable[] vars, int numVars) {
        this.maxDomainSize = 100;
        this.maxFactorSize = 20;
        this.stringToVar = new Hashtable();
        this.variables = vars;
        this.numVariables = numVars;
    }

    public void print() {
        int i = 0;
        while (i < this.getNumVariables()) {
            System.out.println("\n Factor #" + i + ":");
            this.getProbFactors()[i].print();
            ++i;
        }
    }
}

