/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.EltsIterator;
import CIspace.cspTools.ve.Variable;
import java.util.Vector;

public abstract class Factor {
    public static final int BY_CPT = 0;
    public static final int BY_V_ELIM = 1;
    public static final int BY_OBSERVED = 2;
    public static final int BY_SUM_OUT = 3;
    public static final int BY_MULTIPLYING = 4;
    public static final int BY_ASSIGN = 5;
    public static final int BY_EXPANDING = 6;
    public static final int BY_MAXIMIZING = 7;
    public static final int BY_NORMALIZING = 8;
    public static final int BY_PLUS = 9;
    public static final int BY_REORDERING = 10;
    public static final int BY_SAVEIT = 11;
    public static final int BY_UPDATABLE = 12;
    public static final int BY_UNIFORM = 13;
    public static final int BY_GENRULE = 14;
    public static final int BY_DETERMINISTIC = 15;
    public Vector createdFromVars;
    public Vector createdFrom;
    public int facNum;
    private int howCreatedVal;
    private static boolean savingForTracing = true;
    private Variable[] variables;
    private int thesize;

    public int howCreated() {
        return this.howCreatedVal;
    }

    public void setHow(int how) {
        this.howCreatedVal = how;
    }

    public boolean getSavingForTracing() {
        return savingForTracing;
    }

    public void setSavingForTracing(boolean val) {
        savingForTracing = val;
    }

    public Factor(Variable[] vars, int how) {
        this.variables = vars;
        this.thesize = 1;
        int i = 0;
        while (i < this.variables.length) {
            this.thesize *= this.variables[i].getDomain().length;
            ++i;
        }
        this.howCreatedVal = how;
    }

    public String getName() {
        String nameString = new String("[");
        if (this.variables.length > 0) {
            nameString = String.valueOf(nameString) + this.variables[0].getName();
        }
        int i = 1;
        while (i < this.variables.length) {
            nameString = String.valueOf(nameString) + ", " + this.variables[i].getName();
            ++i;
        }
        return String.valueOf(nameString) + "]";
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public abstract EltsIterator iterator();

    public int size() {
        return this.thesize;
    }

    public boolean contains(Variable v) {
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < this.variables.length) {
            output.append(this.variables[i].getName()).append("\t");
            ++i;
        }
        output.append("Value\n");
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            int i2 = 0;
            while (i2 < this.variables.length) {
                output.append(this.variables[i2].getDomain()[index[i2]]).append("\t");
                ++i2;
            }
            output.append(iter.next()).append("\n");
            if (!iter.hasNext()) continue;
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomain().length - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < this.variables.length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        return output.toString();
    }

    public void printVariables() {
        if (this.variables.length > 0) {
            System.out.print(this.variables[0].getName());
            int i = 1;
            while (i < this.variables.length) {
                System.out.print(", " + this.variables[i].getName());
                ++i;
            }
        }
    }

    public void print() {
        this.print("");
    }

    public void print(String indent) {
        System.out.print(indent);
        int i = 0;
        while (i < this.variables.length) {
            System.out.print(this.variables[i].getName());
            System.out.print("\t");
            ++i;
        }
        System.out.print("Value\n");
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            System.out.print(indent);
            int i2 = 0;
            while (i2 < this.variables.length) {
                System.out.print(this.variables[i2].getDomain()[index[i2]]);
                System.out.print("\t");
                ++i2;
            }
            System.out.println(iter.next());
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomain().length - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    allMax = false;
                } else {
                    index[i3] = 0;
                }
                --i3;
            }
        }
    }

    public boolean allOnes() {
        EltsIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() == 1.0) continue;
            return false;
        }
        return true;
    }

    public boolean isRedundant(Variable var) {
        int before = 1;
        int dom = var.getDomain().length;
        int after = 1;
        int pos = 0;
        while (this.variables[pos] != var) {
            before *= this.variables[pos++].getDomain().length;
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomain().length;
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double val = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    if (val != its[i3].next()) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }

    public void display() {
    }
}

