/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.EltsIterator;
import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.Variable;

public class FactorDeterministic
extends Factor {
    private int[] theAction;
    private Variable[] theParents;
    private Variable decisionVar;
    private int preSize;
    private int postSize;
    private int curSize;

    public FactorDeterministic(Variable[] pars, Variable var, int[] actions) {
        super(FactorDeterministic.insert(var, pars), 15);
        this.theParents = pars;
        this.decisionVar = var;
        this.preSize = 1;
        int pos = 0;
        while (pos < pars.length && pars[pos].getId() < var.getId()) {
            this.preSize *= pars[pos++].getDomain().length;
        }
        this.curSize = var.getDomain().length;
        this.postSize = 1;
        while (pos < pars.length) {
            this.postSize *= pars[pos++].getDomain().length;
        }
        this.theAction = actions;
    }

    public Variable getDecisionVar() {
        return this.decisionVar;
    }

    public void printPolicyFunction() {
        this.printPolicyFunction("");
    }

    public int[] getPolicyFunction() {
        return this.theAction;
    }

    public void printPolicyFunction(String indent) {
        System.out.print(indent);
        int i = 0;
        while (i < this.theParents.length) {
            System.out.print(this.theParents[i].getName());
            System.out.print("\t");
            ++i;
        }
        System.out.println(String.valueOf(this.decisionVar.getName()) + "?");
        int[] index = new int[this.theParents.length];
        int policyIndex = 0;
        while (policyIndex < this.theAction.length) {
            System.out.print(indent);
            int i2 = 0;
            while (i2 < this.theParents.length) {
                System.out.print(this.theParents[i2].getDomain()[index[i2]]);
                System.out.print("\t");
                ++i2;
            }
            System.out.println(this.decisionVar.getDomain()[this.theAction[policyIndex++]]);
            boolean allMax = true;
            int i3 = this.theParents.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.theParents[i3].getDomain().length - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    allMax = false;
                } else {
                    index[i3] = 0;
                }
                --i3;
            }
        }
    }

    public EltsIterator iterator() {
        return new Itr();
    }

    public void update(int pos, int val) {
        this.theAction[pos] = val;
    }

    private static Variable[] insert(Variable var, Variable[] vars) {
        Variable[] result = new Variable[vars.length + 1];
        int pos = 0;
        while (pos < vars.length && vars[pos].getId() < var.getId()) {
            result[pos] = vars[pos++];
        }
        result[pos] = var;
        while (pos < vars.length) {
            result[pos + 1] = vars[pos++];
        }
        return result;
    }

    public Variable[] getParents() {
        return this.theParents;
    }

    private class Itr
    implements EltsIterator {
        int prepos = 0;
        int curpos = 0;
        int postpos = 0;
        int actionpos = 0;

        Itr() {
        }

        public boolean hasNext() {
            return this.prepos + 1 < FactorDeterministic.this.preSize || this.curpos + 1 < FactorDeterministic.this.curSize || this.postpos < FactorDeterministic.this.postSize;
        }

        public double next() {
            if (this.postpos == FactorDeterministic.this.postSize) {
                if (this.curpos + 1 < FactorDeterministic.this.curSize) {
                    ++this.curpos;
                } else {
                    this.curpos = 0;
                    ++this.prepos;
                }
                this.actionpos = this.prepos * FactorDeterministic.this.postSize;
                this.postpos = 0;
            }
            ++this.postpos;
            if (this.curpos == FactorDeterministic.this.theAction[this.actionpos++]) {
                return 1.0;
            }
            return 0.0;
        }

        public int currPos() {
            return (this.prepos * FactorDeterministic.this.curSize + this.curpos) * FactorDeterministic.this.postSize + this.postpos;
        }

        public void backTo(int pos) {
            this.postpos = pos % FactorDeterministic.this.postSize;
            this.curpos = (pos /= FactorDeterministic.this.postSize) % FactorDeterministic.this.curSize;
            this.prepos = pos / FactorDeterministic.this.curSize;
        }
    }
}

