/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorIterator;
import CIspace.cspTools.ve.FactorStore;
import CIspace.cspTools.ve.Variable;
import java.util.Hashtable;

public class FactorStoreIndexed
extends FactorStore {
    private VariableToEliminate[] varsPQ;
    private int numVariables;
    private VariableToEliminate last = null;
    Hashtable varToVarInQuery;
    private Factor[] finalFacs;
    private int numFinalFacs;

    public FactorStoreIndexed(Variable[] toSumOut, Factor[] initFactors, int numInitFactors) {
        this.varToVarInQuery = new Hashtable(toSumOut.length * 3 / 2);
        this.varsPQ = new VariableToEliminate[toSumOut.length];
        this.finalFacs = new Factor[initFactors.length + 1];
        this.numFinalFacs = 0;
        int i = 0;
        while (i < toSumOut.length) {
            this.varsPQ[i] = new VariableToEliminate(toSumOut[i], toSumOut.length);
            ++i;
        }
        i = 0;
        while (i < numInitFactors) {
            new FactorLink(initFactors[i]);
            ++i;
        }
        this.numVariables = toSumOut.length;
        if (toSumOut.length > 0) {
            i = 1;
            while (i < toSumOut.length) {
                this.shuffleUp(i);
                ++i;
            }
        }
    }

    public boolean hasNext() {
        return this.numVariables > 0;
    }

    public Variable next() {
        this.last = this.varsPQ[0];
        this.varsPQ[0] = this.varsPQ[--this.numVariables];
        this.shuffleDown(0);
        return this.last.var;
    }

    public void addFactor(Factor fac) {
        this.cleanUp(fac);
        FactorLink fl = new FactorLink(fac);
    }

    private void cleanUp(Factor fac) {
        int i = 0;
        while (i < fac.getVariables().length) {
            VariableToEliminate vte = (VariableToEliminate)this.varToVarInQuery.get(fac.getVariables()[i]);
            if (vte != null) {
                vte.computeNeighbours();
            }
            ++i;
        }
    }

    public FactorIterator emunFactorsRemoved() {
        return new EnumFacsRem();
    }

    public FactorIterator emunFactorsRemaining() {
        return new EnumFacsRemaining();
    }

    private void shuffleDown(int pos) {
        int smallest = 2 * pos + 1 < this.numVariables && this.varsPQ[2 * pos + 1].valToMinimise() < this.varsPQ[pos].valToMinimise() ? 2 * pos + 1 : pos;
        if (2 * pos + 2 < this.numVariables && this.varsPQ[2 * pos + 2].valToMinimise() < this.varsPQ[smallest].valToMinimise()) {
            smallest = 2 * pos + 2;
        }
        if (smallest != pos) {
            VariableToEliminate tmp = this.varsPQ[pos];
            this.varsPQ[pos] = this.varsPQ[smallest];
            this.varsPQ[pos].positionInPQ = pos;
            this.varsPQ[smallest] = tmp;
            this.varsPQ[smallest].positionInPQ = smallest;
            this.shuffleDown(smallest);
        }
    }

    private void shuffleUp(int pos) {
        VariableToEliminate tmp = this.varsPQ[pos];
        while (pos > 0 & tmp.valToMinimise() < this.varsPQ[(pos - 1) / 2].valToMinimise()) {
            this.varsPQ[pos] = this.varsPQ[(pos - 1) / 2];
            this.varsPQ[pos].positionInPQ = pos;
            pos = (pos - 1) / 2;
        }
        this.varsPQ[pos] = tmp;
        this.varsPQ[pos].positionInPQ = pos;
    }

    private class EnumFacsRem
    implements FactorIterator {
        FactorLink nextFact;

        EnumFacsRem() {
            this.nextFact = ((FactorStoreIndexed)FactorStoreIndexed.this).last.factors;
        }

        public boolean hasNext() {
            return this.nextFact != null;
        }

        public Factor next() {
            Factor res = this.nextFact.fac;
            int i = 0;
            while (this.nextFact.vars[i] != FactorStoreIndexed.this.last) {
                ++i;
            }
            FactorLink newNextFact = this.nextFact.next[i];
            this.nextFact.remove();
            this.nextFact = newNextFact;
            return res;
        }
    }

    private class EnumFacsRemaining
    implements FactorIterator {
        int pos = 0;

        EnumFacsRemaining() {
        }

        public boolean hasNext() {
            return this.pos < FactorStoreIndexed.this.numFinalFacs;
        }

        public Factor next() {
            return FactorStoreIndexed.this.finalFacs[this.pos++];
        }
    }

    private class VariableToEliminate {
        Variable var;
        Variable[] neighbours;
        int numNeighbours;
        int size;
        FactorLink factors;
        int numFactors;
        int deficiency;
        int positionInPQ;

        void recomputeSize() {
            this.size = 1;
            int i = 0;
            while (i < this.numNeighbours) {
                this.size *= this.neighbours[i].getDomain().length;
                ++i;
            }
        }

        VariableToEliminate(Variable newvar, int maxNeighs) {
            this.var = newvar;
            FactorStoreIndexed.this.varToVarInQuery.put(newvar, this);
            this.neighbours = new Variable[maxNeighs];
            this.numNeighbours = 0;
        }

        void computeNeighbours() {
            this.numNeighbours = 0;
            FactorLink fL = this.factors;
            while (fL != null) {
                this.addNeighbours(fL.fac.getVariables());
                int i = 0;
                while (fL.vars[i] != this) {
                    ++i;
                }
                fL = fL.next[i];
            }
            this.recomputeSize();
        }

        void addNeighbours(Variable[] vtes) {
            Variable[] newNeighbours = new Variable[this.numNeighbours + vtes.length];
            int vpos = 0;
            int nbspos = 0;
            int newpos = 0;
            while (vpos < vtes.length && nbspos < this.numNeighbours) {
                if (vtes[vpos] == this.var) {
                    ++vpos;
                    continue;
                }
                if (vtes[vpos] == this.neighbours[nbspos]) {
                    newNeighbours[newpos++] = vtes[vpos++];
                    ++nbspos;
                    continue;
                }
                newNeighbours[newpos++] = vtes[vpos].getId() < this.neighbours[nbspos].getId() ? vtes[vpos++] : this.neighbours[nbspos++];
            }
            while (vpos < vtes.length) {
                newNeighbours[newpos++] = vtes[vpos++];
            }
            while (nbspos < this.numNeighbours) {
                newNeighbours[newpos++] = this.neighbours[nbspos++];
            }
            this.neighbours = newNeighbours;
            this.numNeighbours = newpos;
        }

        int valToMinimise() {
            return this.size;
        }
    }

    private class FactorLink {
        Factor fac;
        FactorLink[] prev;
        FactorLink[] next;
        VariableToEliminate[] vars;
        int numVarsToElim;

        FactorLink(Factor f1) {
            this.fac = f1;
            int numVars = f1.getVariables().length;
            this.vars = new VariableToEliminate[numVars];
            this.next = new FactorLink[numVars];
            this.prev = new FactorLink[numVars];
            this.numVarsToElim = 0;
            int i = 0;
            while (i < numVars) {
                VariableToEliminate vte = (VariableToEliminate)FactorStoreIndexed.this.varToVarInQuery.get(f1.getVariables()[i]);
                if (vte != null) {
                    this.vars[this.numVarsToElim] = vte;
                    this.next[this.numVarsToElim] = vte.factors;
                    if (vte.factors != null) {
                        int j = 0;
                        while (vte.factors.vars[j] != vte) {
                            ++j;
                        }
                        vte.factors.prev[j] = this;
                    }
                    vte.factors = this;
                    ++vte.numFactors;
                    ++this.numVarsToElim;
                }
                ++i;
            }
            if (this.numVarsToElim == 0) {
                Factor[] factorArray = FactorStoreIndexed.this.finalFacs;
                FactorStoreIndexed factorStoreIndexed2 = FactorStoreIndexed.this;
                int n = factorStoreIndexed2.numFinalFacs;
                factorStoreIndexed2.numFinalFacs = n + 1;
                factorArray[n] = f1;
            }
            i = 0;
            while (i < this.numVarsToElim) {
                this.vars[i].addNeighbours(f1.getVariables());
                this.vars[i].recomputeSize();
                ++i;
            }
        }

        void remove() {
            int i = 0;
            while (i < this.numVarsToElim) {
                int j;
                --this.vars[i].numFactors;
                if (this.prev[i] == null) {
                    this.vars[i].factors = this.next[i];
                } else {
                    j = 0;
                    while (this.prev[i].vars[j] != this.vars[i]) {
                        ++j;
                    }
                    this.prev[i].next[j] = this.next[i];
                }
                if (this.next[i] != null) {
                    j = 0;
                    while (this.next[i].vars[j] != this.vars[i]) {
                        ++j;
                    }
                    this.next[i].prev[j] = this.prev[i];
                }
                ++i;
            }
        }
    }
}

