/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorIterator;
import CIspace.cspTools.ve.FactorStore;
import CIspace.cspTools.ve.Variable;

public class FactorStoreRandom
extends FactorStore {
    private Factor[] theFactors;
    private int numFactors;
    private Variable[] theVariables;
    private int numVariables;
    private int factorMaxSize;
    private Variable last;

    public FactorStoreRandom(Variable[] toSumOut, Factor[] initialFactors, int numInitFactors) {
        this.theFactors = initialFactors;
        this.numFactors = numInitFactors;
        this.theVariables = toSumOut;
        this.numVariables = toSumOut.length;
        this.factorMaxSize = numInitFactors;
    }

    public boolean hasNext() {
        return this.numVariables > 0;
    }

    public Variable next() {
        int index = (int)(Math.random() * (double)this.numVariables);
        this.last = this.theVariables[index];
        this.theVariables[index] = this.theVariables[--this.numVariables];
        return this.last;
    }

    public void addFactor(Factor newFactor) {
        if (this.numFactors == this.factorMaxSize) {
            this.factorMaxSize *= 2;
            Factor[] newFactors = new Factor[this.factorMaxSize];
            int i = 0;
            while (i < this.numFactors) {
                newFactors[i] = this.theFactors[i];
                ++i;
            }
            this.theFactors = newFactors;
        }
        this.theFactors[this.numFactors++] = newFactor;
    }

    public FactorIterator emunFactorsRemoved() {
        Factor[] toReturn = new Factor[this.numFactors];
        int posToReturn = 0;
        int newfacpos = 0;
        int pos = 0;
        while (pos < this.numFactors) {
            if (this.theFactors[pos].contains(this.last)) {
                toReturn[posToReturn++] = this.theFactors[pos];
            } else {
                this.theFactors[newfacpos++] = this.theFactors[pos];
            }
            ++pos;
        }
        this.numFactors = newfacpos;
        return new FacItr(toReturn, posToReturn);
    }

    public FactorIterator emunFactorsRemaining() {
        return new FacItr(this.theFactors, this.numFactors);
    }

    private class FacItr
    implements FactorIterator {
        int curpos = 0;
        Factor[] toReturn;
        int numToReturn;

        FacItr(Factor[] toReturn, int numToReturn) {
            this.toReturn = toReturn;
            this.numToReturn = numToReturn;
        }

        public boolean hasNext() {
            return this.curpos < this.numToReturn;
        }

        public Factor next() {
            return this.toReturn[this.curpos++];
        }
    }
}

