/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorIterator;
import CIspace.cspTools.ve.FactorStore;
import CIspace.cspTools.ve.Variable;
import java.util.Hashtable;

public class FactorStoreSequential
extends FactorStore {
    private Variable[] theVariables;
    private int varPos;
    private int factorMaxSize;
    private Variable last;
    private Factor[][] buckets;
    private int[] bucketSize;
    private Hashtable varToBucketIndex;
    private Factor[] finalFactors;
    private int numFinalFactors;

    public FactorStoreSequential(Variable[] toSumOut, Factor[] initialFactors, int numInitFactors) {
        this.theVariables = toSumOut;
        this.varPos = 0;
        this.factorMaxSize = numInitFactors < 10 ? numInitFactors : 10;
        this.buckets = new Factor[toSumOut.length][this.factorMaxSize];
        this.bucketSize = new int[toSumOut.length];
        this.varToBucketIndex = new Hashtable(toSumOut.length * 3 / 2);
        this.finalFactors = new Factor[numInitFactors];
        int i = 0;
        while (i < toSumOut.length) {
            this.varToBucketIndex.put(toSumOut[i], new Integer(i));
            ++i;
        }
        i = 0;
        while (i < numInitFactors) {
            this.addtoBuckets(initialFactors[i]);
            ++i;
        }
    }

    public boolean hasNext() {
        return this.varPos < this.theVariables.length;
    }

    public Variable next() {
        return this.theVariables[this.varPos];
    }

    public void addFactor(Factor newFactor) {
        ++this.varPos;
        this.addtoBuckets(newFactor);
    }

    private void addtoBuckets(Factor fac) {
        int lowestBucket = Integer.MAX_VALUE;
        int i = 0;
        while (i < fac.getVariables().length) {
            Integer pos = (Integer)this.varToBucketIndex.get(fac.getVariables()[i]);
            if (pos != null && pos >= this.varPos && pos < lowestBucket) {
                lowestBucket = pos;
            }
            ++i;
        }
        if (lowestBucket == Integer.MAX_VALUE) {
            this.finalFactors[this.numFinalFactors++] = fac;
        } else {
            if (this.buckets[lowestBucket].length == this.bucketSize[lowestBucket]) {
                Factor[] newBucket = new Factor[1 + this.buckets[lowestBucket].length * 2];
                int i2 = 0;
                while (i2 < this.buckets[lowestBucket].length) {
                    newBucket[i2] = this.buckets[lowestBucket][i2];
                    ++i2;
                }
                this.buckets[lowestBucket] = newBucket;
            }
            int n = lowestBucket;
            int n2 = this.bucketSize[n];
            this.bucketSize[n] = n2 + 1;
            this.buckets[lowestBucket][n2] = fac;
        }
    }

    public FactorIterator emunFactorsRemoved() {
        return new FacItr(this.buckets[this.varPos], this.bucketSize[this.varPos]);
    }

    public FactorIterator emunFactorsRemaining() {
        return new FacItr(this.finalFactors, this.numFinalFactors);
    }

    private class FacItr
    implements FactorIterator {
        int curpos = 0;
        Factor[] toReturn;
        int numToReturn;

        FacItr(Factor[] toReturn, int numToReturn) {
            this.toReturn = toReturn;
            this.numToReturn = numToReturn;
        }

        public boolean hasNext() {
            return this.curpos < this.numToReturn;
        }

        public Factor next() {
            return this.toReturn[this.curpos++];
        }
    }
}

