/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.EltsIterator;
import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorExpand;
import CIspace.cspTools.ve.Variable;

public class FactorTimes
extends Factor {
    private Factor fac1;
    private Factor fac2;

    public FactorTimes(Factor f1, Factor f2) {
        super(FactorTimes.unionVars(f1.getVariables(), f2.getVariables()), 4);
        this.fac1 = f1.getVariables().length == this.getVariables().length ? f1 : new FactorExpand(f1, this.getVariables());
        this.fac2 = f2.getVariables().length == this.getVariables().length ? f2 : new FactorExpand(f2, this.getVariables());
    }

    public EltsIterator iterator() {
        return new Itr();
    }

    private static Variable[] unionVars(Variable[] vars1, Variable[] vars2) {
        Variable[] vars = new Variable[vars1.length + vars2.length];
        int pos = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < vars1.length && i2 < vars2.length) {
            if (vars1[i1] == vars2[i2]) {
                vars[pos++] = vars1[i1++];
                ++i2;
                continue;
            }
            vars[pos++] = vars1[i1].getId() < vars2[i2].getId() ? vars1[i1++] : vars2[i2++];
        }
        while (i1 < vars1.length) {
            vars[pos++] = vars1[i1++];
        }
        while (i2 < vars2.length) {
            vars[pos++] = vars2[i2++];
        }
        Variable[] result = new Variable[pos];
        int i = 0;
        while (i < pos) {
            result[i] = vars[i];
            ++i;
        }
        return result;
    }

    private class Itr
    implements EltsIterator {
        EltsIterator it1;
        EltsIterator it2;

        Itr() {
            this.it1 = FactorTimes.this.fac1.iterator();
            this.it2 = FactorTimes.this.fac2.iterator();
        }

        public boolean hasNext() {
            boolean val = this.it1.hasNext();
            return val;
        }

        public double next() {
            double val = this.it1.next() * this.it2.next();
            return val;
        }

        public int currPos() {
            return this.it1.currPos();
        }

        public void backTo(int pos) {
            this.it1.backTo(pos);
            this.it2.backTo(pos);
        }
    }
}

