/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.ve;

import CIspace.cspTools.ve.DecisionNetwork;
import CIspace.cspTools.ve.Factor;
import CIspace.cspTools.ve.FactorIterator;
import CIspace.cspTools.ve.FactorNormalise;
import CIspace.cspTools.ve.FactorObserved;
import CIspace.cspTools.ve.FactorStore;
import CIspace.cspTools.ve.FactorStoreIndexed;
import CIspace.cspTools.ve.FactorStoreSequential;
import CIspace.cspTools.ve.FactorSumOut;
import CIspace.cspTools.ve.FactorTimes;
import CIspace.cspTools.ve.Variable;

public class Query {
    private Factor result;
    private Factor normresult;
    private Variable[] eo;
    private int maxFactorSize;

    public Query(Variable[] queryVars, DecisionNetwork dnet, Variable[] observedVars, int[] observedVals, String how) {
        FactorStore factors;
        int i;
        Variable[] toSumOut = this.determineToSumOut(dnet.getVariables(), dnet.getNumVariables(), queryVars, observedVars);
        this.eo = new Variable[toSumOut.length];
        int eopos = 0;
        this.maxFactorSize = 0;
        Factor[] observedFactors = new Factor[dnet.getNumProbFactors()];
        if (observedVars.length > 0) {
            i = 0;
            while (i < dnet.getNumProbFactors()) {
                observedFactors[i] = new FactorObserved(dnet.getProbFactors()[i], observedVars, observedVals);
                ++i;
            }
        } else {
            i = 0;
            while (i < dnet.getNumProbFactors()) {
                observedFactors[i] = dnet.getProbFactors()[i];
                ++i;
            }
        }
        if (how == "random") {
            Query.shuffle(toSumOut);
            factors = new FactorStoreSequential(toSumOut, observedFactors, dnet.getNumProbFactors());
        } else {
            factors = how == "sequential" ? new FactorStoreSequential(toSumOut, observedFactors, dnet.getNumProbFactors()) : new FactorStoreIndexed(toSumOut, observedFactors, dnet.getNumProbFactors());
        }
        while (factors.hasNext()) {
            Variable elimVar = factors.next();
            this.eo[eopos++] = elimVar;
            System.out.println("\nEliminating " + elimVar.getName());
            FactorIterator toMultiply = factors.emunFactorsRemoved();
            Factor prod = toMultiply.next();
            System.out.print("Multiplying factors: " + prod.getName());
            while (toMultiply.hasNext()) {
                Factor nextProd = toMultiply.next();
                System.out.print(", " + nextProd.getName());
                prod = new FactorTimes(prod, nextProd);
            }
            System.out.println(".");
            Variable[] sumOut = new Variable[]{elimVar};
            FactorSumOut newFac = new FactorSumOut(prod, sumOut);
            System.out.println("Creating factor " + newFac.getName());
            if (this.maxFactorSize < newFac.size()) {
                this.maxFactorSize = newFac.size();
            }
            factors.addFactor(newFac);
        }
        FactorIterator remainingFactors = factors.emunFactorsRemaining();
        this.result = remainingFactors.next();
        while (remainingFactors.hasNext()) {
            this.result = new FactorTimes(this.result, remainingFactors.next());
        }
        this.normresult = new FactorNormalise(this.result);
    }

    public Factor getResult() {
        return this.normresult;
    }

    public Factor getUnNormResult() {
        return this.result;
    }

    public Variable[] getEO() {
        return this.eo;
    }

    public int getMaxFactorSize() {
        return this.maxFactorSize;
    }

    private Variable[] determineToSumOut(Variable[] allVars, int numVars, Variable[] queryVars, Variable[] observedVars) {
        Variable[] res = new Variable[numVars - queryVars.length - observedVars.length];
        int allpos = 0;
        int qpos = 0;
        int opos = 0;
        int respos = 0;
        while (allpos < numVars) {
            if (qpos < queryVars.length && queryVars[qpos] == allVars[allpos]) {
                ++qpos;
                ++allpos;
                continue;
            }
            if (opos < observedVars.length && observedVars[opos] == allVars[allpos]) {
                ++opos;
                ++allpos;
                continue;
            }
            res[respos++] = allVars[allpos++];
        }
        return res;
    }

    public static void shuffle(Variable[] vars) {
        int i = vars.length - 1;
        while (i > 0) {
            int pos = (int)(Math.random() * (double)(i + 1));
            if (pos != i) {
                Variable tmp = vars[i];
                vars[i] = vars[pos];
                vars[pos] = tmp;
            }
            --i;
        }
    }
}

