/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class AboutCanvas
extends Canvas
implements Runnable,
MouseListener,
MouseMotionListener {
    private Image image;
    private Graphics offscreen;
    private Vector s;
    private int y;
    private Thread t;
    private boolean wrap;
    private Color bg;
    private Color fg;
    private boolean drawRandom;
    private int skip = 1;
    private int oldSkip;
    private int mouseY;
    private String filename;
    private static final int SLEEP = 50;

    public AboutCanvas(String filename) {
        this.filename = filename;
        this.prepString();
        this.drawRandom = false;
        this.bg = new Color(255, 255, 255);
        this.fg = new Color(0, 0, 0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void prepString() {
        try {
            BufferedReader in;
            this.s = new Vector(10, 10);
            String line = "";
            if (this.filename.startsWith("http://")) {
                URL url = new URL(this.filename);
                InputStream iStream = url.openStream();
                in = new BufferedReader(new InputStreamReader(iStream));
            } else {
                in = new BufferedReader(new FileReader(this.filename));
            }
            while ((line = in.readLine()) != null) {
                this.s.addElement(line);
            }
            this.s.addElement("");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void setGraphics() {
        this.image = this.createImage(this.getSize().width, this.getSize().height);
        this.offscreen = this.image.getGraphics();
        this.offscreen.setFont(new Font("SansSerif", 0, 12));
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            this.setGraphics();
            return;
        }
        this.offscreen.setColor(this.bg);
        this.offscreen.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.drawRandom) {
            this.drawRandom();
        }
        this.offscreen.setColor(this.fg);
        FontMetrics fm = this.offscreen.getFontMetrics();
        int x = 0;
        int h = fm.getHeight();
        int i = 0;
        while (i < this.s.size()) {
            if (this.y + i * h > 0 && this.y + i * h < this.getSize().height) {
                x = this.getSize().width / 2 - fm.stringWidth((String)this.s.elementAt(i)) / 2;
                this.offscreen.drawString((String)this.s.elementAt(i), x, this.y + i * h);
            }
            ++i;
        }
        if (this.y + this.s.size() * h <= 0) {
            this.wrap = true;
        }
        g.drawImage(this.image, 0, 0, this);
    }

    private void drawRandom() {
        if (Math.random() < 0.2) {
            this.offscreen.setColor(Color.yellow);
            int cx = this.getSize().width / 2;
            int cy = this.getSize().height / 2;
            int i = 0;
            while (i < 20) {
                int dx = (int)((double)(2 * cx) * (Math.random() - 0.5));
                int dy = (int)((double)(2 * cy) * (Math.random() - 0.5));
                this.offscreen.drawLine(cx, cy, cx + dx, cy + dy);
                ++i;
            }
        }
    }

    public void resetY() {
        this.y = this.getSize().height;
        this.wrap = false;
    }

    public void run() {
        this.wrap = false;
        this.y = -1000;
        while (this.t != null) {
            this.y -= this.skip;
            if (this.wrap) {
                this.resetY();
            }
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        if (this.t != null) {
            this.t = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.skip == 0) {
            this.skip = this.oldSkip;
        } else {
            this.oldSkip = this.skip;
            this.skip = 0;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.skip = this.mouseY - e.getY();
        if (this.skip < 0) {
            this.skip = 0;
        }
        this.mouseY = e.getY();
    }

    public void mouseMoved(MouseEvent e) {
    }
}

