/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.GraphCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FontDialog
extends Dialog
implements ActionListener {
    private TextField tf;
    private GraphCanvas canvas;

    public FontDialog(GraphCanvas parent) {
        super((Frame)parent.parent, "Choose Font Size", true);
        this.canvas = parent;
        Button ok = new Button("OK");
        ok.addActionListener(this);
        Button cancel = new Button("Cancel");
        cancel.addActionListener(this);
        Label label = new Label("Font Size:");
        this.tf = new TextField(String.valueOf(this.canvas.getFont().getSize()) + "", 3);
        this.tf.addActionListener(this);
        Panel north = new Panel();
        north.add(label);
        north.add(this.tf);
        Panel south = new Panel();
        south.add(ok);
        south.add(cancel);
        this.setLayout(new BorderLayout());
        this.add("Center", north);
        this.add("South", south);
        this.pack();
        this.centerWindow();
        this.show();
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (!arg.equals("Cancel")) {
            try {
                int fontSize = Integer.valueOf(this.tf.getText());
                if (fontSize < 1) {
                    fontSize = 1;
                }
                this.canvas.changeFont(fontSize);
            }
            catch (Exception err) {
                System.out.println(err);
            }
        }
        this.dispose();
    }
}

