/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class NodeDialog
extends Dialog
implements ActionListener {
    private Button ok;
    private Button cancel;
    private Choice colors;
    private Choice shapes;
    private GraphCanvas canvas;
    private Point pos;
    private TextField label;
    private boolean creating;
    private Node node;

    public NodeDialog(GraphCanvas canvas) {
        super((Frame)canvas.parent, "Node Options", true);
        this.canvas = canvas;
        this.creating = true;
        ((Component)this).setSize(300, 300);
        this.ok = new Button("OK");
        this.cancel = new Button("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.colors = new Choice();
        this.colors.add("Black");
        this.colors.add("Red");
        this.colors.add("Blue");
        this.colors.add("Green");
        this.shapes = new Choice();
        this.shapes.add("Oval");
        this.shapes.add("Rectangle");
        this.shapes.add("Diamond");
        this.label = new TextField("", 10);
        this.label.addActionListener(this);
        this.setLayout(new GridLayout(3, 1));
        Panel p1 = new Panel();
        p1.add(new Label("Label"));
        p1.add(this.label);
        this.add(p1);
        Panel p2 = new Panel();
        p2.add(this.colors);
        p2.add(this.shapes);
        this.add(p2);
        Panel p4 = new Panel();
        p4.add(this.ok);
        p4.add(this.cancel);
        this.add(p4);
        this.pack();
        this.setResizable(false);
    }

    public void open(Point pos) {
        this.creating = true;
        this.pos = pos;
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    public void open(Node n) {
        this.creating = false;
        this.node = n;
        this.pos = n.pos;
        this.label.setText(n.label[0]);
        if (n.color == Color.black) {
            this.colors.select("Black");
        } else if (n.color == Color.red) {
            this.colors.select("Red");
        } else if (n.color == Color.blue) {
            this.colors.select("Blue");
        } else {
            this.colors.select("Green");
        }
        if (n.shape == 1110) {
            this.shapes.select("Oval");
        } else if (n.shape == 1111) {
            this.shapes.select("Rectangle");
        } else {
            this.shapes.select("Diamond");
        }
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (!arg.equals("Cancel")) {
            this.parseDialog();
        }
        ((Component)this).setVisible(false);
    }

    private void parseDialog() {
        Color color = this.colors.getSelectedItem() == "Black" ? Color.black : (this.colors.getSelectedItem() == "Red" ? Color.red : (this.colors.getSelectedItem() == "Blue" ? Color.blue : Color.green));
        int shape = this.shapes.getSelectedItem() == "Oval" ? 1110 : (this.shapes.getSelectedItem() == "Rectangle" ? 1111 : 1112);
        if (this.creating) {
            Node n = new Node(this.canvas.graph, this.label.getText(), this.pos, color, shape);
            this.canvas.graph.addNode(n);
        } else {
            this.canvas.graph.modifyNode(this.node, this.label.getText(), this.pos, color, shape);
        }
    }
}

