/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint.elements;

import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Point;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;

public class ConstraintVariable
extends CSPVariable {
    private Stack<Integer> indentStack = new Stack();
    protected Stack<int[]> oldSplits = new Stack();
    private ArrayList<StepInformation> splitHistory = new ArrayList();

    public ConstraintVariable(DomainDiscrete dom, Graph graph, Point p, String name) {
        super(dom, graph, p, name);
    }

    public void pushIndent(int indent) {
        this.indentStack.push(new Integer(indent));
    }

    public int popIndent() {
        try {
            return this.indentStack.pop();
        }
        catch (EmptyStackException e) {
            return 0;
        }
    }

    public void popOldConstraint() {
        try {
            this.domain.set(this.oldSplits.pop());
        }
        catch (EmptyStackException e) {
            this.domain.resetSplit();
        }
    }

    public void popOldSplits() {
        this.oldSplits.pop();
    }

    public String getSplittingString() {
        return String.valueOf(this.name) + " in {" + this.domain.getSplitRep() + "}";
    }

    public String getSplitRep() {
        return this.domain.getSplitRep();
    }

    public void resetNode() {
        this.reset();
        this.indentStack.removeAllElements();
        this.oldSplits.removeAllElements();
    }

    public void pushOldConstraint() {
        int[] split = this.domain.getSplitElements();
        int[] oldSplit = new int[split.length];
        int i = 0;
        while (i < split.length) {
            oldSplit[i] = split[i];
            ++i;
        }
        this.oldSplits.push(oldSplit);
    }

    public void backTrack(int[] allowed, int[] backtrackAllowed) {
        this.domain.setSplitElements(allowed);
        this.oldSplits.push(backtrackAllowed);
    }

    public void backTrack(int selectedValue) {
        if (selectedValue < 0 || selectedValue >= this.domain.getSize()) {
            this.oldSplits.push(this.domain.getSplitElements());
            return;
        }
        int[] split = this.domain.getSplitElements();
        int[] oldSplit = new int[split.length - 1];
        int i = 0;
        while (i < oldSplit.length) {
            if (split[i] == selectedValue) continue;
            oldSplit[i] = split[i];
            ++i;
        }
        this.oldSplits.push(oldSplit);
        this.domain.setSplitElements(new int[]{selectedValue});
    }

    public void stepBack() {
        int lastElementIndex = this.splitHistory.size() - 1;
        if (lastElementIndex != 0) {
            this.splitHistory.remove(lastElementIndex);
        }
        this.domain.setSplitElements(this.splitHistory.get(this.splitHistory.size() - 1).getSplitInfo());
    }

    public void stepBackAndSave() {
        int lastElementIndex = this.splitHistory.size() - 1;
        if (lastElementIndex != 0) {
            this.oldSplits.push(this.splitHistory.remove(lastElementIndex).getSplitInfo());
        }
        this.domain.setSplitElements(this.splitHistory.get(this.splitHistory.size() - 1).getSplitInfo());
    }

    public void saveSplitHistory() {
        this.splitHistory.add(new StepInformation(this.domain.getSplitElements(), 0));
    }

    public void clearSplitHistory() {
        this.splitHistory.clear();
    }

    public int getVarType() {
        return this.splitHistory.get(this.splitHistory.size() - 1).getType();
    }

    public void setVarToSplit() {
        this.splitHistory.get(this.splitHistory.size() - 1).setType(1221);
    }

    public void setVarToBackTrack() {
        this.splitHistory.get(this.splitHistory.size() - 1).setType(1222);
    }

    class StepInformation {
        private int[] currentSplit;
        private int type;

        public StepInformation(int[] splitInfo, int type) {
            this.currentSplit = splitInfo;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public boolean isDomainSplit() {
            return this.type == 1221;
        }

        public boolean isBackTrack() {
            return this.type == 1222;
        }

        public void setType(int i) {
            this.type = i;
        }

        public int[] getSplitInfo() {
            return this.currentSplit;
        }
    }
}

