/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.IO;
import AIspace.cspTools.dialogs.CSPDescriptionDialog;
import AIspace.cspTools.dialogs.CSPTextFrame;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.dialogs.OpenLocationDialog;
import AIspace.graphToolKit.help.HelpMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class CSPWindow
extends GraphWindow {
    private static final long serialVersionUID = 1L;
    protected CSP csp;
    private JMenuItem textRepresentationMenuItem;
    private JMenuItem currentStateMenuItem;
    private JMenuItem undoItem;
    private JMenuItem descriptionMenuItem;
    public String oldTextRep;
    protected static ImageIcon solveIcon = CSPWindow.createImageIcon("images/cspTools/gear.png");
    protected static ImageIcon constraintIcon = CSPWindow.createImageIcon("images/cspTools/createconstraint.png");
    protected static ImageIcon addvarIcon = CSPWindow.createImageIcon("images/cspTools/addvar.png");
    private boolean setCNS = false;

    public CSPWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.setTitle(appletTitle);
    }

    private void initializeAppletInfo() {
        appletTitle = "Hyper CSP Demo";
        appletName = "CSPtools";
        aboutText = "About this Applet\n\n" + appletTitle + "\n\n" + "Special Thanks to:\n" + "David Poole, Alan Mackworth, Holger Hoos,\n" + "Peter Gorniak, and Cristina Conati";
    }

    protected void getCanvas() {
        this.csp = this.getCSP();
        this.canvas = new CSPcanvas(this, false, this.csp);
        this.csp.init((CSPcanvas)this.canvas);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    protected CSPcanvas getCanvas(CSP csp) {
        return new CSPcanvas(this, false, csp);
    }

    public JToggleButton getSolveButtonAt(int index) {
        return this.solveButModes[index];
    }

    protected CSP getCSP() {
        return new CSP(this, false);
    }

    protected void reset() {
        this.canvas.reset();
        this.csp.init((CSPcanvas)this.canvas);
    }

    protected void set(CSPcanvas canvas, CSP csp, int hbar, int vbar) {
        this.canvas = canvas;
        this.csp = csp;
        canvas.setPreferredSize(new Dimension(15000, 10000));
        this.canvasPanel.remove(this.scrollPanel);
        this.scrollPanel = new JScrollPane(canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(hbar);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(vbar);
        this.scrollPanel = new JScrollPane(canvas, 22, 32);
        this.addComponent(this.scrollPanel, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.validate();
    }

    protected void createToolBar() {
        this.createButModes = new JToggleButton[6];
        this.setCreateButtons(0, this.createNodeIcon, "Create Variable");
        this.setCreateButtons(1, constraintIcon, "Create Constraint");
        this.setCreateButtons(2, addvarIcon, "Add Variable to Constraint");
        this.setCreateButtons(3, this.selectIcon, "\tSelect\t");
        this.setCreateButtons(4, this.deleteIcon, "\tDelete\t");
        this.setCreateButtons(5, this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    protected void createToolBarWithText() {
        this.createButModes = new JToggleButton[6];
        this.setCreateButtonsWithText(0, "Create Variable", this.createNodeIcon, "Create Variable");
        this.setCreateButtonsWithText(1, "Create Constraint", constraintIcon, "Create Constraint");
        this.setCreateButtonsWithText(2, "Add Variable to Constraint", addvarIcon, "Add Variable to Constraint");
        this.setCreateButtonsWithText(3, "\tSelect\t", this.selectIcon, "Select");
        this.setCreateButtonsWithText(4, "\tDelete\t", this.deleteIcon, "Delete");
        this.setCreateButtonsWithText(5, "Set Properties", this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    private void createToolBarLayout() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        int i = 0;
        while (i < 6) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    protected void solveToolBar() {
        this.solveButModes = new JToggleButton[6];
        this.solveButModes[0] = new JToggleButton(solveIcon);
        this.solveButModes[0].addActionListener(this);
        this.solveButModes[0].setToolTipText("Change Display");
        this.solveToolBarLayout();
    }

    protected void solveToolBarWithText() {
        this.solveButModes = new JToggleButton[6];
        this.solveButModes[0] = new JToggleButton("Change Display", solveIcon);
        this.solveButModes[0].addActionListener(this);
        this.solveButModes[0].setToolTipText("Change Display");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveModeButGroup.add(this.solveButModes[0]);
        this.toolBar.add(this.solveButModes[0]);
        this.solveButModes[0].setFont(this.toolBarFont);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        return menuBar;
    }

    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        JMenuItem mItem = new JMenuItem("Create New CSP");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(78);
        m.add(mItem);
        mItem = new JMenuItem("Load Sample CSP");
        mItem.addActionListener(this);
        mItem.setMnemonic(83);
        m.add(mItem);
        boolean hasLocalAccess = this.hasLocalAccess();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Load From File");
            mItem.setActionCommand(mItem.getText());
            mItem.setMnemonic(70);
            mItem.setDisplayedMnemonicIndex(10);
            mItem.addActionListener(this);
            m.add(mItem);
        }
        mItem = new JMenuItem("Load From URL");
        mItem.setMnemonic(85);
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Save CSP");
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        }
        mItem = new JMenuItem("Print");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(80);
        m.add(mItem);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.remove(5);
        JMenuItem mItem = new JMenuItem("Arrange Constraints");
        mItem.addActionListener(this);
        m.add((Component)mItem, 5);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        m.setMnemonic(69);
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.setMnemonic(85);
        this.undoItem.setActionCommand(this.undoItem.getText());
        this.undoItem.addActionListener(this);
        this.undoItem.setEnabled(false);
        m.add(this.undoItem);
        m.addSeparator();
        this.textRepresentationMenuItem = new JMenuItem("View/Edit Text Representation");
        this.textRepresentationMenuItem.setMnemonic(84);
        this.textRepresentationMenuItem.setDisplayedMnemonicIndex(10);
        this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
        this.textRepresentationMenuItem.addActionListener(this);
        m.add(this.textRepresentationMenuItem);
        this.descriptionMenuItem = new JMenuItem("View/Edit CSP Description");
        this.descriptionMenuItem.setMnemonic(68);
        this.descriptionMenuItem.setDisplayedMnemonicIndex(10);
        this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
        this.descriptionMenuItem.addActionListener(this);
        m.add(this.descriptionMenuItem);
        this.currentStateMenuItem = new JMenuItem("View Current State Text Representation");
        this.currentStateMenuItem.setMnemonic(67);
        this.currentStateMenuItem.setActionCommand(this.currentStateMenuItem.getText());
        this.currentStateMenuItem.addActionListener(this);
        m.add(this.currentStateMenuItem);
        this.currentStateMenuItem.setEnabled(false);
        return m;
    }

    protected JMenu createHelpMenu() {
        return new HelpMenu(appletName, this);
    }

    public void switchTab(String str) {
        super.switchTab(str);
        if (str.equals("Create")) {
            this.textRepresentationMenuItem.setText("View/Edit Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View/Edit CSP Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.currentStateMenuItem.setEnabled(false);
            this.setMode(false);
            this.csp.setMode(false);
            this.returnCanvas().setSubmode(3332);
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
            this.createButModes[3].setSelected(true);
        } else if (str.equals("Solve")) {
            this.textRepresentationMenuItem.setText("View Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View CSP Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.getUndoMenuItem().setEnabled(false);
            this.currentStateMenuItem.setEnabled(true);
            this.setMode(true);
            this.csp.setMode(true);
        }
    }

    protected JMenuItem getUndoMenuItem() {
        return this.undoItem;
    }

    protected void setMode(boolean solve) {
    }

    protected void closeTrace() {
    }

    public void load(File file) {
        try {
            this.fileName = file.getName();
            boolean xml = !this.fileName.substring(this.fileName.lastIndexOf(".") + 1).equals("txt");
            this.load(new BufferedReader(new FileReader(file)), xml);
        }
        catch (IOException e) {
            this.fileName = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(String dir, String fileName) {
        try {
            boolean xml;
            this.fileName = fileName;
            boolean bl = xml = !fileName.substring(fileName.lastIndexOf(".") + 1).equals("txt");
            if (this.applet != null) {
                this.load(new BufferedReader(new InputStreamReader(new URL(this.applet.getCodeBase() + dir + fileName).openStream())), xml);
            } else {
                this.load(new BufferedReader(new FileReader(String.valueOf(dir) + fileName)), xml);
            }
        }
        catch (IOException e) {
            fileName = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(BufferedReader in) {
        this.load(in, true);
    }

    public void load(BufferedReader in, boolean xml) {
        try {
            String line;
            StringBuffer allText = new StringBuffer();
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if (xml) {
                    allText.append(line).append("\n");
                }
                lines.add(line);
            }
            in.close();
            if (!xml) {
                this.setCNS = true;
                allText = new StringBuffer(IO.parseOld2XML(lines));
            }
            if (!this.updateCSPFromText(allText.toString())) {
                this.showMessage("Error", "Invalid File");
                return;
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (IOException e) {
            this.showMessage("Error", e.toString());
        }
    }

    protected void openGraph() {
        JFileChooser load = new JFileChooser();
        load.setFileSelectionMode(2);
        load.setLocation(0, 0);
        if (load.showOpenDialog(this) == 0) {
            this.closeTrace();
            File file = load.getSelectedFile();
            this.fileName = file.getName();
            this.saveProperties();
            this.load(file);
            this.restoreProperties();
            this.returnCanvas().autoscale();
            this.returnCanvas().repaint();
        }
    }

    protected void openLocation() {
        OpenLocationDialog openDialog = new OpenLocationDialog(this);
        if (openDialog.url != null) {
            try {
                this.load(new BufferedReader(new InputStreamReader(new URL(openDialog.url).openStream())), openDialog.url.endsWith(".xml"));
                this.fileName = openDialog.url.substring(openDialog.url.lastIndexOf("/") + 1);
            }
            catch (Exception exc) {
                this.showMessage("Error", exc.toString());
            }
        }
        this.getUndoMenuItem().setEnabled(false);
    }

    protected void createNewGraph() {
        super.createNewGraph();
        this.canvas.setSubmode(351);
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.reset();
    }

    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(IO.createXML(this.csp, false));
            out.close();
            this.fileName = file.getName();
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public boolean updateCSPFromText(String text) {
        int speed = ((CSPcanvas)this.canvas).getSpeed();
        CSP newcsp = this.getCSP();
        CSPcanvas newcanvas = this.getCanvas(newcsp);
        newcanvas.setSpeed(speed);
        newcsp.init(newcanvas);
        if (IO.parseXML(text, newcsp)) {
            this.set(newcanvas, newcsp, this.scrollPanel.getHorizontalScrollBar().getValue(), this.scrollPanel.getVerticalScrollBar().getValue());
            if (this.setCNS) {
                newcsp.setPosition();
            }
            this.canvas.autoscale();
            this.setCNS = false;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Create New CSP")) {
            this.createNewGraph();
        } else if (arg.equals("Load Sample CSP")) {
            this.loadSampleGraph();
        } else if (arg.equals("Save CSP")) {
            this.saveGraph();
        } else {
            if (e.getSource() == this.createButModes[0]) {
                this.canvas.setSubmode(351);
                this.setPromptLabel("Click the canvas to create a variable.");
                ((CSPcanvas)this.canvas).tempString = this.getExactPromptLabel();
                return;
            }
            if (e.getSource() == this.createButModes[1]) {
                this.canvas.setSubmode(350);
                this.setPromptLabel("Click the canvas to create an empty constraint.\nClick a variable to start creating a constraint,\n then click the canvas to create a unary constraint or another variable to create a binary constraint.");
                ((CSPcanvas)this.canvas).tempString = this.getExactPromptLabel();
                this.canvas.tempMode = 350;
                return;
            }
            if (e.getSource() == this.createButModes[2]) {
                this.canvas.setSubmode(352);
                this.setPromptLabel("Click on a variable or constraint to start creating an edge.");
                ((CSPcanvas)this.canvas).tempString = this.getExactPromptLabel();
                this.canvas.tempMode = 352;
                return;
            }
            if (arg.equals("Arrange Constraints")) {
                this.csp.setPosition();
                this.canvas.repaint();
            } else {
                if (arg.equals("Print")) {
                    this.returnCanvas().print();
                    this.returnCanvas().autoscale();
                    return;
                }
                if (arg.equals("Undo")) {
                    this.updateCSPFromText(this.oldTextRep);
                    this.getUndoMenuItem().setEnabled(false);
                } else if (arg.equals("View/Edit Text Representation")) {
                    new CSPTextFrame((CSPcanvas)this.canvas, IO.createXML(this.csp, false), "Text Representaion of the Graph", true);
                } else if (arg.equals("View Text Representation")) {
                    new CSPTextFrame((CSPcanvas)this.canvas, IO.createXML(this.csp, false), "Text Representaion of the Graph", false);
                } else if (arg.equals("View Current State Text Representation")) {
                    new CSPTextFrame((CSPcanvas)this.canvas, IO.createXML(this.csp, true), "Current State Text Representaion", false);
                } else if (arg.equals("View/Edit CSP Description")) {
                    new CSPDescriptionDialog((GraphWindow)this, this.csp, true).open();
                } else if (arg.equals("View CSP Description")) {
                    new CSPDescriptionDialog((GraphWindow)this, this.csp, false).open();
                }
            }
        }
        super.actionPerformed(e);
    }

    public static void main(String[] args) {
        new CSPWindow(null);
    }
}

