/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPWindow;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.IO;
import AIspace.cspTools.Relation;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.dialogs.RelationDialog;
import AIspace.cspTools.dialogs.VariableDialog;
import AIspace.cspTools.domains.DomainBoolean;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.HistogramNode;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSPcanvas
extends GraphCanvas {
    public String tempString;
    public static final int C_CREATE_CONSTRAINT = 350;
    public static final int C_CREATE_VARIABLE = 351;
    public static final int C_ADD_VAR = 352;
    protected CSP csp;
    protected boolean noInteraction = false;
    private VariableDialog variableDialog;
    private RelationDialog relationDialog;

    public CSPcanvas(Container parent, boolean inline, CSP csp) {
        super(parent, inline);
        this.submode = 351;
        this.csp = csp;
        this.graph = new CSPgraph(csp, this);
    }

    public void noInteraction(boolean bool) {
        this.noInteraction = bool;
    }

    @Override
    protected void popupCanvas(int x, int y) {
        if (this.mode == 2220) {
            this.popupCCanv();
        } else if (this.mode == 2221) {
            this.pop.removeAll();
            this.popupSCanv();
        }
        this.pop.show(this, x, y);
    }

    @Override
    protected void popupNode(int x, int y) {
        if (this.entClicked instanceof CSPVariable) {
            if (this.mode == 2220) {
                this.popupCVar(x, y);
            } else if (this.mode == 2221) {
                this.popupSVar(x, y);
            }
        } else if (this.mode == 2220) {
            this.popupCCns(x, y);
        } else if (this.mode == 2221) {
            this.popupSCns(x, y);
        }
    }

    @Override
    protected void popupEdge(int x, int y) {
    }

    public String parse(String str) {
        return "ERROR PARSE NOT IMPLEMENTED";
    }

    @Override
    public void disposeWindows() {
        super.disposeWindows();
    }

    protected void createVariable(Entity ent, Point p) {
        this.undo();
        if (ent != null) {
            return;
        }
        this.repaint();
        this.pause();
        DomainBoolean dom = new DomainBoolean();
        CSPVariable var = this.csp.newVariable(dom, (CSPgraph)this.graph, p);
        java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        this.variableDialog = new VariableDialog((JFrame)this.parent, var, this.csp, true, new Point(screenp.x, screenp.y));
        if (!this.variableDialog.isCancelled) {
            this.csp.addVariable(var);
            var.setLabel();
        }
        this.unpause();
        this.repaint();
    }

    @Override
    protected void undo() {
        if (!this.inline && ((CSPWindow)this.parent).getTabIndex() == 0) {
            ((CSPWindow)this.parent).oldTextRep = IO.createXML(this.csp, false);
            ((CSPWindow)this.parent).getUndoMenuItem().setEnabled(true);
        }
    }

    protected void createConstraint(Entity ent, Point p) {
        this.undo();
        this.repaint();
        this.pause();
        Constraint cns = this.csp.newConstraint((CSPgraph)this.graph, p, null, 1, this.csp);
        java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        this.relationDialog = new RelationDialog((JFrame)this.parent, null, cns, true, new Point(screenp.x, screenp.y));
        if (!this.relationDialog.isCancelled) {
            this.csp.addConstraint(cns);
            cns.setLabel();
        } else {
            cns.delete();
        }
        this.unpause();
    }

    protected void createConstraint(ArrayList<CSPVariable> variables) {
        this.repaint();
        this.pause();
        if (variables == null || variables.size() == 0) {
            System.out.println("ERROR NO VARIABLES");
            return;
        }
        float bottom = Float.MAX_VALUE;
        float left = Float.MAX_VALUE;
        float top = Float.MIN_VALUE;
        float right = Float.MIN_VALUE;
        for (Node node : variables) {
            if (node.pos.x < left) {
                left = node.pos.x;
            }
            if (node.pos.x > right) {
                right = node.pos.x;
            }
            if (node.pos.y < bottom) {
                bottom = node.pos.y;
            }
            if (!(node.pos.y > top)) continue;
            top = node.pos.y;
        }
        Point p = variables.size() > 1 ? new Point((left + right) / 2.0f, (top + bottom) / 2.0f) : new Point(left, top + 100.0f);
        Constraint constraint = this.csp.newConstraint((CSPgraph)this.graph, p, variables, 1, this.csp);
        java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        this.relationDialog = new RelationDialog((JFrame)this.parent, null, constraint, true, new Point(screenp.x, screenp.y));
        if (!this.relationDialog.isCancelled) {
            this.csp.addConstraint(constraint);
            constraint.setLabel();
        } else {
            constraint.delete();
        }
        this.unpause();
    }

    protected void createConstraint(ArrayList<CSPVariable> variables, Point p) {
        this.repaint();
        this.pause();
        if (variables.size() == 0) {
            System.out.println("ERROR NO VARIABLES");
            return;
        }
        Constraint cns = this.csp.newConstraint((CSPgraph)this.graph, p, variables, 1, this.csp);
        java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        this.relationDialog = new RelationDialog((JFrame)this.parent, null, cns, true, new Point(screenp.x, screenp.y));
        if (!this.relationDialog.isCancelled) {
            this.csp.addConstraint(cns);
            cns.setLabel();
        } else {
            cns.delete();
        }
        this.unpause();
    }

    protected final void createAConstraint(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
            this.makingEdge = 0;
            this.pause();
            this.to = (Node)ent;
            if (this.to != null) {
                if (!this.to.equals(this.from)) {
                    if (this.to instanceof Constraint && this.from instanceof CSPVariable) {
                        Constraint cns = (Constraint)this.to;
                        if (cns.addVariable((CSPVariable)this.from)) {
                            if (cns.openRD()) {
                                java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
                                SwingUtilities.convertPointToScreen(screenp, this);
                                new RelationDialog((JFrame)this.parent, cns.getRelation(), cns, true, new Point(screenp.x, screenp.y));
                            }
                            cns.setLabel();
                        }
                    } else if (this.to instanceof CSPVariable && this.from instanceof Constraint) {
                        Constraint cns = (Constraint)this.from;
                        if (cns.addVariable((CSPVariable)this.to) && cns.openRD()) {
                            java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
                            SwingUtilities.convertPointToScreen(screenp, this);
                            new RelationDialog((JFrame)this.parent, cns.getRelation(), cns, true, new Point(screenp.x, screenp.y));
                        }
                        cns.setLabel();
                    }
                }
                this.unpause();
                ((CSPWindow)this.parent).setPromptLabel("Click on a variable or constraint to start creating an edge.");
            } else {
                this.unpause();
                ((CSPWindow)this.parent).setPromptLabel("Click on a variable or constraint to start creating an edge.");
            }
        } else if (ent instanceof Node) {
            this.from = (Node)ent;
            if (this.from instanceof CSPVariable) {
                ((CSPWindow)this.parent).setPromptLabel("Click on a constraint to add the variable to it.");
            } else {
                ((CSPWindow)this.parent).setPromptLabel("Click on a variable to add it to the constraint.");
            }
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
        this.submode = 352;
    }

    protected void editVariable(CSPVariable var) {
        this.pause();
        java.awt.Point screenp = new java.awt.Point((int)var.pos.x, (int)var.pos.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        var.setNewVar(false);
        ArrayList<Constraint> varconstraints = var.getConstraints();
        boolean editvar = true;
        int i = 0;
        while (i < varconstraints.size()) {
            if (varconstraints.get(i).getRelation().getType().equals("Custom")) {
                editvar = false;
            }
            ++i;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.variableDialog = new VariableDialog((JFrame)this.parent, var, this.csp, editvar, new Point(screen.width / 2, screen.height / 2));
        if (!this.variableDialog.isCancelled) {
            ArrayList<Constraint> c = var.getConstraints();
            int i2 = 0;
            while (i2 < c.size()) {
                Constraint ce = c.get(i2);
                Relation rel = ce.getRelation();
                c.get(i2).setRelation(rel);
                AffirmPanel relPanel = rel.getEditPanel(true);
                relPanel.ok();
                ++i2;
            }
        }
        this.unpause();
    }

    protected void editConstraint(Constraint cns) {
        Relation rel = cns.getRelation();
        this.pause();
        java.awt.Point screenp = new java.awt.Point((int)cns.pos.x, (int)cns.pos.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.relationDialog = new RelationDialog((JFrame)this.parent, rel, cns, true, new Point(screen.width / 2, screen.height / 2));
        if (!this.relationDialog.isCancelled) {
            cns.setRelation(this.relationDialog.getRelation());
            cns.setLabel();
        }
        this.unpause();
    }

    protected void inspectVariable(CSPVariable var) {
        this.pause();
        java.awt.Point screenp = new java.awt.Point((int)var.pos.x, (int)var.pos.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        this.variableDialog = new VariableDialog((JFrame)this.parent, var, this.csp, false, new Point(screenp.x, screenp.y));
        if (!this.variableDialog.isCancelled) {
            this.csp.addVariable(var);
        }
        this.unpause();
    }

    protected void inspectConstraint(Constraint cns) {
        Relation rel = cns.getRelation();
        this.pause();
        java.awt.Point screenp = new java.awt.Point((int)cns.pos.x, (int)cns.pos.y);
        SwingUtilities.convertPointToScreen(screenp, this);
        this.relationDialog = !this.inline ? new RelationDialog((JFrame)this.parent, rel, cns, false, new Point(screenp.x, screenp.y)) : new RelationDialog(null, rel, cns, false, new Point(screenp.x, screenp.y));
        if (!this.relationDialog.isCancelled) {
            cns.setRelation(this.relationDialog.getRelation());
        }
        this.unpause();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.undo();
        if (this.noInteraction) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (ent == null && !e.isControlDown() && !e.isShiftDown()) {
            this.graph.deselectAll();
            if (this.pop.isVisible()) {
                this.pop.setVisible(false);
                return;
            }
        }
        super.mousePressed(e);
        if (e.getModifiers() == 4) {
            return;
        }
        if (this.mode == 2220) {
            if (this.submode == 351) {
                this.createVariable(ent, p);
            } else if (this.submode == 350) {
                if (this.makingEdge == 1) {
                    if (this.tmpMode != -1) {
                        this.submode = this.tmpMode;
                    }
                    this.tmpMode = -1;
                    this.makingEdge = 0;
                    if (ent == null || !(ent instanceof Node)) {
                        this.pause();
                        if (this.from instanceof CSPVariable) {
                            ArrayList<CSPVariable> tempVariable = new ArrayList<CSPVariable>(1);
                            tempVariable.add((CSPVariable)this.from);
                            this.createConstraint(tempVariable, p);
                        }
                        this.unpause();
                    } else {
                        this.pause();
                        this.to = (Node)ent;
                        if (!this.to.equals(this.from) && this.to instanceof CSPVariable && this.from instanceof CSPVariable) {
                            ArrayList<CSPVariable> tempvariables = new ArrayList<CSPVariable>(2);
                            tempvariables.add((CSPVariable)this.from);
                            tempvariables.add((CSPVariable)this.to);
                            this.createConstraint(tempvariables);
                        }
                    }
                    this.unpause();
                } else if (ent == null) {
                    this.createConstraint(ent, p);
                } else if (ent instanceof CSPVariable) {
                    this.from = (Node)ent;
                    this.makingEdge = 1;
                    this.mMovedPos.move(p);
                }
                ((CSPWindow)this.parent).setPromptLabel(this.tempString);
                this.submode = this.tempMode;
            } else if (this.submode == 352) {
                this.createAConstraint(ent, p);
                if (this.tempMode != this.submode) {
                    ((CSPWindow)this.parent).setPromptLabel(this.tempString);
                }
                this.submode = this.tempMode;
            } else if (this.submode == 3333 && ent != null) {
                this.deleteEnt(ent);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.noInteraction) {
            return;
        }
        super.mouseMoved(e);
        if (!(this.submode != 350 && this.submode != 352 || this.makingEdge != 1 || this.isDragging)) {
            this.mMovedPos.move(new Point(e.getX(), e.getY()));
            this.repaint();
        }
    }

    @Override
    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            Constraint cns;
            if (ent instanceof Constraint) {
                cns = (Constraint)ent;
                this.editConstraint(cns);
                ((CSPWindow)this.parent).setPromptLabel("");
            }
            if (ent instanceof CSPVariable) {
                CSPVariable var = (CSPVariable)ent;
                this.editVariable(var);
            }
            if (ent instanceof ConstraintEdge) {
                cns = ((ConstraintEdge)ent).getConstraint();
                this.editConstraint(cns);
            }
        }
    }

    @Override
    protected final void aPerformed(ActionEvent e) {
        if (this.noInteraction) {
            return;
        }
        if (this.mode == 2221) {
            this.aSolvePerformed(e);
        } else {
            super.aPerformed(e);
        }
        if (e.getActionCommand().equals("Autoscale")) {
            Iterator<Node> nodeItr = this.graph.getNodes();
            while (nodeItr.hasNext()) {
                Node n = nodeItr.next();
                if (!(n instanceof HistogramNode)) continue;
                ((HistogramNode)n).updatePosition();
            }
            return;
        }
    }

    protected void aSolvePerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Autoscale")) {
            this.autoscale();
        } else if (arg.equals("Arrange Constraints")) {
            this.csp.setPosition();
            this.repaint();
        }
        this.graph.deselectAll();
    }

    protected final void popupStands() {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        this.pop.add(new JLabel("View Options"));
        JMenuItem mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.addActionListener(this);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
        mItem = new JMenuItem("Arrange Constraints");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
    }

    protected final void popupCCanv() {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Create Options"));
        JMenuItem mItem = new JMenuItem("Create Variable");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        this.popupStands();
    }

    protected final void popupCCns(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Constraint Options"));
        JMenuItem mItem = new JMenuItem("Add Variable to Constraint");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Select Constraint");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Constraint");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Set Properties of Constraint");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected final void popupCVar(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Variable Options"));
        JMenuItem mItem = new JMenuItem("Create Constraint");
        mItem.setActionCommand("Start Constraint");
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Add Variable to Constraint");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Select Variable");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Variable");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Set Properties of Variable");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected final void popupCEdge() {
    }

    protected void popupSCanv() {
    }

    protected void popupSCns(int x, int y) {
    }

    protected void popupSVar(int x, int y) {
    }

    protected void popupSEdge() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand();
        if (arg == "Add Variable to Constraint") {
            this.tempMode = this.getSubmode();
            this.tempString = ((CSPWindow)this.parent).getExactPromptLabel();
            this.submode = 352;
            this.createAConstraint(this.entClicked, this.mClickedPos);
            if (this.entClicked instanceof CSPVariable) {
                ((CSPWindow)this.parent).setPromptLabel("Click on a constraint to add the variable to it.");
            } else {
                ((CSPWindow)this.parent).setPromptLabel("Click on a variable to add it to the constraint.");
            }
            this.submode = 352;
        } else if (arg == "Create Variable") {
            int tmpmode = this.getSubmode();
            this.tempString = ((CSPWindow)this.parent).getExactPromptLabel();
            this.submode = 351;
            ((CSPWindow)this.parent).setPromptLabel("Click the canvas to create a variable.");
            this.createVariable(this.entClicked, this.mClickedPos);
            ((CSPWindow)this.parent).setPromptLabel(this.tempString);
            this.submode = tmpmode;
        } else if (arg == "Start Constraint") {
            this.tempMode = this.getSubmode();
            this.tempString = ((CSPWindow)this.parent).getExactPromptLabel();
            this.from = (Node)this.entClicked;
            this.makingEdge = 1;
            this.mMovedPos.move(this.mClickedPos);
            ((CSPWindow)this.parent).setPromptLabel("Click the canvas to create a unary constraint or another variable to create a binary constraint.");
            this.submode = 350;
        } else if (arg == "Create Constraint") {
            this.tempMode = this.getSubmode();
            this.tempString = ((CSPWindow)this.parent).getExactPromptLabel();
            this.submode = 350;
            ((CSPWindow)this.parent).setPromptLabel("Click the canvas to create an empty constraint.\nClick a variable to start creating a constraint,\n then click the canvas to create a unary constraint or another variable to create a binary constraint.");
            this.createConstraint(this.entClicked, this.mClickedPos);
            ((CSPWindow)this.parent).setPromptLabel(this.tempString);
            this.submode = this.tempMode;
        } else if (arg.equals("Autoscale")) {
            this.autoscale();
        } else if (arg.equals("Arrange Constraints")) {
            this.csp.setPosition();
            this.repaint();
        } else if (arg.equals("Pan")) {
            this.setRMode(4440);
            if (!this.inline) {
                ((CSPWindow)this.parent).setPanZoom(1);
                ((CSPWindow)this.parent).setPromptLabel("Drag the right mouse button to pan the graph.");
            }
        } else if (arg.equals("Zoom")) {
            this.setRMode(4441);
            if (!this.inline) {
                ((CSPWindow)this.parent).setPanZoom(0);
                ((CSPWindow)this.parent).setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
            }
        }
    }

    @Override
    public void reset() {
        this.graph = new CSPgraph(this.csp, this);
        this.clearMouse();
        this.repaint();
    }

    public CSP getCSP() {
        return this.csp;
    }

    public int getSpeed() {
        return -1;
    }

    public void setSpeed(int speed) {
        System.err.println("Override setSpeed(int speed) from CSPcanvas in subclasses.");
    }

    public void setCSP(CSP c) {
        this.csp = c;
    }
}

