/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.dialogs;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPWindow;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.domains.DomainBoolean;
import AIspace.cspTools.domains.DomainChooser;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Point;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VariableDialog
extends BasicDialog {
    private CSPVariable var;
    private DomainDiscrete dom;
    private DomainDiscrete original;
    private AffirmPanel varPanel;
    private AffirmPanel domPanel;
    private DomainChooser domainChooser;
    public boolean isCancelled = true;
    private boolean isEditable;
    private JPanel p;
    private CSPWindow window;

    public VariableDialog(JFrame parent, CSPVariable var, CSP csp, boolean editable, Point loc) {
        super(parent, "Variable Properties", true);
        this.setSize(300, 400);
        this.window = (CSPWindow)parent;
        if (var == null) {
            return;
        }
        boolean edit = var.getEdit() && editable;
        this.isEditable = editable;
        this.var = var;
        this.dom = this.original = var.getDomain();
        this.varPanel = var.getPanel(csp);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridheight = 4;
        this.getContentPane().setLayout(this.gbl);
        if (this.dom == null) {
            this.dom = new DomainBoolean();
        }
        this.dom.updateDomain();
        this.domPanel = this.dom.getEditPanel(edit);
        this.domainChooser = new DomainChooser(this.dom);
        this.domainChooser.setVarDialog(this);
        Component[] domComponents = this.domPanel.getComponents();
        int i = 0;
        while (i < this.domPanel.getComponentCount()) {
            if (domComponents[i] instanceof JPanel) {
                Component[] innerComponents = ((JPanel)domComponents[i]).getComponents();
                int j = 0;
                while (j < ((JPanel)domComponents[i]).getComponentCount()) {
                    innerComponents[j].setEnabled(editable);
                    ++j;
                }
            } else {
                domComponents[i].setEnabled(editable);
            }
            ++i;
        }
        Component[] domChooserComponents = this.domainChooser.getComponents();
        int i2 = 0;
        while (i2 < this.domainChooser.getComponentCount()) {
            if (domChooserComponents[i2] instanceof JPanel) {
                Component[] innerComponents = ((JPanel)domChooserComponents[i2]).getComponents();
                int j = 0;
                while (j < ((JPanel)domChooserComponents[i2]).getComponentCount()) {
                    innerComponents[j].setEnabled(editable);
                    ++j;
                }
            } else {
                domChooserComponents[i2].setEnabled(editable);
            }
            ++i2;
        }
        this.p = new JPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.p.add(ok);
        this.p.add(cancel);
        this.addComponent(this.varPanel, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.domainChooser, this, 1, 0, -1, 1, 1.0, 1.0);
        this.addComponent(this.domPanel, this, 2, 0, -1, 2, 1.0, 1.0);
        this.addComponent(this.p, this, 4, 0, -1, 1, 0.0, 0.0);
        this.pack();
        this.ensureOnScreen(loc);
        this.setVisible(true);
    }

    public void setDomain(DomainDiscrete domain) {
        this.getContentPane().removeAll();
        this.dom = domain;
        this.domPanel = this.dom.getEditPanel(this.isEditable);
        this.addComponent(this.varPanel, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.domainChooser, this, 1, 0, -1, 1, 1.0, 1.0);
        this.addComponent(this.domPanel, this, 2, 0, -1, 2, 1.0, 1.0);
        this.addComponent(this.p, this, 4, 0, -1, 1, 0.0, 0.0);
        this.validate();
    }

    protected boolean actionOK() {
        if (!this.domPanel.ok()) {
            this.window.showMessage("Domain Error", "Domain needs to have at least one valid value.");
            return false;
        }
        if (this.dom.getDomainSize() <= 0) {
            this.window.showMessage("Domain Error", "No valid values entered for domain.");
            return false;
        }
        if (!this.var.isNewVar() && !this.var.getOriginalName().equals(this.varPanel.returnText())) {
            if (!this.varPanel.ok()) {
                return false;
            }
        } else if (!this.var.isNewVar()) {
            this.varPanel.okNoCheck();
        } else if (!this.varPanel.ok()) {
            return false;
        }
        this.var.setDomain(this.dom);
        this.var.setLabel();
        this.isCancelled = false;
        return true;
    }

    protected boolean actionCancel() {
        if (this.var.isNewVar()) {
            this.varPanel.cancel();
        }
        this.domPanel.cancel();
        this.var.setDomain(this.original);
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getSource().equals(this.domainChooser)) {
            super.actionPerformed(e);
        }
    }
}

